#include <conio.h>
#include <stdio.h>
#include <dos.h>

#include "sb.h"

/* Card parameters */
unsigned SbIOaddr;
unsigned SbIRQ;
unsigned SbDMAchan;
int	SbType;

extern void WriteFM(int chip, int addr, unsigned char data);

#define __CPPARGS ...

volatile int T_lej = 0;
void interrupt handler(__CPPARGS);
void interrupt ( *oldhandler)(__CPPARGS);

static FM_Instrument instrument = {
    0x11, 0x01, 0x8a, 0x40,
    0xf1, 0xf1, 0x11, 0xb3,
    0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00
};

//                 C#    D     D#     E    F     F#
int notes[12] = {0x16B,0x181,0x198,0x1B0,0x1CA,0x1E5,
		 0x202,0x220,0x241,0x263,0x287,0x2AE};
//                 G     G#    A     A#     B    C

// hangok : 0   1   2    3   4   5    6   7    8   9   A   B
//          C#  D   D#   E   F   F#   G   G#   A   A#  B   C

    //   hangjegy     oktav:hang
#define  _c         0x020B
#define  _d         0x0301
#define  _e         0x0303
#define  _f         0x0304
#define  _fis       0x0305
#define  _g         0x0306
#define  _gis       0x0307
#define  _a         0x0308
#define  _b         0x0309
#define  _h         0x030A

#define  c          0x030B
#define  cis        0x0400
#define  d          0x0401
#define  dis        0x0402
#define  e          0x0403
#define  f          0x0404
#define  fis        0x0405
#define  g          0x0406
#define  gis        0x0407
#define  a          0x0408
#define  b          0x0409
#define  h          0x040A

#define  c_         0x040B
#define  d_         0x0501
#define  dis_       0x0502
#define  e_         0x0503
#define  f_         0x0504

#define musiclen 576

unsigned music[musiclen]
    = {
     _c,e,e, _c,g,0, _e,c_,c_, _e,e,0, _g,g,g, _g,c_,0, _a,e,e, _a,g,0,
     _b,c_,c_, _b,e,0, _a,g,0, _a,c_,c_, _g,0,0, _g,e_,e_, _e,0,0, _e,e_,e_,
     _c,e,e, _c,g,0, _e,c_,c_, _e,e,0, _g,g,g, _g,c_,0, _a,e,e, _a,g,0,
     _b,c_,c_, _b,e,0, _a,g,0, _a,c_,c_, _g,0,0, _g,e_,e_, _e,0,0, _e,e_,e_,

     _f,f,f,_f,a,0,_a,c_,c_,_a,f,0, c,a,a, c,c_,0, d,f,f, d,a,0,
     dis,c_,c_,dis,f,0, d,a,0, d,c_,c_, c,0,0, c,f_,f_,_a,0,0,_a,f_,f_,
     _c,e,e, _c,g,0, _e,c_,c_, _e,e,0, _g,g,g, _g,c_,0, _a,e,e, _a,g,0,
     _b,c_,c_, _b,e,0, _a,g,0, _a,c_,c_, _g,0,0, _g,e_,e_, _e,0,0, _e,e_,e_,

     _g,g,g, _g,h,0, _h,d_,d_, _h,g,0, d,h,h, d,d_,0, e,g,g, e,h,0,
      f,d_,d_,  f,g,0,  e,h,0,  e,d_,d_, d,0,0, d,d_,d_,_h,0,0,_h,d_,d_,

      _c,c_,c_, _c,g,0, _e,g,g, _e,g,0, _g,fis,fis, _g,g,0, _a,a,a, _a,h,h,
      _b,c_,c_, _b,e,0, _a,g,0, _a,c_,c_,_g,0,0,_g,0,0,_e,0,0,_e,0,0,

      _c,c_,c_, _c,0,0, _e,a,a, _e,c_,c_, _g,0,0, _g,0,0, _a,dis_,dis_, _a,d_,d_,
      _b,0,0, _b,g,0, _a,a,0, _a,c_,0,_g,e_,e_,_g,0,0,_e,e_,e_,_e,0,0,

      _c,c_,c_, _c,0,0, _e,a,a, _e,c_,c_, _g,0,0, _g,0,0, _a,dis_,dis_, _a,d_,d_,
      _b,0,0, _b,g,0, _a,a,0, _a,c_,0,_g,e_,e_,_g,0,0,_e,e_,e_,_e,0,0,


      _f,c_,c_, _f,0,0, _a,a,a, _a,c_,c_,  c,0,0,  c,0,0,  d,dis_,dis_,  d,d_,d_,
      dis,0,0, dis,g,0,  d,a,0,  d,c_,0, c,e_,e_, c,0,0,_a,e_,e_,_a,0,0,

      _c,c_,c_, _c,0,0, _e,a,a, _e,c_,c_, _g,0,0, _g,0,0, _a,dis_,dis_, _a,d_,d_,
      _b,0,0, _b,g,0, _a,a,0, _a,c_,0,_g,e_,e_,_g,0,0,_e,e_,e_,_e,0,0,

      _g,c_,c_, _g,0,0, _h,a,a, _h,c_,c_, d,0,0, d,0,0, e,dis_,dis_, e,d_,d_,
       f,0,0,  f,g,0,  e,a,0,  e,c_,0, d,e_,e_, d,0,0,_h,e_,e_,_h,0,0,

       _c,c_,c_, _c,0,0, _e,a,a, _e,c_,c_, _g,0,0, _g,0,0, _a,dis_,dis_, _a,d_,d_,
       _b,0,0, _b,g,0, _a,a,0, _a,c_,0,_g,e_,e_,_g,0,0,_e,e_,e_,_e,0,0
     };


void main ( void )
{
 SbIOaddr = 0x220;

 long far *tim,t1,t2;
 tim = (long far *)MK_FP(0,0x046C);

 /*
 oldhandler = getvect(0x8);
 setvect(0x8,handler);

 getch();

 T_lej=0;
 printf("\r\n%li\r\n",(t1=*tim));
 WriteFM(0, 4,1<<7);
 WriteFM(0, 4,0 );
// WriteFM(0, 4,0); Reset flags for timers
 WriteFM(0, 3,0); //Timer 2 data

 WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

 do
  {
   printf("%d|",T_lej);
  }
 while ( T_lej<100 );
 setvect(0x08,oldhandler);
 printf("\r\n\nOK!");
 printf("\r\n%li",(t2=*tim));
 printf("  %li",t2-t1);
 getch();
 */


// if(GetSBParams(&SbIOaddr,&SbIRQ,&SbDMAchan))
 //{
 //    puts("BLASTER environment variable not set.");
 //    exit(1);
 //}

 Sb_FM_Reset();

 int xx;
 for (xx=0 ; xx<=11 ; xx++)
  Sb_FM_Set_Voice(xx,&instrument);

 Sb_FM_Set_Voice(1,&instrument);
 Sb_FM_Set_Voice(11,&instrument);

 Sb_FM_Key_On(0,notes[11],2);
 Sb_FM_Key_On(1,notes[3],3);
 Sb_FM_Key_On(11,notes[6],3);

 getch();

 int cc;
 int cd=0;
 int ce=0;

 for ( cc=0 ; cc<=musiclen ; cc++ )
  {
   //if (ce==12) ce=0;
   //if (cd==12) cd=0;

   if (music[cc]==0)
    {
     Sb_FM_Key_Off(0);
     //Sb_FM_Key_Off(1);
     //Sb_FM_Key_Off(2);
    }
   else
    {
     //Sb_FM_Key_Off(0);
     Sb_FM_Key_On(0,notes[music[cc]&0xFF],music[cc]>>8);
     //Sb_FM_Key_On(1,notes[(music[cc]&0xFF + 4)%12],(music[cc]>>8)+1);
     //Sb_FM_Key_On(2,notes[(music[cc]&0xFF + 7)%12],(music[cc]>>8)+1);
    }
   delay(55);
   if (kbhit())
    break;
  }

 Sb_FM_Key_Off(0);
 Sb_FM_Key_Off(1);
 Sb_FM_Key_Off(11);

 Sb_FM_Reset();

}

void interrupt handler(__CPPARGS)
{
 int val;

 val=inp(SbIOaddr);
 if ( val & (1<<7) )
  {
   T_lej++;
   WriteFM(0, 4,1<<7);
   WriteFM(0, 3,0);
   WriteFM(0, 4,0);
   WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

   asm MOV AL,0x20
   asm OUT 0x20,AL // send end-of-int
  }
 else
  oldhandler();
}