#include <conio.h>
#include <stdio.h>
#include <dos.h>

#include "sb.h"

/* Card parameters */
unsigned SbIOaddr;
unsigned SbIRQ;
unsigned SbDMAchan;
int	SbType;

extern void WriteFM(int chip, int addr, unsigned char data);

#define __CPPARGS ...

volatile int T_lej = 0;
void interrupt handler(__CPPARGS);
void interrupt ( *oldhandler)(__CPPARGS);

void main ( void )
{
 SbIOaddr = 0x220;

 long far *tim,t1,t2;
 tim = (long far *)MK_FP(0,0x046C);

 oldhandler = getvect(0x8);
 setvect(0x8,handler);

 getch();

 T_lej=0;
 printf("\r\n%li\r\n",(t1=*tim));
 WriteFM(0, 4,1<<7);
 WriteFM(0, 4,0 );
// WriteFM(0, 4,0); Reset flags for timers
 WriteFM(0, 3,0); //Timer 2 data

 WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

 do
  {
   printf("%d|",T_lej);
  }
 while ( T_lej<100 );
 setvect(0x08,oldhandler);
 printf("\r\n\nOK!");
 printf("\r\n%li",(t2=*tim));
 printf("  %li",t2-t1);
 getch();
}

void interrupt handler(__CPPARGS)
{
 int val;

 val=inp(SbIOaddr);
 if ( val & (1<<7) )
  {
   T_lej++;
   WriteFM(0, 4,1<<7);
   WriteFM(0, 3,0);
   WriteFM(0, 4,0);
   WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

   asm MOV AL,0x20
   asm OUT 0x20,AL // send end-of-int
  }
 else
  oldhandler();
}