#include <dos.h>
#include <mem.h>
#include <fcntl.h>
#include <conio.h>
#include <io.h>
#include <stdio.h>
#include "romcheck.h"


const char crcid[2] = { '','' };
const char crcnew[2] = { '','' };
const char mdv[10] = { 2,3,5,7,11 };



/************************************
int rom_crc_check( char *cfname ); ***
                                    ***
void main ( int argc, char *argv[] ) ***
{                                     *****
 if (rom_crc_check( argv[0] )==-1)      *****
  printf("Copy protection error !\n\r"); ******
 else                                    *****
  printf("OK !\n\r");                   **
}                       *****************
***************************/

unsigned long VER_CODE = 0x4F30lu;

void  get_rom_crc_code( char *ctmb )
{
 unsigned long ccs[11];
 char far *m_BIOS;
 long c,d;

 m_BIOS=(char far *)MK_FP(0xF000,0);

 for ( c=0 ; c<=4 ; c++ )
  {
   ccs[c] = 0;
   for ( d = 0 ; d <= 10000 ; d++)  ccs[c]+=m_BIOS[d] % mdv[c];
  }

 memcpy( ctmb, &ccs[0] , 5*sizeof(ccs[0]) );
}

unsigned long code_value( unsigned long tc )
{
 return( ((tc ^ VER_CODE) ^ 0xFAEB) );
}

unsigned long decode_value( unsigned long tc )
{
 return( ((tc^0xFAEB) ^ VER_CODE) );
}


int rom_crc_check( char *cfname , int do_always )
{
 int checkfile;
 char fbf[100];
 unsigned long crcs[2][5];
 unsigned long sumtomb[11];
 char far *m_BIOS;
 long c,d;

 //m_BIOS=(char far *)MK_FP(0xF000,0);

 if ((checkfile=open( cfname , O_RDWR | O_BINARY ))==-1 )
  return(-1);

 lseek(checkfile, filelength(checkfile)-2, SEEK_SET );
 fbf[0]=0; fbf[1]=0;
 read(checkfile,fbf,2);

 if ( fbf[0]==crcid[0] && fbf[1]==crcid[1] )
  {
   lseek(checkfile, filelength(checkfile)-(2l+5*4l) , SEEK_SET );
   for ( c=0 ; c<=4 ; c++ )
    {
     read( checkfile , &(crcs[1][c]) , 4 );
     crcs[1][c] = decode_value(crcs[1][c]);
    }

   get_rom_crc_code( &((char)sumtomb[0]) );

   for ( c=0 ; c<=4 ; c++ )
    if ( sumtomb[c]!=crcs[1][c] )
     {
      close(checkfile);
      return( -1 );
     }
  }
 else
  if ( (fbf[0]==crcnew[0] && fbf[1]==crcnew[1]) || ( do_always ) )
   {
    lseek(checkfile, filelength(checkfile), SEEK_SET );

    get_rom_crc_code( &((char)crcs[0][0]) );

    for ( c=0 ; c<=4 ; c++ )
     crcs[0][c] = code_value(crcs[0][c]);

    for ( c=0 ; c<=4 ; c++ )
     write(checkfile,&(crcs[0][c]),4);

    write(checkfile,crcid,2);
   }
  else
   {
    close(checkfile);
    return(-1);
   }

 close(checkfile);
 return(0);
}


