#include <dos.h>
#include <alloc.h>
#include <stdio.h>
#include <process.h>
#include <graphics.h>

extern "C" void far far_VGA256_driver( void );

void fadein( char *pl, int steps )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 REGPACK reg;

 int i,d;

 register int ms;
 ms=steps;

 for ( d=1 ; d<=ms ; d++ )
  {
   for (i=0; i<=255; i++)
    {
     pt[i].r=((pl[3*i]*d)/ ms );
     pt[i].g=((pl[3*i+1]*d)/ms );
     pt[i].b=((pl[3*i+2]*d)/ms );
    }

   asm {
          push ax
     	  push dx

          mov dx,0x3DA
     	 }
   LM1:
   asm {
          in al,dx    // Wait for retrace interval
          test al,8
          jz LM1
         }
   asm pop dx
   asm pop ax

   for (i=0; i<=255; i++)
    {
     disable();
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
     enable();
    }

   //delay(10);
  }
}

void steppalette( char *pl, int currs, int maxs )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf,i;

 for (i=0; i<=255; i++)
  {
   pt[i].r=((pl[3*i]*currs)/ maxs );
   pt[i].g=((pl[3*i+1]*currs)/maxs );
   pt[i].b=((pl[3*i+2]*currs)/maxs );
  }

 asm {
        push ax
     	push dx

        mov dx,0x3DA
       }
 LM1:
 asm {
        in al,dx    // Wait for retrace interval
        test al,8
        jz LM1
       }
 asm pop dx
 asm pop ax

 for (i=0; i<=255; i++)
  {
   disable();
   outportb(0x3C8,i);

   outportb(0x3C9,pt[i].r);
   outportb(0x3C9,pt[i].g);
   outportb(0x3C9,pt[i].b);
   enable();
  }

}


void fadeout( char *pl , int steps )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 REGPACK reg;

 int i,d;

 register int ms;
 ms=steps;

 asm {
      push ax
      push dx
      mov dx,0x3DA
     }
 LM1:
 asm {
      in al,dx    // Wait for retrace interval
      test al,8
      jz LM1
     }
 asm pop dx
 asm pop ax

 for ( d=ms ; d>=1 ; d-- )
  {
   for (i=0; i<=255; i++)
    {
     pt[i].r=((pl[3*i]*d)/ ms );
     pt[i].g=((pl[3*i+1]*d)/ms );
     pt[i].b=((pl[3*i+2]*d)/ms );
    }

   for (i=0; i<=255; i++)
    {
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
    }

   //delay(10);
  }
}

void clearpalette( void )
{
 int i;
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 for (i=0; i<=255; i++)
  {
   pt2.r=0;
   pt2.g=0;
   pt2.b=0;

   outportb(0x3C8,i);

   outportb(0x3C9,pt2.r);
   outportb(0x3C9,pt2.g);
   outportb(0x3C9,pt2.b);
  }
}


void makepalette( char *pl )
{
 int i;
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 for (i=0; i<=255; i++)
  {
   pt2.r=(pl[3*i]);
   pt2.g=(pl[3*i+1]);
   pt2.b=(pl[3*i+2]);

   outportb(0x3C8,i);

   outportb(0x3C9,pt2.r);
   outportb(0x3C9,pt2.g);
   outportb(0x3C9,pt2.b);
  }
}


void convertpalette( char *pl )
{
 int i;
 for (i=0; i<=255; i++)
  {
   pl[3*i]/=4;
   pl[3*i+1]/=4;
   pl[3*i+2]/=4;
  }
}

int VGA256init( void )
{
 int gdriver, gmode;

 /* install a user written device driver */
 gdriver = installuserdriver("VGA256", NULL );

 if ( registerfarbgidriver( far_VGA256_driver )==-1 )
  {
   //printf("Error with linked-in VGA driver !\n\r");
   //exit(1);
   return(-2);
  }

 int gdnum;

 gdnum = gdriver ;

 ///* must force use of detection routine */
 //gdriver = DETECT;

 detectgraph(&gdriver,&gmode);

 if (!( gdriver==MCGA || gdriver==VGA ))
  {
   //printf("This video card is incapable of 320 x 200, 256 Col. graphics, mode 13x!\r\n");
   return(-1);//exit(1);
  }

 /* initialize graphics and local variables */
 gdriver = gdnum;
 initgraph(&gdriver, &gmode, "");

 if ( graphresult() != grOk )
  {
   //printf("Error initializing Mode 13x !\r\n");
   //exit(1);
   return(-1);
  }

 return(gdnum);
}



void ScreenOrigin(int x,int y)
{

 unsigned st;
 st = (x + y * (long)320)/4;

/*
 asm PUSH DX
 asm MOV DX,0x3DA
 L20:
 asm {		 in	al,dx		// wait for start of vertical retrace
		 test	al,8
		 jz	L20
     }
 L21:
 asm {		 in	al,dx		// wait for end of vertical retrace
		 test	al,8
		 jnz	L21
     }
 asm POP DX
*/
 disable();
 outportb( 0x3D4,0x0C );
 outportb( 0x3D5,((char*)&st)[1] ); // start address high
 outportb( 0x3D4,0x0D );
 outportb( 0x3D5,((char*)&st)[0] ); // start address low
 enable();


 asm PUSH DX
 asm MOV DX,0x3DA
 L22:
 asm { 	         in	al,dx		// wait for start of vertical retrace
		 test	al,8
		 jz	L22
     }
 asm POP DX

 disable();
 outportb( 0x3D4,8 );
 outportb( 0x3D5,0 ); //??????

 outportb( 0x3C0,0x013 | 0x20 ); // a 0x20 minek!?
 outportb( 0x3C0,(x % 4) * 2 );
 enable();
}

void fadethru( char *pl_from, char *pl_to , int steps )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;
 int kl;

 REGPACK reg;

 int i,d;

 register int ms;
 ms=steps;

 for ( d=1 ; d<=ms ; d++ )
  {
   for (i=0; i<=255; i++)
    {
     kl=(((long)(pl_to[3*i]-pl_from[3*i]))*d)/ms;
     pt[i].r=pl_from[3*i] + kl;

     kl=(((long)(pl_to[3*i+1]-pl_from[3*i+2]))*d)/ms;
     pt[i].g=pl_from[3*i+1] + kl;

     kl=(((long)(pl_to[3*i+2]-pl_from[3*i+2]))*d)/ms;
     pt[i].b=pl_from[3*i+2] + kl;

    // if (i==10)
    //  { /* record it */ cnt++; rct[cnt]=  }
    }

   asm {
          push ax
     	  push dx

          mov dx,0x3DA
     	 }
   LM1:
   asm {
          in al,dx    // Wait for retrace interval
          test al,8
          jz LM1
         }
   asm pop dx
   asm pop ax

   for (i=0; i<=255; i++)
    {
     disable();
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
     enable();
    }

   //delay(10);
  }
}



//-------------------------------------------------//

struct NSS_Pal
 {
  char *pal;
  //char fx; // 0-Fade out, 1-Fade in
  int from; // mettol
  int to; // meddig

  char exnum; // exclude area number : 0-none, 1-10
  char ex[10+1][2]; // exclude areas in form {{from,to},{from,to},...}

 }
  ;


void fadeout( NSS_Pal spp )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 REGPACK reg;

 int i,d;

 register int ms;
 //ms=steps;

 asm {
      push ax
      push dx
      mov dx,0x3DA
     }
 LM1:
 asm {
      in al,dx    // Wait for retrace interval
      test al,8
      jz LM1
     }
 asm pop dx
 asm pop ax

 signed char ir = (spp.to>spp.from) ? 1 : -1 ;
 ms=(spp.to-spp.from) * ir;
 int cnt,cb1,cb2;

 for (d=spp.from ; d!=spp.to ; d+=ir )
  for (cnt=0 ; cnt<=spp.exnum ; cnt++ )
   {
    cb1=(cnt==0)?0:spp.ex[cnt-1][1]-1;
    cb2=(cnt==spp.exnum)?255:spp.ex[cnt][0]+1;
    for ( i=cb1 ; i!=cb2 ; i++ )
     {
      pt[i].r=((spp.pal[3*i]*d)/ ms );
      pt[i].g=((spp.pal[3*i+1]*d)/ms );
      pt[i].b=((spp.pal[3*i+2]*d)/ms );
     }

    for ( i=cb1 ; i!=cb2 ; i++ )
     {
      outportb(0x3C8,i);

      outportb(0x3C9,pt[i].r);
      outportb(0x3C9,pt[i].g);
      outportb(0x3C9,pt[i].b);
     }
   }
}
