#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <dos.h>
#include <mem.h>

#define NETINT 0x7A

#define SL_STAYTERMINATE  0x00 // socket till program terminates or closes it
#define SL_STAYCLOSE      0xFF // till close

#define REQ_DYNAMIC 0x0000
#define SC_OK          0x00
#define SC_ALREADYOPEN 0xFF
#define SC_TABLE_FULL  0xFE

struct iaddr
 {
  char netnum[4];
  char nodeaddr[6];
  int socket;
 };

struct imaddval
 {
  char ecb[6];
 };

struct sdfrag
 {
  char far *addr;
  int size;
 };

struct packhead
 {
  int chksum;
  int length;
  char transport_ctrl;
  char packet_type;
  iaddr dest;
  iaddr source;
 };

#define MAXFRAGS 10
struct ecb
 {
  char far *link;
  char far *ESR_address;
  char in_use;
  char compl_code;
  int socket;
  char wspace1[4];
  char wspace2[12];
  struct imaddval iav;
  int fragment_count;
  struct sdfrag dfrag[MAXFRAGS];
 };

struct iaddr t1={{0,0,0,2}, {0x02,0x60,0x8c,0x99,0xf9,0x1e}};
struct iaddr t1x={{0,0,0,2}, {0x02,0x60,0x8c,0x99,0xf9,0x1e}};

int gettimemark(void)
{
 union REGS regs;

 regs.x.bx = 8;
 int86(NETINT, &regs, &regs);
 return regs.x.ax;
}

int getiaddress( struct iaddr *ia ) // not full addr! full address contains
{                                   // socket also
 union REGS regs;
 struct SREGS segregs;

 char far *p;

 regs.x.bx = 9;
 segregs.es = FP_SEG(ia);
 regs.x.si = FP_OFF(ia);
 int86x(NETINT, &regs, &regs, &segregs);
 //ia->socket = 0;
 //p=(char far *)MK_FP(segregs.es,regs.x.si);
 //_fmemcpy(ia,p,sizeof(iaddr));
}

int opensocket( int socket_longevity, int *req_socket )
{
 union REGS regs;

 regs.x.bx = 0;
 regs.h.al=socket_longevity;
 regs.x.dx=(*req_socket);
 int86(NETINT, &regs, &regs);
 (*req_socket)=regs.x.dx;

 return regs.h.al;
}

int listen_packet( struct ecb *ec )
{
 union REGS regs;
 struct SREGS segregs;

 regs.x.bx = 4;
 segregs.es = FP_SEG(ec);
 regs.x.si = FP_OFF(ec);
 int86x(NETINT, &regs, &regs, &segregs);

 return regs.h.al;
}

int getltarget( struct iaddr *ia, struct imaddval *iav, int *ttime )
{
 union REGS regs;
 struct SREGS segregs;

 regs.x.bx = 2;
 segregs.es = FP_SEG(ia);
 regs.x.si = FP_OFF(ia);
 regs.x.di = FP_OFF(iav);
 int86x(NETINT, &regs, &regs, &segregs);
 *ttime=regs.x.cx;

 return regs.h.al;
}

int main(void)
{
 struct iaddr ad;
 iaddr myaddr;
 struct imaddval iav;
 struct ecb ec;
 int sc;
 int c,d,x;

 printf("Time code: %d\r\n",gettimemark());
 getiaddress(&myaddr);

 sc=0x1004;
 x=opensocket(SL_STAYTERMINATE,&sc);

 ad=t1x;
 ad.socket=sc;
 x=getltarget(&ad,&iav,&c);
 ec.iav=iav;

 packhead ph;
 memset(&ph,0,sizeof(ph));

 ph.chksum=0;
 ph.packet_type=0;
 ph.length=0xC800; //200;

 //char far f1[200];

 char far *f1;

 f1=(char far *)farmalloc(200);

 memset(&ec,0,sizeof(ec));
 ec.fragment_count=1;
 ec.dfrag[0].size=200;
 ec.dfrag[0].addr=f1;
 ec.socket=0x1004;

 _fmemcpy(f1,&ph,sizeof(ph));
 char *st="Hello worllld!!";
 _fmemcpy(f1+sizeof(ph),st,strlen(st)+1);

 listen_packet(&ec);


 while (ec.in_use)
  printf("Time code: %d\r\n",gettimemark());



 //ph.source=;
 //ph.dest=;

 //char *pp;

 return 0;
}
