/*
   Must call mouse_installed at beginning !!!
*/

typedef struct
 {
  unsigned int screenmask[16];
  unsigned int cursormask[16];
  int hotx,hoty;
 }
  mcursor ;

#define MNOCURSOR  0
#define  MHCURSOR  1
#define  MSCURSOR  2

#define LBUTTON 0
#define RBUTTON 1
#define MBUTTON 2

int mouse_installed( void );
int m_present( void );
int m_cur_state( void );
void define_graphic_cursor( mcursor crs );

void enable_software_cursor( void );
void enable_set_software_cursor( unsigned andmask=0, unsigned xormask=0 );
void enable_hardware_cursor( int start,int stop );
void disable_cursor( void );

void read_mouse_position( int* x , int* y );
int mouse_x_position( void );
int mouse_y_position( void );

int   left_button_pressed( void );
int  right_button_pressed( void );
int middle_button_pressed( void );

void set_mouse_position( int x, int y );
void button_state( int* b, int* x, int* y );
void button_release_state(  int* b, int* x, int* y );

void mouse_window( int x1,int y1,int x2,int y2 );
void mouse_move( int* x, int* y );
void enable_light_pen_emulation( void );
void disable_light_pen_emulation( void );
void mouse_sensivity( int x,int y );
void double_speed_mode( int v );
void disable_double_speed_mode( void );

void m_show( void );
void m_hide( void );

void m_sshow( void );
void m_shide( void );

void m_setcursor( int curnum );
void set_use_cursor( int num , int andm, int xorm );

void set_mouse_page( int pg );
void set_exclusion_area(int x1,int y1 ,int x2,int y2);

void mousehinstall( void );
void mousehdeinstall( void );
void far mouseh( void );


#define MC_NORMAL 0
#define MC_WAIT   1
