/*  MOUSE.CPP

   Noll Jnos
    1992/93
*/

#include <dos.h>
#include <graphics.h>
#include "..\mouse.h"

int far m_stat=-1;

int MousePresent = 0;
int MCursorState = 0;
int MCS_Save=-1;

int m_cursors[15][2];

unsigned far msx,msy;
int far ls=0;
unsigned far msx2,msy2;

/**********************************************/

void m_setcursor( int curnum )
{
 if ( curnum>15 || curnum<0 )
  return;
 enable_set_software_cursor(m_cursors[curnum][0],m_cursors[curnum][1]);
 MCS_Save=-1;
 m_show();
}

void set_use_cursor( int num, int andm, int xorm )
{
 if ( num>15 || num<0 )
  return;
 m_cursors[num][0]=andm;
 m_cursors[num][1]=xorm;
}

int mouse_installed( void )
{
 REGS regs;

 //regs.x.ax = 0;
 //int86(0x33,&regs,&regs);
 //MousePresent=(regs.x.ax != 0);

 asm push ax
 asm push bx
 asm mov ax,0
 asm int 0x33
 MousePresent = (_AX != 0);
 asm pop bx
 asm pop ax

 return( MousePresent );
}

void define_graphic_cursor( mcursor crs )
{
 if ( MousePresent == 0 ) return;

 /*
 REGPACK r;

 r.r_ax = 9;
 r.r_es = FP_SEG(&crs);
 r.r_dx = FP_OFF(&(crs));
 r.r_bx = crs.hotx;
 r.r_cx = crs.hoty;
 intr(0x33,&r);
 */
 int xx1,xx2;

 asm push ax
 asm push bx
 asm push cx
 asm push dx
 asm push es

 xx1 = FP_SEG(&crs);
 xx2 = FP_OFF(&(crs));

 asm mov ax,9
 asm mov es,xx1
 asm mov dx,xx2
 _BX = crs.hotx;
 _CX = crs.hoty;
 asm int 0x33

 asm pop es
 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax
}

void enable_software_cursor( void )
{
 if ( MousePresent == 0 ) return;

 /*
 REGS r;

 r.x.ax = 1;
 int86(0x33,&r,&r);
 r.x.ax = 10;
 r.x.bx = 0;
 r.x.cx = 0xFFFF;
 r.x.dx = 0x7700;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,1
 asm int 0x33
 asm mov ax,0x0A
 asm mov bx,0
 asm mov cx,0xFFFF
 asm mov dx,0x7700
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 MCursorState = MSCURSOR;
 m_stat=0;
}

void enable_set_software_cursor( unsigned andmask, unsigned xormask )
{
 if ( MousePresent == 0 ) return;

 /*
 REGS r;

 r.x.ax = 1;
 int86(0x33,&r,&r);
 r.x.ax = 10;
 r.x.bx = 0;
 r.x.cx = andmask;
 r.x.dx = xormask;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,1
 asm int 0x33
 asm mov ax,0x0A
 asm mov bx,0
 asm mov cx,andmask
 asm mov dx,xormask
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 MCursorState = MSCURSOR;
 m_stat=0;
}


void enable_hardware_cursor( int start,int stop )
{
 if ( MousePresent == 0 ) return;

 /*
 REGS r;

 r.x.ax = 10;
 r.x.bx = 1;
 r.x.cx = start;
 r.x.dx = stop;
 int86(0x33,&r,&r);
 r.x.ax = 1;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,0x0A
 asm mov bx,1
 asm mov cx,start
 asm mov dx,stop
 asm int 0x33
 asm mov ax,1
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 MCursorState = MHCURSOR;
 m_stat=0;
}

void disable_cursor( void )
{
 if ( MousePresent == 0 ) return;
 /*
 REGS r;

 r.x.ax = 2;
 int86(0x33,&r,&r);
 */

 asm push ax

 asm mov ax,2
 asm int 0x33

 asm pop ax

 MCursorState=MNOCURSOR;
 m_stat=-1;
}

void read_mouse_position( int* x,int* y )
{
 if ( MousePresent == 0 ) { *x=0; *y=0; return;}

 REGS r;

 /*
 r.x.ax = 3;
 int86(0x33,&r,&r);
 *x = r.x.cx;
 *y = r.x.dx;
 */
 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,3
 asm int 0x33

 *x = _CX;
 *y = _DX;

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax
}

int mouse_x_position( void )
{
 if ( MousePresent == 0 ) return(0);

 int rcx;
 /*
 REGS r;

 r.x.ax = 3;
 int86(0x33,&r,&r);
 */
 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,3
 asm int 0x33
 rcx = _CX;

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax ;

 return( rcx );
}

int mouse_y_position( void )
{
 if ( MousePresent == 0 ) return(0);

 int rdx;
 /*
 REGS r;

 r.x.ax = 3;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,3
 asm int 0x33
 rdx = _DX;

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax


 return( rdx );
}

int left_button_pressed( void )
{
 if ( MousePresent == 0 ) return(0);

 int rbx;
 /*
 REGS r;

 r.x.ax = 3;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,3
 asm int 0x33
 rbx = _BX;

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 return( rbx & 1 );
}

int right_button_pressed( void )
{
 if ( MousePresent == 0 ) return(0);

 int rbx;
 /*
 REGS r;

 r.x.ax = 3;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,3
 asm int 0x33
 rbx = _BX;

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 return( rbx & 2 );
}

int middle_button_pressed( void )
{
 if ( MousePresent == 0 ) return(0);

 int rbx;
 /*
 REGS r;

 r.x.ax = 3;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,3
 asm int 0x33
 rbx = _BX;

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 return( rbx & 4 );
}

void set_mouse_position( int x, int y)
{
 if ( MousePresent == 0 ) return;

 /*
 REGS r;

 r.x.ax = 4;
 r.x.cx = x;
 r.x.dx = y;
 int86(0x33,&r,&r);
 */

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,4
 asm mov cx,x
 asm mov dx,y
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax
}

void button_state(  int* b,int* x,int* y )
{
 if ( MousePresent == 0 ) { *b=0; *x=0; *y=0; return; }

 REGS r;

 if ((*b>=0) && (*b<3))
  {
   r.x.ax = 5;
   r.x.bx = *b;
   int86(0x33,&r,&r);
   *b = r.x.bx;
   *x = r.x.cx;
   *y = r.x.dx;
  }
 else
  {
   b = 0;
   x = 0;
   y = 0;
  }
}


void button_release_state( int* b, int* x, int* y )
{
 if ( MousePresent == 0 ) { *b=0; *x=0; *y=0; return;}

 REGS r;

 if ((*b>=0) && (*b<3))
  {
   r.x.ax = 6;
   r.x.bx = *b;
   int86(0x33,&r,&r);
   *b = r.x.bx;
   *x = r.x.cx;
   *y = r.x.dx;
  }
 else
  {
   b = 0;
   x = 0;
   y = 0;
  }
}

void mouse_window( int x1,int y1,int x2,int y2 )
{
 if ( MousePresent == 0 ) return;

 REGS r;

 int z;

 if (x2<x1)
  {
   z  = x1;
   x1 = x2;
   x2 = z;
  }

 if (y2<y1)
  {
   z  = y1;
   y1 = y2;
   y2 = z;
  }

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,0x7
 asm mov cx,x1
 asm mov dx,x2
 asm int 0x33

 asm mov ax,0x8
 asm mov cx,y1
 asm mov dx,y2
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 /*
 r.x.ax = 7;
 r.x.cx = x1;
 r.x.dx = x2;
 int86(0x33,&r,&r);
 r.x.ax = 8;
 r.x.cx = y1;
 r.x.dx = y2;
 int86(0x33,&r,&r);
 */
}

void mouse_move( int* x, int* y )
{
 if ( MousePresent == 0 ) { *x=0; *y=0; return; }

 REGS r;

 r.x.ax = 11;
 int86(0x33,&r,&r);
 *x = r.x.cx;
 *y = r.x.dx;
}

void enable_light_pen_emulation( void )
{
 if ( MousePresent == 0 ) return;

 REGS r;

 r.x.ax = 13;
 int86(0x33,&r,&r);
}

void disable_light_pen_emulation( void )
{
 if ( MousePresent == 0 ) return;

 REGS r;

 r.x.ax = 14;
 int86(0x33,&r,&r);
}

void mouse_sensivity( int x,int y )
{
 if ( MousePresent == 0 ) return;

 REGS r;

 r.x.ax = 15;
 r.x.cx = x;
 r.x.dx = y;
 int86(0x33,&r,&r);
}

void double_speed_mode( int v )
{
 if ( MousePresent == 0 ) return;

 REGS r;

 r.x.ax = 19;
 r.x.dx = v;
 int86(0x33,&r,&r);
}

void disable_double_speed_mode( void )
{
 if ( MousePresent == 0 ) return;

 REGS r;

 r.x.ax = 19;
 r.x.dx = 32767;
 int86(0x33,&r,&r);
}

int m_present( void )
{
 return( MousePresent );
}

int m_cur_state( void )
{
 return( MCursorState );
}

void m_hide( void )
{
 if ( MousePresent == 0 ) return;

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,2
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 MCursorState=0;
}

void m_show( void )
{
 if ( MousePresent == 0 ) return;

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,1
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax

 MCursorState= 1;// Might have to correct
}

void m_shide( void )
{
 m_hide();
}

void m_sshow( void )
{
 m_show();
}

void set_mouse_page( int pg )
{
 if ( MousePresent == 0 ) return;

 asm push ax
 asm push bx
 asm push cx
 asm push dx

 asm mov ax,0x1D
 asm mov bx,pg
 asm int 0x33

 asm pop dx
 asm pop cx
 asm pop bx
 asm pop ax
}

void set_exclusion_area( int x1,int y1 , int x2,int y2 )
{
 if ( MousePresent == 0 ) return;

 REGPACK r;

 r.r_ax = 0x0010;
 r.r_cx = x1;
 r.r_dx = y1;
 r.r_si = x2;
 r.r_di = y2;
 intr(0x33,&r);
}

