#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <sys\stat.h>

void WriteVarLen ( long value, int f )
{
 register long buffer;

 buffer = value & 0x7f;
 while ((value >>= 7) > 0)
  {
   buffer <<= 8;
   buffer |= 0x80;
   buffer += (value & 0x7f);
  }

 while (1)
  {
   write(f,(char *)&buffer,1);
   if (buffer & 0x80)
    buffer >>= 8;
   else
    break;
  }
}

void xwrite( int handle, void *buf, int len ) // writes backwards
{
 int c;
 char *p=(char *)buf;
 for (c=len-1;c>=0;c--)
  write(handle,&p[c],1);
}

void writestring( char *st, int f )
{
 char *q,*p=st;
 int d;

 if (*p=='"')
  p++;

 p[strlen(p)]=' ';

 d=0;
 q=p;
 while ( *q!='\"' && d<256)
  { d++; q++; }
 *q='\0';

 lseek(f,-1,SEEK_CUR); // a merete miatt
 char siz=strlen(p);
 write(f,&siz,1);
 write(f,p,siz); // a " miatt -1
}

void crops( char *s )
{
 int c=0;
 char *p=s;

 while (p[strlen(p)-1]=='\n' || p[strlen(p)-1]=='\r')
  p[strlen(p)-1]='\0';

 p=s;
 c=0;
 while ( (*p!=';') && (p<&p[strlen(p)]) ) p++;

 if (*p==';')
  *p=0;
}

void main ( int argc, char *argv[] )
{
 char buf[256];

 printf("Ŀ\n"
        " MIDI-Assembler v1.0 (C) 1994 by John Zero/NOSASOFT \n"
        "\n"
       );

 if (argc<3)
  {
   printf("Usage ... ...\n");
   return;
  }

 int g;
 FILE *f;

 f=fopen(argv[1],"rt");
 g=open(argv[2],O_RDWR|O_BINARY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);

 char sor[256];
 char *p;
 long l,l2;
 int a,b;

 strcpy(sor,"MThd");
 write(g,sor,4);

 l=6; // length of head
 xwrite(g,&l,sizeof(l));

 a=1; // type 1
 xwrite(g,&a,sizeof(a));

 a=3; // tracknum:3 (???) filled in later
 xwrite(g,&a,sizeof(a));

 a=0xF0; // division/ time val
 xwrite(g,&a,sizeof(a));

 long tstart=tell(g);
 int tnum=0; // -> 1
 strcpy(sor,"MTrk????");
 write(g,sor,8);

 while (!feof(f))
  {
   sor[0]='\0';
   fgets(sor,256,f);
   crops(sor);
   if (sor[0]=='\0')
    continue;

   if (sor[0]=='=' && sor[1]=='>')
    {
     l=strtol(&sor[2],NULL,16);
     // division/ time val
     a=l;

     l=tell(g);
     lseek(g,12,SEEK_SET);
     xwrite(g,&a,sizeof(a));

     lseek(g,l,SEEK_SET);
     continue;
    }

   if (sor[0]=='-' && sor[1]=='>')
    {
     if (tnum==0)
      {
       tnum++;
       printf("Track %d...\n",tnum);
       continue;
      }
     l2=tell(g);
     lseek(g,tstart+4,SEEK_SET);
     l=l2-(tstart+8);
     xwrite(g,&l,4);
     tstart=l2;

     lseek(g,l2,SEEK_SET);
     strcpy(sor,"MTrk????");
     write(g,sor,8);
     tnum++;
     printf("Track %d...\n",tnum);
     continue;
    }

   if (strnicmp(sor,"-END-",5)==0)
    {
     l2=tell(g);
     lseek(g,tstart+4,SEEK_SET);
     l=l2-(tstart+8);
     xwrite(g,&l,4);

     lseek(g,l2,SEEK_SET);
     break;
    }


   p=strtok(sor," "); // read delay
   if (!p)
    continue;

   if (p[0]=='"')
    writestring(p,g);
   else
    {
     l=strtol(p,NULL,16);
     WriteVarLen(l,g);
    }

   p=strtok(NULL," ");
   while (p)
    {
     if (p[0]=='"')
      {
       writestring(p,g);
       break; // " csak a sor vegen lehet!!!
      }
     else
      {
       l=strtol(p,NULL,16);
       //WriteVarLen(l,g);
       xwrite(g,&l,1);      // ez igy meg nem jo!!! pl. 3AE
      }

     p=strtok(NULL," ");
    }
  }
 lseek(g,4+4+2,SEEK_SET);
 xwrite(g,&tnum,2);

 close(g);
 fclose(f);
}

