#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "msghand.h"
#include "mailgen.h"

conft confs[100]; // egyenlore max 100 conf.
char *cgroup[50]; // max 50 group. egyenlore
char *cgroupid[50]; // max 50 group. egyenlore
int confc;
int groupn;
int curconf;
long curmsgno;
FILE *curcf;
FILE *curci;

void checkmsgfile( char *fname )
{
 char buf[128];
 FILE *g;

 sprintf(buf,"%s%s.msg",MSGBASEPATH,fname);
 g=fopen(buf,"ab");
 fclose(g);

 sprintf(buf,"%s%s.idx",MSGBASEPATH,fname);
 g=fopen(buf,"ab");
 fclose(g);
}

int getconfind( int num )
{
 int c;
 for (c=0;c<confc;c++)
  if (confs[c].num==num)
   return c;

 return -1;
}

int getconfnumt( char *tag )
{
 int c;
 struprx(tag);
 for (c=0;c<confc;c++)
  if (strcmp(confs[c].tag,tag)==0)
   return confs[c].num;

 return -1;
}

int getconfname( char *nbuf )
{
 strcpy(nbuf,confs[curconf].desc);
 return 1;
}

int getconftag( char *nbuf )
{
 strcpy(nbuf,confs[curconf].tag);
 return 1;
}


long getcurmsgno( void )
{
 return curmsgno;
}

int loadconfdata( void )
{
 FILE *f;
 char buf[200];
 char *p[4],*q,*r,*s[20];
 int line=0,c,d,a,b,cc;

 confc=0;
 curconf=-1;
 curmsgno=0;
 curcf=NULL;
 curci=NULL;

 if (!(f=fopen("confs.cfg","rt")))
  {
   logerror("Opening file confs.cfg");
   return 0;
  }

 while(1)
  {
   fgets(buf,199,f);
   if (feof(f))
    break;
   line++;
   p[0]=strtok(buf,",");
   p[1]=strtok(NULL,",");
   p[2]=strtok(NULL,",");
   p[3]=strtok(NULL,",\n\r");
   if (!(p[3]))
    {
     printf("Conference config error in line #%d\n",line);
     return 0;
    }
   confs[confc].num=atoi(p[0]);
   confs[confc].tag=struprx(strdupx(p[1]));
   confs[confc].desc=strdupx(p[2]);
   confs[confc].fname=strdupx(p[3]);
   confs[confc].levm=0;
   confs[confc].group=0;
   checkmsgfile(p[3]);
   confc++;
  }

 confs[confc].num=CONF_LOSTMAIL;
 confs[confc].tag="LOSTMAIL";
 confs[confc].desc="Lost mail";
 confs[confc].fname="lostmail";
 confs[confc].levm=0;
 confs[confc].group=0;
 checkmsgfile(confs[confc].fname);
 confc++;


 //-------groups----------

 groupn=1;
 cgroup[0]=strdupx("Other");
 cgroupid[0]=strdupx("OTHER");

 if (!(f=fopen("conf_grp.cfg","rt")))
  {
   logerror("Opening file conf_grp.cfg");
   return 0;
  }

 while(1)
  {
   fgets(buf,199,f);
   if (feof(f))
    break;
   line++;
   p[0]=strtok(buf,",");
   p[1]=strtok(NULL,",");
   p[2]=strtok(NULL,"\n\r");
   if (!(p[2]))
    {
     printf("Conference group config error in line #%d\n",line);
     return 0;
    }
   cgroup[groupn]=strdupx(p[1]);
   cgroupid[groupn]=struprx(strdupx(p[0]));

   for (c=0,s[0]=strtok(p[2],",") ; s[++c]=strtok(NULL,",") ; )
    ;

   for (cc=0,q=s[0];s[cc];q=s[++cc])
    {
     a=atoi(q);
     if (r=strtok(q,"-"))
      if (r=strtok(NULL,"-"))
       b=atoi(r);
      else
       b=a;

     for (c=a;c<=b;c++)
      {
       d=getconfind(c);
       confs[d].group=groupn;
      }
    }

   groupn++;
  }

 fclose(f);
 return 1;
}
//-----------------------------------------------------------------------
int selectconf( int num ) // num= 1...
{
 char buf[128];

 int n=getconfind(num);
 if (n==-1)
  return 0;

 curconf=n;
 if (curcf)
  fclose(curcf);
 if (curci)
  fclose(curci);
 curcf=NULL;
 curci=NULL;

 sprintf(buf,"%s%s.msg",MSGBASEPATH,confs[n].fname);
 curcf=fopen(buf,"ab");
 fclose(curcf);
 curcf=fopen(buf,"r+b");
 fseek(curcf,0,SEEK_END);

 sprintf(buf,"%s%s.idx",MSGBASEPATH,confs[n].fname);
 curci=fopen(buf,"ab");
 fclose(curci);
 curci=fopen(buf,"r+b");
 fseek(curcf,0,SEEK_END);

 return 1;
}

void closeconf( void )
{
 curconf=-1;
 if (curcf)
  fclose(curcf);
 if (curci)
  fclose(curci);
 curcf=NULL;
 curci=NULL;
}

//-----------------------------------------------------------------------
int seekmsg( long msgnum ) // ha nincs akkor (softseek) kovetkezore ugrik
{
 long n,off;

 fseek(curci,0,SEEK_SET);
 while (1)
  {
   n=getlong(curci);
   if (feof(curci))
    break;
   off=getlong(curci);
   if (n>=msgnum)
    {
     curmsgno=n;
     fseek(curcf,off,SEEK_SET);
     return 1;
    }
  }
 curmsgno=0;
 return 0;
}
//-----------------------------------------------------------------------
long firstmsgno( void ) // 0 ha meg nincs level
{
 fseek(curci,0,SEEK_END);
 if (ftell(curci)==0)
  return 0;
 fseek(curci,0,SEEK_SET);

 return(getlong(curci));
}


long lastmsgno( void ) // 0 ha meg nincs level
{
 long s,a;
 fseek(curci,0,SEEK_END);
 if ((s=ftell(curci))==0)
  return 0;
 fseek(curci,s-IDXRSIZE,SEEK_SET);

 a=getlong(curci);
 return(a);
}

//------------------------------------------

int addnewmsg( msgtt *m )
{
 long lm,sp;

 fseek(curcf,0,SEEK_END);
 sp=ftell(curcf);
 fputs(MSGSIGN,curcf);
 fputs(m->from,curcf); fputc(0,curcf);
 fputs(m->to,curcf); fputc(0,curcf);
 fputs(m->subj,curcf); fputc(0,curcf);
 fputs(m->date,curcf); fputc(0,curcf);
 fputs(m->msg,curcf); fputc(0,curcf);

 lm=lastmsgno()+1;
 fseek(curci,0,SEEK_END);
 putlong(lm,curci);
 putlong(sp,curci);
 curmsgno=lm+1; // ???
 return 1;
}

//------------------------------------------

int getmsg( msgtt *m, int nomsg )
{
 char sbuf[MSGSIGNLEN+1];
 long ps=ftell(curcf);
 char *q;

 getfrek(sbuf,MSGSIGNLEN,curcf);
 if (feof(curcf))
  return 0;

 if (strncmp(sbuf,MSGSIGN,MSGSIGNLEN)) // nem egyezik
  {
   logerror("MSG signature not found at pos %ld conf %d",ps,curconf);
   return 0;
  }
 //fseek(curcf,MSGSIGNLEN,SEEK_CUR);

 m->from=get0str(curcf);
 if (feof(curcf))
  {
   free(m->from);
   return 0;
  }

 /*if (!(q=makeget0buf()))
  {
   logerror("Malloc error #025!");
   xlog(L_SCREEN,"Malloc error #025!");
   return 0;
  }*/
 q=qbase; // vigyazni! no free!

 m->to=get0str(curcf);
 m->subj=get0str(curcf);
 m->date=get0str(curcf);
 if (!nomsg)
  m->msg=get0strlong(q,curcf);
 else
  m->msg=NULL;

 curmsgno++;
 return 1;
}

void zeromsg( msgtt *m )
{
 memset(m,0,sizeof(msgtt));
/* m->from=NULL;
 m->to=NULL;
 m->subj=NULL;
 m->date=NULL;*/
}

void freemsg( msgtt *m )
{
 if (m->from) free(m->from);
 if (m->to) free(m->to);
 if (m->subj) free(m->subj);
 if (m->date) free(m->date);
 if (m->msg) free(m->msg);
}

//------------------------------------

void shortenfilef( char *fname, long nf ) // filename, from pos.
{
 FILE *t,*f;
 long len,left,cur;
 char *buf;

 t=tmpfile();
 //buf=(char *)malloc(32768);
 buf=qbase; // ***

 f=fopen(fname,"r+b");
 fseek(f,0,SEEK_END);
 len=ftell(f)-nf;

 fseek(f,nf,SEEK_SET);
 left=len;
 while (left>0)
  {
   cur=left>BUF0SIZE?BUF0SIZE:left;
   fread(buf,cur,1,f);
   fwrite(buf,cur,1,t);
   left-=cur;
  }
 fclose(f);

 f=fopen(fname,"w+b");
 fseek(t,0,SEEK_SET);
 left=len;
 while (left>0)
  {
   cur=left>32768?32768:left;
   fread(buf,cur,1,t);
   fwrite(buf,cur,1,f);
   left-=cur;
  }
 fclose(f);

 // free(buf); ***
 fclose(t);
}

int packmsgbasek( int sizk )
{
 long siz,stol;
 long s,len;
 long n,off,offi,offx;
 char buf[200];

 int c,d,nn;

 siz=sizk;
 siz*=1024;

 for (c=0;c<255;c++)
  if (selectconf(c))
   {
    fseek(curcf,0,SEEK_END);
    if ((s=ftell(curcf)) <= siz)
     continue;

    stol=s-siz;
    xlog(L_ALL,"Conf #%d above limit (is %ld bytes long)",c,s);
    xlog(L_ALL," Old: First msg: %ld last msg: %ld",firstmsgno(),lastmsgno());

    //---
    fseek(curci,0,SEEK_SET);
    off=-1;
    while (1)
     {
      n=getlong(curci);
      if (feof(curci))
       break;
      off=getlong(curci);
      if (off>=stol)
       {
        stol=off;
        offi=ftell(curci)-2*sizeof(long);
        break;
       }
     }

    if (off!=-1)
     {
      closeconf();

      nn=getconfind(c);
      sprintf(buf,"%s%s.msg",MSGBASEPATH,confs[nn].fname);
      shortenfilef(buf,stol);

      sprintf(buf,"%s%s.idx",MSGBASEPATH,confs[nn].fname);
      shortenfilef(buf,offi);

      curci=fopen(buf,"r+b");
      fseek(curci,0,SEEK_END);
      len=ftell(curci);
      offx=0;
      fseek(curci,0,SEEK_SET);
      while (offx<len)
       {
        //printf("\rI: %-5d ",offi);
        //offi=ftell(curci);
        fseek(curci,offx,SEEK_SET);

        n=getlong(curci);
        //if (feof(curci))
        // break;
        off=getlong(curci);
        off-=stol;

        fseek(curci,offx+sizeof(long),SEEK_SET);
        //n=getlong(curci);
        putlong(off,curci);

        offx+=2*sizeof(long);
       }
      fclose(curci);
      curcf=NULL;
      curci=NULL;
      selectconf(c);
      xlog(L_ALL," New: First msg: %ld last msg: %ld",firstmsgno(),lastmsgno());
      xlog(L_ALL,"Conf #%d cropped successfully!",c);
     }
    else
     logerror("Shortening conf %d, p#001",c);

    //break; // $$ debug only -- csak 1 conf!
   }

 closeconf();
 return 1;
}

//----------------------------------------

int conffilllistget( long *lmr )
{
 int c,d,dd,ki;

 xlog(L_ALL,"Conferences: (+ to add/add all sub, - to deselect)");
 ki=0;
 for (c=1;!ki;(c<groupn-1)?c++:(c=0))
  {
   if (c==0)
    ki=1;
   xlog(L_ALL,"[ ] %s (*%s)",cgroup[c],cgroupid[c]);
   for (d=0;d<256;d++)
    if ((dd=getconfind(d))!=-1)
     if (confs[dd].group==c)
      xlog(L_ALL," [%s] %s (%s)",(lmr[d]>=0)?"x":" ",confs[dd].desc,confs[dd].tag,d);
  }
}

//------------------------------------------------------

int conff1line( char *buf, long *lmr )
{
 int cb=0;
 char *p[4],*q;
 char *tag;

 if (!(p[0]=strchr(buf,'[')))
  return 0;
 if (!(p[1]=strchr(p[0],']')))
  return 0;

 p[3]=NULL;
 p[2]=NULL;
 for (q=&buf[strlen(buf)-1];*q!=']';q--)
  if (*q==')')
   p[3]=q;

 if (!p[3])
  return 0;

 for (q=p[3] ; *q!=']' ; q--)
  if (*q=='(')
   p[2]=q;

 if (!p[2])
  return 0;

 // p: 0[ ]1  2( )3
 if ((p[0]+2)!=p[1])
  return 0;

 if (*(p[0]+1)=='+')
  cb=1;
 else
  if (*(p[0]+1)=='-')
   cb=-1;

 if (cb==0)
  return 1;

 *p[3]=0;
 tag=p[2]+1;
 struprx(tag);

 //------------------------

 //xlog(L_ALL,"Rq rcvd. for %s xtag %s",(cb==1)?"adding":"removing",
 //           tag);

 int c,ki,fg,d,dd;

 if (tag[0]=='*') // group
  {
   tag++;
   fg=-1;
   ki=0;
   for (c=1;!ki;(c<groupn-1)?c++:(c=0))
    {
     if (c==0)
      ki=1;
     if (strcmp(cgroupid[c],tag)==0)
      {
       fg=c;
       break;
      }
    }
   if (fg==-1)
    {
     logerror("Rq: group tag %s not found!",tag);
     xlog(L_RSC,"Error: Rq: group tag %s not found!",tag);
     return 0;
    }
   else
    {
     xlog(L_ALL,"Rq for %s group tagged %s accepted.",
                (cb==1)?"adding":"removing",tag);
     for (d=0;d<256;d++)
      if ((dd=getconfind(d))!=-1)
       if (confs[dd].group==fg)
        {
         if (cb==1)
          {
           if (lmr[d]==-1)
            lmr[d]=0;
          }
         else
          lmr[d]=-1;
        }
    }
  }
 else // conf.
  {
   fg=0;
   for (d=0;d<256;d++)
    if ((dd=getconfind(d))!=-1)
     if (strcmp(confs[dd].tag,tag)==0)
      {
       if (cb==1)
        {
         if (lmr[d]==-1)
          lmr[d]=0;
        }
       else
        lmr[d]=-1;
       fg=1;
       break;
      }

   if (fg==0)
    {
     logerror("Rq: conf tag %s not found!",tag);
     xlog(L_RSC,"Error: Rq: conf tag %s not found!",tag);
     return 0;
    }
   else
     xlog(L_ALL,"Rq for %s conf tagged %s accepted.",
                (cb==1)?"adding":"removing",tag);
  }

 return 1;
}


int conffilllistproc( FILE *f, long *lmr )
{
 char buf[200],buf2[200];
 while (!feof(f))
  {
   buf[0]=0;
   fgets(buf,199,f);
   strtok(buf,"\r\n");
   strcpy(buf2,buf);

   if (buf[0]==0)
    continue; // vagy majd lehet return, mert ez ures sort is jelenthet
   if (!conff1line(buf,lmr))
    xlog(L_ALL,"Error was in line: '%s'",buf2);
  }
}

//-------------------------------------------------------
int dupc=-1;
long *dupid;

int dupe_load( void )
{
 FILE *f;
 long fs;

 if (dupc==-1)
  return 0;

 dupid=(long *)malloc(sizeof(long)*900);
 if (!dupid)
  {
   xlog(L_SCLOG,"Error: Malloc error #28!");
   return 0;
  }
 f=fopen(DUPFILE,"rb");
 if (!f)
  return 0;
 fseek(f,0,SEEK_END);
 fs=ftell(f);
 fseek(f,0,SEEK_SET);
 fread((char *)dupid,1,fs,f);
 fclose(f);
}

int dupe_savef( void )
{
 FILE *f;
 if (dupc==-1)
  return 0;

 f=fopen(DUPFILE,"wb");
 if (!f)
  return 0;
 fwrite((char *)dupid,sizeof(long),dupc,f);
 fclose(f);
 return 1;
}

int dupe_check( long msgid )
{
 if (dupc==-1)
  return 1;

}

int dupe_add( long msgid )
{
 if (dupc==-1)
  return 0;

}


