/*
**   TEST_LZW.C       Copyright (C) 1992 by MarshallSoft Computing, Inc.
**
**   This program is used to compress, expand, and verify each specified
**   file. It's purpose is for you to test the LZW4C library on your own
**   files. Your files are never modified. However, you should NOT have a
**   file named "XXX.XXX" or "YYY.YYY".  Compression ratios are printed
**   for each file compressed. For example, to compress all files ending
**   in *.C in your current directory, type:
**
**        TEST_LZW *.c
*/

#include <stdio.h>
#include <dos.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#include "LZW4C.H"
#include "RW_IO.H"
#include "DIR_IO.H"

extern char *malloc();
extern int free();

void SayError(int);

FILE *FilePtr1;
FILE *FilePtr2;

void main(argc,argv)
int argc;
char *argv[];
{int i, k;
 int x, y;
 int RetCode;
 float Ratio;
 long Index;
 char Filename[15];
 int Files = 0;
 /* begin */
 if(argc!=2)
   {printf("Usage: TEST_LZW <filespec>\n");
    exit(1);
   }
 RetCode = InitLZW(malloc);
 if(RetCode<0)
   {SayError(RetCode);
    exit(2);
   }
 /* flush the keyboard */
 while(kbhit()) getchar();
 puts("\nTEST_LZW 1.0: Type any key to abort...");
 for(i=0;;i++)
   {if(kbhit())
      {puts("\n...Aborted by user !");
       break;
      }
    if(i==0) RetCode = FindFirst(argv[1],Filename);
    else RetCode = FindNext(Filename);
    if(!RetCode) break;
    /* get pointer to file */
    for(k=0;k<strlen(Filename);k++) Filename[i] = toupper(Filename[i]);
    if( (strcmp(Filename,"XXX.XXX")==0) ||
        (strcmp(Filename,"YYY.YYY")==0) ) continue;
    /* open input file for compression */
    if(!ReaderOpen(Filename)) exit(3);
    /* open output file for compression */
    if(!WriterOpen("XXX.XXX")) exit(4);
    /* do the compression */
    Files++;
    printf("\nCompressing %12s ",Filename);
    if((RetCode=Compress(Reader,Writer))<0)
      {SayError(RetCode);
       exit(5);
      }
    /* report compression ratio */
    if(ReaderCount() > 0)
       {Ratio = (float)(WriterCount())/(float)ReaderCount();
        printf(" OK (%0.2f)\n",Ratio);
       }
    else puts("???");
    /* close files */
    ReaderClose();
    WriterClose();
    /* open input file for expansion */
    if(!ReaderOpen("XXX.XXX")) exit(6);
    /* open output file */
    if(!WriterOpen("YYY.YYY")) exit(7);
    /* do the expansion */
    printf("  Expanding %12s ",Filename);
    if((RetCode=Expand(Reader,Writer))<0)
      {printf("Expand returns error %d\n",RetCode);
      }
    /* close files */
    ReaderClose();
    WriterClose();
    printf(" OK\n");
    /* compare original to expanded file */
    FilePtr1 = fopen(Filename,"rb");
    FilePtr2 = fopen("YYY.YYY","rb");
    printf("  Comparing              ");
    Index = 0;
    while(1)
      {x = fgetc(FilePtr1);
       y = fgetc(FilePtr2);
       Index++;
       if((Index&0x0fff)==0) putchar('.');
       if((x==EOF)&&(y==EOF)) break;
       if(x!=y)
         {printf("Difference between files at index %ld\n",Index-1);
          exit(8);
         }
      }
    printf(" OK\n");
    fclose(FilePtr1);
    fclose(FilePtr2);
   }
 TermLZW(free);
 printf("\n%d files tested\n",Files);
 exit(0);
}