
SEGMENT SEGA

AllocMem MACRO seg,size
       MOV      AH,48h
       MOV      BX,size/16
       INT      21h
       MOV      seg,AX
ENDM

FreeMem MACRO seg
        MOV     AH,49h       ; free mem
        MOV     DX,seg
        MOV     ES,DX
        INT     21H
ENDM

ClearMem MACRO seg,size
       CLD
       MOV      AX,seg
       MOV      ES,AX
       MOV      CX,size/2
       MOV      AX,0
       MOV      DI,0
       REP      STOSW
ENDM

_ES MACRO seg
       MOV    AX,seg
       MOV    ES,AX
ENDM

_DS MACRO seg         ; !!! az adatok ekkor nem DS:xxx-n lesznek!
       MOV    AX,seg
       MOV    DS,AX
ENDM

_FS MACRO seg
       MOV    AX,seg
       MOV    FS,AX
ENDM

_GS MACRO seg
       MOV    AX,seg
       MOV    ES,AX
ENDM

KEPRERAK MACRO seg,off_seg,off_kep,cnt ; cnt oszthato legyen 4-el!
        PUSH    DS
        MOV     SI,off_seg
        MOV     DI,off_kep
        MOV     CX,cnt
        SHR     CX,2    ; /4
        _ES 0A000h
        _DS seg
        REP     MOVSD
        POP     DS
ENDM

KEPLEVESZ MACRO seg,off_seg,off_kep,cnt ; cnt oszthato legyen 4-el!
        PUSH    DS
        MOV     DI,off_seg
        MOV     SI,off_kep
        MOV     CX,cnt
        SHR     CX,2    ; /4
        _ES seg
        _DS 0A000h
        REP     MOVSD
        POP     DS
ENDM

KEPClear MACRO mettol,meddig ;(sor)
        MOV     EBP,mettol
        LEA     DI,[ebp+ebp*4]
        SHL     DI,6

        MOV     CX,(meddig-mettol)*320
        SHR     CX,2    ; /4
        _ES 0A000h
        MOV     EAX,0
        REP     STOSD
ENDM


WaitRetrace MACRO
LOCAL inhezz,ih2
        PUSH    AX
        PUSH    DX
        MOV     DX,3DAh
inhezz:
        IN      AL,DX   ; wait for not retrace interval
        TEST    AL,8
        JNZ     inhezz
ih2:
        IN      AL,DX   ; wait for retrace interval
        TEST    AL,8
        JZ      ih2
        POP     DX
        POP     AX
ENDM

;-----------------------------------------------------

ASSUME CS:SEGA,DS:SEGA
ORG 100h

start:  JMP ST2

INCLUDE int5.asi ; INTPAL , 768
TOM     DW 0,0
TOMI    DW 0
ranvec  dw ?
ranptr  dw ?
ctable  dw ? ; 32*x byte-os char table
dum32   dw ? ; dummy 32K mem
dum32b  dw ? ; dummy 32K mem
lepes   dw 0
ticc    dw 0

ST2:
        CLD
        MOV     AX,DS
        MOV     ES,AX
        MOV     AH,4Ah
        MOV     BX,1000h ; 64 K
        INT     21h
        PUSH    CS
        POP     DS
        ;---------------------------

        AllocMem ctable,(32*256)
        CALL Szovinit ; chartable levetel,...

        MOV     AX,0013h
        INT     10h

       ; ALLOCs
       AllocMem tom[0],32000
       AllocMem tom[2],32000
       ClearMem tom[0],32000
       ClearMem tom[2],32000

       AllocMem ranvec,32300
       call rangen
       AllocMem dum32,32001
       AllocMem dum32b,32001

;       Mov  Al,01111010b         ; Mask off all unneccesary interrupts.
;       Out  21h,Al


        MOV     SI,OFFSET INTPAL
        CALL    SETALLPALETTE

        CALL    KEZDKIRAK
;        MOV     AX,0a000h
;        MOV     ES,AX
;        MOV     CX,256
;        MOV     DI,0
;        MOV     AL,0
;kkrak:
;        STOSB
;        INC     AL
;        LOOP    kkrak
.386

WaitEsc:

       WaitRetrace

       CALL  dofire
       INC   ticc
;       TEST  ticc,16
;       JZ    skipper
       CALL  lepesek
;       MOV   ticc,0
;skipper:

       In   Al,60h
       Cmp  Al,1
       Jne  WaitEsc              ; Wait until someone presses ESCAPE.

;        Mov  Al,0                 ; Let the interrupts come again...
;        Out  21h,Al

        FreeMem(tom[0])
        FreeMem(tom[2])
        FreeMem(ranvec)
        FreeMem(ctable)
        FreeMem(dum32)
        FreeMem(dum32b)

        MOV     AX,3h
        INT     10h
        RET
;------------------------END-
;
; SETALLPALETTE
;                Input: DS:SI - palette [768 bytes]
;
 SETALLPALETTE  PROC    near
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    SI
                PUSH    DI

               ; MOV     SI,OFFSET       PAL
                XOR     BX,BX
                MOV     DI,256
 SZINEK:
                LODSW
                MOV     CH,AH
                MOV     AH,AL
                LODSB
                MOV     CL,AL
                MOV     DX,03C8h
                MOV     AL,BL
                CLI
                OUT     DX,AL
                INC     DX
                MOV     AL,AH
                OUT     DX,AL
                MOV     AL,CH
                OUT     DX,AX
                MOV     AL,CL
                OUT     DX,AL
                STI
                INC     BX
                DEC     DI
                JNZ     SZINEK

                POP     DI
                POP     SI
                POP     DX
                POP     CX
                POP     BX
                POP     AX
                RET
 SETALLPALETTE  ENDP


;-----------------------------------------------------------------------
DOFIRE PROC
       CLD
       MOV      BX,TOMI
       MOV      AX,TOM[BX]
       MOV      FS,AX
       XOR      TOMI,2
       MOV      BX,TOMI
       MOV      AX,TOM[BX]
       MOV      GS,AX

       MOV      EBP,99-2-50
sor:
       MOV      CX,319
       lea      di, [ebp+ebp*4]     ; Y*5
       shl      di, 6               ; Y*64
       ADD      di,318

oszl:
       ;MOV      SI,DI
       XOR      AX,AX
       MOV      AL,GS:[DI+320]
       ADD      AL,GS:[DI+320-1]
       ADD      AL,GS:[DI+320+1]
       ADD      AL,GS:[DI+320+320]

;       ADD      AL,GS:[DI-1]
;       ADD      AL,GS:[DI+1]
;       ADD      AL,GS:[DI+320+320-1]
;       ADD      AL,GS:[DI+320+320+1]

       SHR      AL,2

       DEC      AL
       CMP      AL,0FFh
       JNE      nemk
       MOV      AL,0
nemk:

       MOV      FS:[DI],AL

       DEC      DI
       LOOP     oszl
       DEC      BP
       CMP      BP,0FFFFh
       JNE      sor

       ;--------------------------------------------

       MOV      DL,63

       MOV      CX,319
       MOV      EBP,99-50
       lea      di, [ebp+ebp*4]     ; Y*5
       shl      di, 6               ; Y*64
       ADD      di,318
utsor:
       CALL     RANDOM
       CMP      AL,70
       JNB      nincsal1
       CALL     RANDOM
       AND      AL,63
;       ADD      AL,32
       MOV      DL,AL
nincsal1:
       ;ADD      AL,32
       MOV      FS:[DI],DL
       DEC      DI
       LOOP     utsor
       ;----------

       MOV      CX,319
       MOV      EBP,98-50
       lea      di, [ebp+ebp*4]     ; Y*5
       shl      di, 6               ; Y*64
       ADD      di,318
utsor2:
       CALL     RANDOM
       CMP      AL,70
       JNB      nincsal2
       CALL     RANDOM
       AND      AL,63
;       ADD      AL,32
       MOV      DL,AL
nincsal2:
       ;ADD      AL,32
       MOV      FS:[DI],DL
       DEC      DI
       LOOP     utsor2


       ;--------------------------------------------

       PUSH     DS ES
       XOR      SI,SI
       MOV      DI,320*(100+50+2)
       MOV      AX,0A000h
       MOV      ES,AX
       MOV      AX,FS
       MOV      DS,AX
       MOV      CX,320*(100-50-2)/2
       REP      MOVSW

       POP      ES DS

       RET
DOFIRE ENDP

CURC     DB 63

RANDSEED DW 0,0

RAN2 PROC
   PUSH BX CX
   MOV BX,randseed[2]
   MOV CX,randseed[0]
   MOV AL,BH
   MOV BH,BL
   MOV BL,CH
   MOV CH,CL
   XOR CL,CL
   RCR AL,1
   RCR BX,1
   RCR CX,1
   ADD CX,randseed[0]
   ADC BX,randseed[2]
   ADD CX,062E9h
   ADC BX,03619h
   MOV randseed[2],BX
   MOV randseed[0],CX
   MOV AX,BX
   POP CX BX
   RET
RAN2 ENDP

random proc
  mov bp,ranptr
  inc bp
  cmp bp,32198
  jne fuck
  mov bp,0
fuck:
  mov ranptr,bp
  mov ax,ranvec
  mov es,ax
  mov al,es:[bp]
ret
endp random

RANGEN PROC
   mov cx,32198/2
   mov ax,ranvec
   mov es,ax
   xor di,di
ranloop:
   call ran2
   stosw
   loop ranloop
   RET
RANGEN ENDP
;--------------------------------------------------
SORKIRAK MACRO y,col  ; Assumes ES:a000h
        MOV     CX,320/4
        MOV     EBP,y
        LEA     DI,[EBP+EBP*4]
        SHL     DI,6
        XOR     EAX,EAX
        MOV     AL,col
        IMUL    EAX,01010101h
        REP     STOSD
ENDM

tszov   DB 'NOSASOFT',0

KEZDKIRAK PROC
        _ES 0A000h
        Sorkirak 0,166
        Sorkirak 1,139
        Sorkirak 2,68

        Sorkirak 35,166
        Sorkirak 36,139
        Sorkirak 37,68

        LEA SI,tszov
        MOV DX,0522h
        MOV BH,255
        CALL SZOVKIRAK ;DS:SI - szoveg0 DL:x DH:y Bh:color

        MOV   DX,1E05h
        CALL  BLURITY
        ;CALL   OUTLINY

        RET
KEZDKIRAK ENDP

;------------------------------------------------------------------------
SZOVKIRAK PROC ;DS:SI - szoveg0 DL:x DH:y BH:color
        _FS ctable
        _ES 0A000h

        XOR      EAX,EAX
        MOV      AL,DH
        MOV      EBP,EAX
        lea      di, [ebp+ebp*4]     ; Y*5
        shl      di, 6               ; Y*64
        XOR      AX,AX
        MOV      AL,DL
        ADD      di,AX
        CLD
                          ; AX BX CX DX BP ES FS GS SI DI
ujkar:
        LODSB
        CMP      AL,0
        JE       quitez

        XOR      AH,AH
        SHL      AX,5  ; *32
        MOV      BP,AX
        MOV      CL,16
bytefeld:
        MOV      BL,FS:[BP]
        MOV      CH,8
bitfeld:;---
        TEST     BL,128
        JZ       nemir

        MOV      ES:[DI],BH
        MOV      ES:[DI+1],BH
        MOV      ES:[DI+320],BH
        MOV      ES:[DI+320+1],BH
nemir:
        INC     DI
        INC     DI
        ;---
        SHL      BL,1
        DEC      CH
        JNZ      bitfeld
        ADD      DI,640-16

        INC      BP
        LOOP     bytefeld
        SUB      DI,((640-16)*17)
        ADD      DI,320+16+16+32
        JMP      ujkar
quitez:
        RET
SZOVKIRAK ENDP
;------------------------------------------------------------------------
s_DI    DW   ?
s_CNT   DW   ?

BLURITY PROC ; DL -> DH : y
        _ES  0A000h
        _FS  dum32

        MOV     SI,0
        XOR     EAX,EAX
        MOV     AL,DL
        MOV     BP,AX
        LEA     DI,[EBP+EBP*4]
        SHL     DI,6
        MOV     s_DI,DI
        XOR     CX,CX
        SUB     DH,DL
        SHR     DX,8
        INC     DX
        MOV     s_CNT,DX
getl:
        MOV     CX,320
runloop:
        XOR     AX,AX
        MOV     AL,ES:[DI-320]
        ADD     AL,ES:[DI+320]
        ADC     AH,0
        ADD     AL,ES:[DI+1]
        ADC     AH,0
        ADD     AL,ES:[DI-1]
        ADC     AH,0
        INC     DI
        SHR     AX,2
        INC     AL
        MOV     FS:SI,AL
;        MOV     ES:[SI+320*90],AL ;***
        INC     SI
        LOOP    runloop

        DEC     DX
        JNZ     getl

        MOV     BP,s_CNT
        lea      dx, [ebp+ebp*4]     ; Y*5
        shl      dx, 6               ; Y*64

        Keprerak dum32,0,s_DI,DX

        RET
BLURITY ENDP
;----------------------------------------
OUTLINY PROC  ; ES:0-tol FS:0-ra DX-sorcnt
              ;
       ; DL -> DH : y
       ; _ES  0A000h
       ; _FS  dum32

        MOV     SI,0
        ;XOR     EAX,EAX
        ;MOV     AL,DL
        ;MOV     BP,AX
        ;LEA     DI,[EBP+EBP*4]
        ;SHL     DI,6
        ;MOV     s_DI,DI
        ;XOR     CX,CX
        ;SUB     DH,DL
        ;SHR     DX,8
        ;INC     DX
        MOV     DI,0

        MOV     CX,320
lup1:
        MOV     AL,ES:DI
        MOV     FS:SI,AL
        INC     SI
        INC     DI
        LOOP    lup1

        DEC     DX
        DEC     DX
        MOV     s_CNT,DX
getl2:
        MOV     CX,320
runloop2:
        XOR     AX,AX
        MOV     AL,ES:[DI-320]
        ADD     AL,ES:[DI+320]
        ADC     AH,0
        ADD     AL,ES:[DI+1]
        ADC     AH,0
        ADD     AL,ES:[DI-1]
        ADC     AH,0

        MOV     BL,ES:[DI]
        INC     DI
        ;--------------
        CMP     BL,0
        JNE     nemkellx
        CMP     AX,0
        JE      nemkellx

        MOV     BX,AX
        MOV     AL,254
        CMP     BX,0FEh*3
        JNB     sknemkell
        MOV     AL,254
        CMP     BX,0FEh*2
        JNB     sknemkell
        MOV     AL,65
        JMP     sknemkell
nemkellx:
        MOV     AL,BL
sknemkell:
        ;--------------
        MOV     FS:SI,AL

        INC     SI
        LOOP    runloop2

        DEC     DX
        JNZ     getl2

        MOV     CX,320
lup2:
        MOV     AL,ES:DI
        MOV     FS:SI,AL
        INC     SI
        INC     DI
        LOOP    lup2


;        MOV     BP,s_CNT
;        lea      dx, [ebp+ebp*4]     ; Y*5
;        shl      dx, 6               ; Y*64

;        Keprerak dum32,0,s_DI,DX

        RET
OUTLINY ENDP

;------------------------------------------------------------------------
SeqParms        DW      0100h           ; synchronous reset
                DW      0402h           ; CPU writes only to map 2
                DW      0704h           ; sequential addressing
                DW      0300h           ; clear synchronous reset

GCParms         DW      0204h           ; select map 2 for CPU reads
                DW      0005h           ; disable odd-even addressing
                DW      0006h           ; map starts at A000:0000


SZOVINIT PROC
                ;_CGenModeSet    PROC    near
                cli                     ; disable interrupts
                mov     dx,3C4h         ; Sequencer port address
                mov     si,offset SeqParms
                mov     cx,4
L01:            lodsw                   ; AH := value for Sequencer register
                                        ; AL := register number
                out     dx,ax           ; program the register
                loop    L01
                sti                     ; enable interrupts
                ; Program the Graphics Controller
                mov     dl,0CEh         ; DX := 3CEH (Graphics Controller port address)
                mov     si,offset GCParms
                mov     cx,3
L02:            lodsw                   ; program the Graphics Controller
                out     dx,ax
                loop    L02
                ; NOW A000-tol 32-byte-os chartable

        PUSH    DS
        _ES ctable
        _DS 0A000h
        MOV     SI,0
        MOV     DI,0
        MOV     CX,256*32/4
        REP     MOVSD
        POP     DS

        RET
SZOVINIT ENDP
;------------------------------------------------------
SEEKTXT PROC
        _ES   DS
        MOV   DI,TEXTP
        MOV   AL,0
        MOV   CX,80 ; max. 80
        REPNE SCASB
        JNE notfound
        ; DI-after the '\0'
        MOV TEXTP,DI
notfound:
        RET
SEEKTXT ENDP

;LEP1S   DB  '    John Zer',0
;LEP2S   DB  '    presents',0
;LEP3S   DB  '- I can do this! -',0
MYTEXT  DB  '    John Zer',0
        DB  '    presents',0
        DB  '- I can do this! -',0
     ;      |                    |
        DB  'This is my first',0
        DB  'non-intro.It is very',0
        DB  'cool! Yeyeyeathom...',0

        DB  'Greetingz...      ',0
        DB  ' Fuckingz...     ',0
        DB  '  Anythingz...    ',0

        DB  ' +  Goodbyz...  +   ',0

        DB  0 ; kell a seeknek!
TEXTP   DW  OFFSET MYTEXT
TEXTXY  DW  3512h,5812h,7A12h, 2 dup (3501h,5801h,7A01h), 580Ah
TEXTCNT DW  0

LEPTOMB  DW 3 dup (OFFSET szovki,OFFSET szvesz,OFFSET lepblur22,OFFSET szrak)
         DW OFFSET lep13,OFFSET lep14,OFFSET lep15,OFFSET lep16
         DW OFFSET lep17,OFFSET lep18,OFFSET lep19,OFFSET lep20
         DW 3 dup (OFFSET szovki,OFFSET szvesz,OFFSET lepblur22,OFFSET szrak)
         DW OFFSET lep13,OFFSET lep14,OFFSET lep15,OFFSET lep16
         DW OFFSET lep17,OFFSET lep18,OFFSET lep19,OFFSET lep20
         DW 3 dup (OFFSET szovki,OFFSET szvesz,OFFSET lepblur22,OFFSET szrak)
         DW OFFSET lep13,OFFSET lep14,OFFSET lep15,OFFSET lep16
         DW OFFSET lep17,OFFSET lep18,OFFSET lep19,OFFSET lep20
         DW OFFSET szovki,OFFSET szvesz,OFFSET lepblur22,OFFSET szrak
           ; 1 2 3 4 5  6 7 8  9 10 11 12  13  14     15 16 17 18 19 20
LEPDELAY DW 3 dup (29,0,0,0)
         DW 46, 0FF02h,10, 0, 0, 0, 0, 0
         DW 3 dup (29,0,0,0)
         DW 46, 0FF02h,10, 0, 0, 0, 0, 0
         DW 3 dup (29,0,0,0)
         DW 46, 0FF02h,10, 0, 0, 0, 0, 0
         DW 1 dup (29,0,0,0)
lepdelend:
LEPIND   DW 0
MAXLEP   EQU ((offset lepdelend-offset lepdelay)/2)

DEBUGI   DB 15 dup (90h) ;************DEBUG

LEPESEK PROC
ideleszret:
        MOV    BX,LEPIND
        SHL    BX,1
        MOV    AX,LEPDELAY[BX]
        CMP    AH,0FFh    ; lepdelay=FFFF-> csak INC lepdelay-ra megy tovabb
        JNE    nemorok
        XOR    AH,AH
        CMP    ticc,AX
        JB     varok
        DEC    LEPIND

nemorok:
        CMP    ticc,AX
        JB     varok
belepo:
        MOV    ticc,0
        INC    LEPIND
        CMP    LEPIND,MAXLEP
        JNE    tovnem
        ;MOV    LEPIND,0
        ; hardwire to NULL
        MOV    AX,WORD PTR CS:[OFFSET VAROK]
        MOV    WORD PTR CS:[OFFSET ideleszret],AX
tovnem:
        CALL   LEPTOMB[BX]
varok:
        RET

szovki:
        MOV   SI,TEXTP
        MOV   BX,TEXTCNT
        SHL   BX,1
        MOV   DX,TEXTXY[BX]
        MOV   BH,254
        CALL  SZOVKIRAK ;DS:SI - szoveg0 DL:x DH:y BL:color
        INC   TEXTCNT
        CALL  SEEKTXT
        RET

szvesz:
        MOV   BX,TEXTCNT
        DEC   BX
        SHL   BX,1
        MOV   AX,TEXTXY[BX]
        SHR   AX,8
        MOV   DX,320
        MUL   DX
        MOV   DX,AX
        Keplevesz dum32,0,DX,(320*22h)
        RET
lepblur22:
        _ES dum32
        _FS dum32b
        MOV   DX,22h ;5535h
        CALL   OUTLINY
        RET
szrak:
        MOV   BX,TEXTCNT
        DEC   BX
        SHL   BX,1
        MOV   AX,TEXTXY[BX]
        SHR   AX,8
        MOV   DX,320
        MUL   DX
        MOV   DX,AX
        Keprerak dum32b,0,DX,(320*22h)
        RET

lep13:  MOV     FSTEP1,03Fh
        MOV     FSTEP2,01Fh
        RET

FSTEP1  DB 03Fh
FSTEP2  DB 01Fh

lep14:  ; fade out
        CMP     FSTEP1,4
        JNB     tovfad
        INC     LEPIND
        RET
tovfad:
        SUB     FSTEP1,3
        MOV     CL,FSTEP1
        MOV     DX,03C8h
        MOV     AL,254
        CLI
        OUT     DX,AL
        INC     DX
        MOV     AL,CL
        OUT     DX,AL
        MOV     AL,CL
        OUT     DX,AX
        MOV     AL,CL
        OUT     DX,AL
        STI

        CMP     FSTEP2,0
        JE      nemi2
        SUB     FSTEP2,1
        MOV     CL,FSTEP2
        MOV     DX,03C8h
        MOV     AL,65
        CLI
        OUT     DX,AL
        INC     DX
        MOV     AL,CL
        OUT     DX,AL
        MOV     AL,CL
        OUT     DX,AX
        MOV     AL,CL
        OUT     DX,AL
        STI
nemi2:
        RET

lep15:  ; clear scr
        KepClear 35h,9Fh
        RET
lep16:
        ; (fade) in fast
        MOV     CL,03Fh
        MOV     DX,03C8h
        MOV     AL,254
        CLI
        OUT     DX,AL
        INC     DX
        MOV     AL,CL
        OUT     DX,AL
        MOV     AL,CL
        OUT     DX,AX
        MOV     AL,CL
        OUT     DX,AL
        STI

        MOV     CL,1Fh
        MOV     DX,03C8h
        MOV     AL,65
        CLI
        OUT     DX,AL
        INC     DX
        MOV     AL,CL
        OUT     DX,AL
        MOV     AL,CL
        OUT     DX,AX
        MOV     AL,CL
        OUT     DX,AL
        STI
nemirom:
        RET
        RET
lep17:
        RET
lep18:
        RET
lep19:
        RET
lep20:
        RET
LEPESEK ENDP
;-----------------------------------------------------------------------
p_end:
ENDS SEGA
        END start
