
SEGMENT SEGA

INCLUDE johnmac.asi

ASSUME CS:SEGA,DS:SEGA
;ORG 100h

start:  JMP ST2

INCLUDE int_2.asi ; INTPAL , 768
INCLUDE sin_b.inc ; sinus table, 720
INCLUDE lbmload.asi

ticc    DW      0
negy    DB      0,8 dup (1),0,  1,8 dup (2),1,  6 dup (1,2,6 dup (3),2,1)
        DB      1,8 dup (2),1,  0,8 dup (1),0
scr     DW      ? ; screenbuf
scr2    DW      ? ; screenbuf
temps   DW      ?
fnam1   DB      'gal2.lbm',0
fnam2   DB      'temp3.lbm',0

ST2:
        CLD
.386
        MOV     AX,DS
        MOV     ES,AX
        MOV     AH,4Ah   ; reduce mem req. to
        MOV     BX,1100h ; 64 K + 100 : PSP/Stack
        INT     21h
        PUSH    CS
        POP     DS
        ;---------------------------
        Vga320mode

        AllocMem scr,65500 ; screen buf
        AllocMem scr2,65500 ; screen buf
        ClearMem scr,64000
        ClearMem scr2,64000

        AllocMem temps,64050 ; screen buf

;       Mov  Al,01111010b         ; Mask off all unneccesary interrupts.
;       Out  21h,Al

        MOV     SI,OFFSET INTPAL
        CALL    SETALLPALETTE

        LEA     SI,fnam1
        _ES     scr
        ;_ES     0A000h
        CALL LBMload

        mov     lb_dopal,0
        _ES     temps
        LEA     SI,fnam2
        CALL LBMload

        ;_ES     scr
        ;CALL    FILLHSZOG

        JMP     startcik

        MOV     CX,11
ellip:
        PUSH    CX
        CALL    ELLIPSE
        POP     CX
        ADD     ARGa,9
        ADD     ARGb,9
        LOOP    ellip

        CALL    FILLMY

        MOV     DX,1010h
        MOV     SI,OFFSET negy
        MOV     BX,10
        CALL    KIRAKOP
.386
       JMP      startcik

;mx1    DW       0
;mx2    DW       0
;mx3    DW       0
;my1    DW       0
;my2    DW       0
;my3    DW       199
sta1    DW       42
sta2    DW       7
sta3    DW       27

startcik:

       ;_ES     scr
       _FS     scr
       _GS     scr2

WaitEsc:
       INC   ticc

       ;SetPalette 0,3Fh,0,0

       ClearMem GS,64000
       CALL  movedn ; FS-> GS
       ;SetPalette 0,0,0,0

       ;ClearMem scr,64000
       ;WaitRetrace
       ;SetPalette 0,3Fh,0,0
       Keprerak GS,0,0,64000
       ;SetPalette 0,0,0,0

       MOV  AX,GS
       MOV  BX,FS
       MOV  FS,AX ; swap
       MOV  GS,BX

       In   Al,60h
       Cmp  Al,1
       Jne  WaitEsc              ; Wait until someone presses ESCAPE.

;        Mov  Al,0                 ; Let the interrupts come again...
;        Out  21h,Al

        TextMode
        FreeMem temps
        FreeMem scr
        FreeMem scr2
        ;RET
        MOV  AX,4C00h
        INT  21h
;------------------------END-

;
; SETALLPALETTE
;                Input: DS:SI - palette [768 bytes]
;
 SETALLPALETTE  PROC    near
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    DX
                PUSH    SI
                PUSH    DI

               ; MOV     SI,OFFSET       PAL
                XOR     BX,BX
                MOV     DI,256
 SZINEK:
                LODSW
                MOV     CH,AH
                MOV     AH,AL
                LODSB
                MOV     CL,AL
                MOV     DX,03C8h
                MOV     AL,BL
                CLI
                OUT     DX,AL
                INC     DX
                MOV     AL,AH
                OUT     DX,AL
                MOV     AL,CH
                OUT     DX,AX
                MOV     AL,CL
                OUT     DX,AL
                STI
                INC     BX
                DEC     DI
                JNZ     SZINEK

                POP     DI
                POP     SI
                POP     DX
                POP     CX
                POP     BX
                POP     AX
                RET
 SETALLPALETTE  ENDP
;-----------------------------------------------------------------------
KIRAKOP PROC ; DS:SI - sprite, DX:yyxx BX-size
        _ES    0A000h
        MOV     BP,DX
        SHR     BP,8
        LEA     DI,[EBP+EBP*4]
        SHL     DI,6
        AND     DX,0FFh
        ADD     DI,DX

        MOV     CX,BX


        RET
KIRAKOP ENDP
;------------------------------------------------------------------------
; Name:         Ellipse10
; Function:     Draw an ellipse in native EGA/VGA graphics modes.
; Caller:       Microsoft C:
;                       void Ellipse10(xc,yc,a,b,n);
;                       int xc,yc;              /* center of ellipse */
;                       int a,b;                /* major and minor axes */
;                       int n;                  /* pixel value */
;
ARGxc           DW  160 ;EQU     word ptr [bp+4] ; stack frame addressing
ARGyc           DW  100 ;EQU     word ptr [bp+6]
ARGa            DW  10 ;EQU     word ptr [bp+8]
ARGb            DW  10 ;EQU     word ptr [bp+10]
ARGn            DW  255 ;EQU     byte ptr [bp+12]

;ULAddr          EQU     word ptr [bp-2]
;URAddr          EQU     word ptr [bp-4]
;LLAddr          EQU     word ptr [bp-6]
;LRAddr          EQU     word ptr [bp-8]
;LMask           EQU     byte ptr [bp-10]
;RMask           EQU     byte ptr [bp-12]

VARd            DD  0 ;EQU     word ptr [bp-16]
VARdx           DD  0 ;EQU     word ptr [bp-20]
VARdy           DD  0 ;EQU     word ptr [bp-24]

Asquared        DD  ?
Bsquared        DD  ?
TwoAsquared     DD  ?
TwoBsquared     DD  ?

;RMWbits         EQU     0               ; read-modify-write bits
;BytesPerLine    EQU     80

Ellipse      PROC    near
; initial constants
                _ES     0A000h
                MOV     AX,320
                MUL     ARGyc
                ADD     AX,ARGxc
                mov     di,AX
                mov     si,AX
                ;MOV     _B ES:[DI],63
                mov     ax,ARGb
                mov     bx,320
                mul     bx
                ;shl     ax,1
                SUB     si,ax
                ADD     DI,AX

                MOV     BX,SI
                MOV     AX,DI
                SHL     EDI,16
                MOV     DI,BX
                SHL     ESI,16
                MOV     SI,AX
                XCHG    ESI,EDI

                xor     eax,eax
                mov     ax,ARGa
                mul     eax
                mov     Asquared,eax
                shl     eax,1
                mov     TwoAsquared,eax

                xor     eax,eax
                mov     ax,ARGb
                mul     eax
                mov     Bsquared,eax
                shl     eax,1
                mov     TwoBsquared,eax

; plot pixels from (0,b) until dy/dx = -1
;
; initial decision variables

                xor     eax,eax
                mov     VARdx,eax
                                       ; dx = 0

                mov     eax,TwoAsquared
                xor     ecx,ecx
                mov     cx,ARGb
                mul     ecx
                mov     VARdy,eax         ; dy = TwoAsquared * b

                mov     eax,Asquared      ; EAX = Asquared
                sar     eax,2             ; EAX = Asquared/4

                add     eax,Bsquared
                sar     eax,2             ; EAX = Bsquared + Asquared/4

                mov     eax,Asquared
                xor     ecx,ecx
                mov     cx,ARGb
                mul     ecx               ; EAX = Asquared*b
                sub     VARd,eax          ; d = Bsquared - Asquared*b + Asquared/4

; loop until dy/dx >= -1

                mov     bx,ARGb         ; BX := initial y-coordinate

                ;xor     cx,cx           ; CH := 0 (initial y-increment)
                                        ; CL := 0 (initial x-increment)
L10:            mov     eax,VARdx
                sub     eax,VARdy
                jns     L20             ; jump if dx>=dy

                ;call    Set4Pixels
                MOV     BYTE PTR ES:[DI],255
                MOV     BYTE PTR ES:[SI],255
                ROR     EDI,16
                ROR     ESI,16
                MOV     BYTE PTR ES:[DI],255
                MOV     BYTE PTR ES:[SI],255
                ROR     EDI,16
                ROR     ESI,16

                ;mov     cx,1            ; CH := 0 (y-increment)
                                        ; CL := 1 (x-increment)
                ;XOR     CX,CX     ;***
                ADD     EDI,10001h
                SUB     ESI,10001h

                cmp     WORD PTR VARd[2],0
                js      L11             ; jump if d < 0

                ;mov     ch,1            ; increment in y direction
                SUB     DI,320
                ROR     EDI,16
                ADD     DI,320
                ADD     SI,320
                ROR     ESI,16
                SUB     SI,320
                ROR     EDI,16
                ROR     ESI,16

                dec     bx              ; decrement current y-coordinate

                mov     eax,VARdy
                sub     eax,TwoAsquared  ; EAX := dy - TwoAsquared
                mov     VARdy,eax        ; dy -= TwoAsquared

                sub     VARd,eax         ; d -= dy

L11:            mov     eax,VARdx
                add     eax,TwoBsquared  ; EAX := dx + TwoBsquared
                mov     VARdx,eax        ; dx += TwoBsquared

                add     eax,Bsquared     ; EAX := dx + Bsquared
                add     VARd,eax         ; d += dx + Bsquared

                jmp     L10
;
; plot pixels from current (x,y) until y < 0
;
; initial buffer address and bit mask
L20:            push    bx              ; preserve current y-coordinate
                push    cx              ; preserve x- and y-increments
                mov     eax,Asquared
                sub     eax,Bsquared    ; EAX := Asquared-Bsquared

                mov     ebx,eax         ; EBX := (Asquared-Bsquared)

                sar     eax,1           ; EAX := (Asquared-Bsquared)/2
                add     eax,ebx         ; DX:AX := 3*(Asquared-Bsquared)/2

                sub     eax,VARdx
                sub     eax,VARdy  ; EAX := 3*(Asquared-Bsquared)/2 - (dx+dy)

                sar     eax,2      ; EAX :=
                                   ;  ( 3*(Asquared-Bsquared)/2 - (dx+dy) )/2
                add     VARd,eax   ; update d

; loop until y < 0

                pop     cx              ; CH,CL := y- and x-increments
                pop     bx              ; BX := y

L21:            ;call    Set4Pixels
                MOV     BYTE PTR ES:[DI],255
                MOV     BYTE PTR ES:[SI],255
                ROR     EDI,16
                ROR     ESI,16
                MOV     BYTE PTR ES:[DI],255
                MOV     BYTE PTR ES:[SI],255
                ROR     EDI,16
                ROR     ESI,16

                ;mov     cx,100h         ; CH := 1 (y-increment)
                                        ; CL := 0 (x-increment)
                SUB     DI,320
                ROR     EDI,16
                ADD     DI,320
                ADD     SI,320
                ROR     ESI,16
                SUB     SI,320
                ROR     EDI,16
                ROR     ESI,16

                cmp     WORD PTR VARd[2],0
                jns     L22             ; jump if d >= 0

                ;mov     cl,1            ; increment in x direction
                ADD     EDI,10001h
                SUB     ESI,10001h

                mov     eax,VARdx
                add     eax,TwoBsquared  ; EAX := dx + TwoBsquared
                mov     VARdx,eax        ; dx += TwoBsquared

                add     VARd,eax         ; d += dx

L22:            mov     eax,VARdy
                sub     eax,TwoAsquared  ; DX:AX := dy - TwoAsquared
                mov     VARdy,eax        ; dy -= TwoAsquared

                sub     eax,Asquared     ; DX:AX := dy - Asquared
                sub     VARd,eax         ; d += Asquared - dy

                dec     bx              ; decrement y
                jns     L21             ; loop if y >= 0

                ret
Ellipse      ENDP

;--------------------------------------------------

FILLMY PROC
        CLD
        _ES     0A000h
        PUSH    DS
        _DS     0A000h
        MOV     DI,0
        MOV     SI,0
egysor:
        MOV     CX,160
pix:
        LODSB
        CMP     AL,0
        JE      lupit

lupit:
        LOOP    pix
        CMP     SI,64000
        JB      egysor

        POP     DS
        RET
FILLMY ENDP

;---------------------------------------------------------------
; FILLHSZOG : expects: ES : screen addr (ex. A000h)
;                      x1,y1, x2,y2, x3,y3 - points
;
;---------------------------------------------------------------
x1      DW      50
y1      DW      10
x2      DW      20
y2      DW      70
x3      DW     100
y3      DW      90
x4      DW       ?
y4      DW       ?
dx1     DD       ?
dx2     DD       ?
dx3     DD       ?

FILLHSZOG PROC
        ;_ES    0A000h

        MOV     AX,y3
        CMP     AX,y1   ; y3<y1?
        JNB     noch1
        SWAP    y1,y3
        SWAP    x1,x3
noch1:
        MOV     AX,y2
        CMP     AX,y1   ; y2<y1?
        JNB     noch2
        SWAP    y1,y2
        SWAP    x1,x2
noch2:
        MOV     AX,y3
        CMP     AX,y2   ; y2>y1?
        JNA     noch3
        SWAP    y3,y2
        SWAP    x3,x2
noch3:
        MOV     AX,y3
        MOV     y4,AX

        XOR     EAX,EAX
;        MOV     AX,y3
;        SUB     AX,y1
        MOV     AX,x2
        SUB     AX,x1   ; lehet(-) !
        CWDE
        XOR     EBX,EBX
;        MOV     BX,x2
;        SUB     BX,x1
        MOV     BX,y3
        SUB     BX,y1
        IMUL    EAX,EBX

        ;MOV     ECX,EAX    ; ECX <- EAX: (y3-y1)*(x2-x1)

        ;XOR     EAX,EAX
        ;MOV     AX,y2
        ;SUB     AX,y1
        ;IMUL    EAX,x1
        ;ADD     EAX,ECX    ; EAX : (y3-y1)*(x2-x1)+x1*(y2-y1)

        XOR     EBX,EBX
        MOV     BX,y2
        SUB     BX,y1
;        CMP     EBX,0
;        JE      nediv1
        ;XOR     EDX,EDX
        CDQ
        IDIV    EBX ; ?? EBX ??
;nediv1:
        ADD     AX,x1
        MOV     x4,AX

        MOV     AX,x4
        CMP     AX,x3   ; x4<x3?
        JNB     noch4
        SWAP    y4,y3
        SWAP    x4,x3
noch4:

; setcolor(BLUE);
; moveto(x1,y1);
; lineto(x2,y2);
; lineto(x3,y3);
; lineto(x1,y1);

; putpixel(x4,y4,YELLOW);


 ;long dx1=((long)(x3-x1)<<16)/(y3-y1);
        XOR     EBX,EBX
        MOV     BX,y3
        SUB     BX,y1      ; BX : (y3-y1)

        MOV     AX,x1
        CMP     AX,x3
        JNA     x1nem
        XOR     EAX,EAX
        MOV     AX,x1
        SUB     AX,x3    ; felt. x1>x3
        SHL     EAX,16
        XOR     EDX,EDX
        IDIV    EBX
        NEG     EAX      ; felt. x1>x3
        MOV     dx1,EAX
        JMP     skipff
x1nem:
        XOR     EAX,EAX
        MOV     AX,x3
        SUB     AX,x1    ; felt. x1<x3
        SHL     EAX,16
        XOR     EDX,EDX
        IDIV    EBX
        ;NEG     EAX      ; felt. x1<x3
        MOV     dx1,EAX
skipff:
        XOR     EAX,EAX
        MOV     AX,x4
        SUB     AX,x1
        SHL     EAX,16
        CDQ
        ;XOR     EDX,EDX
        IDIV    EBX
        MOV     dx2,EAX

        MOV     EAX,dx2
        SUB     EAX,dx1
        ;ADD     EAX,dx1
        MOV     dx3,EAX

; long dx2=((long)(x4-x1)<<16)/(y3-y1);
; long dx3=labs(dx2-dx1);
        JMP     jvars
; long x,y;
; long cnt=0;
; int out_cnt;
; x=((long)x1<<16);
; y=y1;
;
; int c,d;
hy      DW      ?
hx      DD      ?
o_cnt   DW      ?
cnt     DD      ?

jvars:
        ;MOV     cnt,0
        ;XOR     EAX,EAX
        MOV     AX,y1
        MOV     hy,AX
        XOR     EBP,EBP
        MOV     BP,AX

        MOV     AX,x1
        SHL     EAX,16
        MOV     hx,EAX
                         ; BX-ben meg mindig y1-y3
        MOV     CX,BX
        INC     CX
        CLD

        MOV     EBX,hx
        XOR     EDX,EDX ;cnt        ; hx:(32) EBX  cnt:(32) EDX
sorki1:
        ADD     EBX,dx1
        ADD     EDX,dx3

        INC     EBP
        lea     di, [ebp+ebp*4]     ; Y*5
        shl     di, 6               ; Y*64
        ROR     EBX,16
        ADD     di,BX
        ROL     EBX,16
        SHL     ECX,16

        MOV     EAX,EDX ;cnt
        SHR     EAX,16
        INC     AX
        MOV     CX,AX
        MOV     AL,255
        REP     STOSB

        SHR     ECX,16
        LOOP    sorki1

        MOV     hx,EBX ;*
        MOV     cnt,EDX ;*
; for (out_cnt=0 ; out_cnt<y3-y1 ; out_cnt++ )
;  {
;   x+=dx1;
;   y++;
;   cnt+=dx3;
;   for (c=0;c<(cnt>>16);c++)
;    putpixel((x>>16)+c,y,GREEN);
;  }

; y=y3;
; x=(long)x3<<16;
; dx1=((long)(x2-x3)<<16)/(y2-y3);
; dx2=((long)(x2-x4)<<16)/(y2-y3);
; dx3=labs(dx2-dx1);
; //cnt=0; inkabb maradjon!
; for (out_cnt=0 ; out_cnt<y2-y3 ; out_cnt++ )
;  {
;   x+=dx1;
;   y++;
;   cnt-=dx3; //!!
;   for (c=0;c<(cnt>>16);c++)
;    putpixel((x>>16)+c,y,RED);
;  }
;}

; dx1=((long)(x2-x3)<<16)/(y2-y3);
; dx2=((long)(x2-x4)<<16)/(y2-y3);


 ;long dx1=((long)(x3-x1)<<16)/(y3-y1);
        XOR     EBX,EBX
        MOV     BX,y2
        SUB     BX,y3      ; BX : (y2-y3)

;        MOV     AX,x2
;        CMP     AX,x3
        ;JNA     x1nem
        XOR     EAX,EAX
        MOV     AX,x2
        SUB     AX,x3    ; felt.... x1>x3
        SHL     EAX,16
        ;XOR     EDX,EDX
        CDQ
        IDIV    EBX
        NEG     EAX      ; felt.... x1>x3
        MOV     dx1,EAX
;        JMP     skipff
;x1nem:
;        XOR     EAX,EAX
;        MOV     AX,x3
;        SUB     AX,x1    ; felt. x1<x3
;        SHL     EAX,16
;        XOR     EDX,EDX
;        IDIV    EBX
        ;NEG     EAX      ; felt. x1<x3
;        MOV     dx1,EAX
;skipff:
        XOR     EAX,EAX
        MOV     AX,x2
        SUB     AX,x4
        SHL     EAX,16
        ;XOR     EDX,EDX
        CDQ
        IDIV    EBX
        NEG     EAX
        MOV     dx2,EAX

        MOV     EAX,dx2
        SUB     EAX,dx1
        MOV     dx3,EAX

; long dx2=((long)(x4-x1)<<16)/(y3-y1);
; long dx3=labs(dx2-dx1);

                         ; EBP - y coord meg mindig
                         ; BX-ben meg mindig y2-y3
        MOV     CX,BX
        DEC     CX
        CLD

        MOV     EAX,dx1
        NEG     EAX
        MOV     dx1,EAX

        MOV     EBX,hx
        MOV     EDX,cnt        ; hx:(32) EBX  cnt:(32) EDX
sorki2:
        ADD     EBX,dx1
        SUB     EDX,dx3

        INC     EBP        ; y++
        lea     di, [ebp+ebp*4]     ; Y*5
        shl     di, 6               ; Y*64
        ROR     EBX,16
        ADD     di,BX
        ROL     EBX,16
        SHL     ECX,16

        MOV     EAX,EDX
        SHR     EAX,16
        INC     AX
        MOV     CX,AX
        MOV     AL,255
        REP     STOSB

        SHR     ECX,16
        LOOP    sorki2

        RET
FILLHSZOG ENDP
;--------------------------------------------------------------
FILLHSZOGx PROC        ; ES-re, FS-bol
        ;_ES    0A000h

        MOV     AX,y3
        CMP     AX,y1   ; y3<y1?
        JNB     noch1x
        SWAP    y1,y3
        SWAP    x1,x3
noch1x:
        MOV     AX,y2
        CMP     AX,y1   ; y2<y1?
        JNB     noch2x
        SWAP    y1,y2
        SWAP    x1,x2
noch2x:
        MOV     AX,y3
        CMP     AX,y2   ; y2>y1?
        JNA     noch3x
        SWAP    y3,y2
        SWAP    x3,x2
noch3x:
        MOV     AX,y3
        MOV     y4,AX

        XOR     EAX,EAX
        MOV     AX,x2
        SUB     AX,x1   ; lehet(-) !
        CWDE
        XOR     EBX,EBX
        MOV     BX,y3
        SUB     BX,y1
        IMUL    EAX,EBX
        XOR     EBX,EBX
        MOV     BX,y2
        SUB     BX,y1
        CDQ
        IDIV    EBX ; ?? EBX ??
        ADD     AX,x1
        MOV     x4,AX

        MOV     AX,x4
        CMP     AX,x3   ; x4<x3?
        JNB     noch4x
        SWAP    y4,y3
        SWAP    x4,x3
noch4x:

        XOR     EBX,EBX
        MOV     BX,y3
        SUB     BX,y1      ; BX : (y3-y1)

        MOV     AX,x1
        CMP     AX,x3
        JNA     x1nemx
        XOR     EAX,EAX
        MOV     AX,x1
        SUB     AX,x3    ; felt. x1>x3
        SHL     EAX,16
        XOR     EDX,EDX
        IDIV    EBX
        NEG     EAX      ; felt. x1>x3
        MOV     dx1,EAX
        JMP     skipffx
x1nemx:
        XOR     EAX,EAX
        MOV     AX,x3
        SUB     AX,x1    ; felt. x1<x3
        SHL     EAX,16
        XOR     EDX,EDX
        IDIV    EBX
        MOV     dx1,EAX
skipffx:
        XOR     EAX,EAX
        MOV     AX,x4
        SUB     AX,x1
        SHL     EAX,16
        CDQ
        IDIV    EBX
        MOV     dx2,EAX

        MOV     EAX,dx2
        SUB     EAX,dx1
        MOV     dx3,EAX
;        JMP     jvarsx

;hy      DW      ?
;hx      DD      ?
;o_cnt   DW      ?
;cnt     DD      ?

;jvarsx:
        MOV     AX,y1
        MOV     hy,AX
        XOR     EBP,EBP
        MOV     BP,AX

        MOV     AX,x1
        SHL     EAX,16
        MOV     hx,EAX
                         ; BX-ben meg mindig y1-y3
        MOV     CX,BX
        INC     CX
        CLD

        MOV     EBX,hx
        XOR     EDX,EDX ;cnt        ; hx:(32) EBX  cnt:(32) EDX
sorki1x:
        ADD     EBX,dx1
        ADD     EDX,dx3

        INC     EBP
        lea     di, [ebp+ebp*4]     ; Y*5
        shl     di, 6               ; Y*64
        ROR     EBX,16
        ADD     di,BX
        ROL     EBX,16
        SHL     ECX,16

        MOV     EAX,EDX ;cnt
        SHR     EAX,16
        INC     AX
        MOV     CX,AX
        ;MOV     AL,255
        ;REP     STOSB
lstor1:
        MOV     AL,FS:DI
        MOV     ES:DI,AL
        INC     DI
        LOOP    lstor1

        SHR     ECX,16
        LOOP    sorki1x

        MOV     hx,EBX ;*
        MOV     cnt,EDX ;*
        XOR     EBX,EBX
        MOV     BX,y2
        SUB     BX,y3      ; BX : (y2-y3)

        XOR     EAX,EAX
        MOV     AX,x2
        SUB     AX,x3    ; felt.... x1>x3
        SHL     EAX,16
        CDQ
        IDIV    EBX
        NEG     EAX      ; felt.... x1>x3
        MOV     dx1,EAX
        XOR     EAX,EAX
        MOV     AX,x2
        SUB     AX,x4
        SHL     EAX,16
        CDQ
        IDIV    EBX
        NEG     EAX
        MOV     dx2,EAX

        MOV     EAX,dx2
        SUB     EAX,dx1
        MOV     dx3,EAX
                         ; EBP - y coord meg mindig
                         ; BX-ben meg mindig y2-y3
        MOV     CX,BX
        DEC     CX
        CLD

        MOV     EAX,dx1
        NEG     EAX
        MOV     dx1,EAX

        MOV     EBX,hx
        MOV     EDX,cnt        ; hx:(32) EBX  cnt:(32) EDX
sorki2x:
        ADD     EBX,dx1
        SUB     EDX,dx3

        INC     EBP        ; y++
        lea     di, [ebp+ebp*4]     ; Y*5
        shl     di, 6               ; Y*64
        ROR     EBX,16
        ADD     di,BX
        ROL     EBX,16
        SHL     ECX,16

        MOV     EAX,EDX
        SHR     EAX,16
        INC     AX
        MOV     CX,AX
        ;MOV     AL,255
        ;REP     STOSB
lstor2:
        MOV     AL,FS:DI
        MOV     ES:DI,AL
        INC     DI
        LOOP    lstor2


        SHR     ECX,16
        LOOP    sorki2x

        RET
FILLHSZOGx ENDP
;------------------------------------------------------------------------
; 256 items
sztab  DW    0,    1,    2,    3,    4,    5,    6,    7,   -8,   -7
       DW   -6,   -5,   -4,   -3,   -2,   -1,  320,  321,  322,  323
       DW  324,  325,  326,  327,  312,  313,  314,  315,  316,  317
       DW  318,  319,  640,  641,  642,  643,  644,  645,  646,  647
       DW  632,  633,  634,  635,  636,  637,  638,  639,  960,  961
       DW  962,  963,  964,  965,  966,  967,  952,  953,  954,  955
       DW  956,  957,  958,  959, 1280, 1281, 1282, 1283, 1284, 1285
       DW 1286, 1287, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279
       DW 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1592, 1593
       DW 1594, 1595, 1596, 1597, 1598, 1599, 1920, 1921, 1922, 1923
       DW 1924, 1925, 1926, 1927, 1912, 1913, 1914, 1915, 1916, 1917
       DW 1918, 1919, 2240, 2241, 2242, 2243, 2244, 2245, 2246, 2247
       DW 2232, 2233, 2234, 2235, 2236, 2237, 2238, 2239, -2560, -2559
       DW -2558, -2557, -2556, -2555, -2554, -2553, -2568, -2567, -2566, -2565
       DW -2564, -2563, -2562, -2561, -2240, -2239, -2238, -2237, -2236, -2235
       DW -2234, -2233, -2248, -2247, -2246, -2245, -2244, -2243, -2242, -2241
       DW -1920, -1919, -1918, -1917, -1916, -1915, -1914, -1913, -1928, -1927
       DW -1926, -1925, -1924, -1923, -1922, -1921, -1600, -1599, -1598, -1597
       DW -1596, -1595, -1594, -1593, -1608, -1607, -1606, -1605, -1604, -1603
       DW -1602, -1601, -1280, -1279, -1278, -1277, -1276, -1275, -1274, -1273
       DW -1288, -1287, -1286, -1285, -1284, -1283, -1282, -1281, -960, -959
       DW -958, -957, -956, -955, -954, -953, -968, -967, -966, -965
       DW -964, -963, -962, -961, -640, -639, -638, -637, -636, -635
       DW -634, -633, -648, -647, -646, -645, -644, -643, -642, -641
       DW -320, -319, -318, -317, -316, -315, -314, -313, -328, -327
       DW -326, -325, -324, -323, -322, -321


movedn proc ; FS -> GS, ES:templ
        _ES temps
        ;_FS scr2
        ;_GS scr
        _XOR DI
        _XOR SI
        _XOR DX
        _XOR BP
        MOV     CX,64000
ujcik:
        XOR    EBX,EBX
        MOV    BL,ES:SI ;BP
        MOV    DI,DS:[offset sztab+EBX*2]
        ADD    DI,SI;DX
        MOV    AL,FS:SI
        MOV    GS:DI,AL
        ;INC    DX
        INC    SI
        ;INC    BP
        LOOP   ujcik
        RET
movedn endp
;-------------------------------------------------------------------------
p_end:
ENDS SEGA
        END start
