#include <conio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <sys\stat.h>
#include <mem.h>
#include <alloc.h>
#include <ctype.h>

#define ms 5 //150

void put_vga_pixel(unsigned int x, unsigned int y , char col );
void vgainit( char mode );
void initmodes( int mod );
void clearpalette( void );
//int huge detectVGA256(void);

int xsize;
int ysize;
unsigned int extended_vga_xsize;
char current_vga_page,
     last_vga_page,
     color,
     videomode,
     readmode;

void vgainit( char mode )
{
 asm {
  mov ah,0
  mov al,mode
  int 10h
     }
}

void setxysize(int x,int y)
{
 xsize = x;
 ysize = y;
}

void initmodes( int videomode )
{
  vgainit( videomode );
  if ( videomode==19 ) setxysize(319,199);
  if ( videomode==92 ) setxysize(639,399);
  if ( videomode==93 ) setxysize(639,479);
  if ( videomode==94 ) setxysize(799,599);
  if ( videomode==98 ) setxysize(1023,767);
  extended_vga_xsize=xsize+1;
}

void put_vga_pixel(unsigned int x, unsigned int y , char col )
{
  asm {
       mov ax,x
       add ax,y
       mov dx,0
       mov bx,3
       mov bx,3
       div bx
       mov al,col
       mov color,al

     //extended_vga:
       mov dx,0xA000
       mov es,dx
       mov ax,extended_vga_xsize
       mul y
       add ax,x
       adc dx,0
       mov bx,ax
       mov current_vga_page,dl
       cmp dl,last_vga_page
       je put_pixel;
       jmp change_vga_page
     }
 vissza:
 put_pixel:
 asm {
      //put_pixel:
      mov ah,col
      mov es:[bx],ah
      jmp endpixel
     }

 change_vga_page:
 asm {
      mov ah,current_vga_page
      mov dx,0x3C4
      mov al,0xE
      out dx,al
      mov dx,0x3C5
      in al,dx
      and ax,0xFF0
      xor ah,2
      or al,ah
      out dx,al
      mov dl,current_vga_page
      mov last_vga_page,dl;
      jmp vissza
     }

 endpixel:;
}

void set_vga_page( char c_vga_page )
{
 asm {
      mov ah,c_vga_page
      mov dx,0x3C4
      mov al,0xE
      out dx,al
      mov dx,0x3C5
      in al,dx
      and ax,0xFF0
      xor ah,2
      or al,ah
      out dx,al
      mov dl,c_vga_page
      mov last_vga_page,dl;
     }
}

void clearpalette( void )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[257];
 int pf;

 union REGPACK reg;

 int i;

 for (i=0; i<=255; i++)
  {
   pt[i].r=0; pt[i].g=0; pt[i].b=0;
  }

 reg.r_ax = 0x10 << 8 | 0x12 ;
 reg.r_bx = 0;
 reg.r_cx = 255;
 reg.r_es = _DS;
 reg.r_dx = (unsigned)pt;

 intr(0x10, &reg);
}


void dopalette( char pl[] )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 union REGPACK reg;

 int i,d;

 /*********
 for (i=0; i<=63; i++)
  {
   pt[i].r=i; pt[i].g=i; pt[i].b=i;
   //pt[127-i].r=i; pt[127-i].g=i; pt[127-i].b=i;
  }
 *********/

 for ( d=1 ; d<=ms ; d++ )
  {
   for (i=0; i<=255; i++)
    {
     pt[i].r=((pl[3*i]*d)/ ms );
     pt[i].g=((pl[3*i+1]*d)/ms );
     pt[i].b=((pl[3*i+2]*d)/ms );
    }

   for (i=0; i<=255; i++)
    {
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
    }

   /*
   reg.r_ax = 0x10 << 8 | 0x12 ;
   reg.r_bx = 0;
   reg.r_cx = 255;
   reg.r_es = _DS;
   reg.r_dx = (unsigned)pt;
   intr(0x10, &reg);
   */

   //delay(10);
  }
 /*
 for (i=0; i<=255; i++)
  {
   pt2.r=(pl[3*i]/4);
   pt2.g=(pl[3*i+1]/4);
   pt2.b=(pl[3*i+2]/4);

   /*
   reg.r_ax = 0x10 << 8 | 0x10 ;
   reg.r_bx = i;
   reg.r_dx = pt2.r<<8;
   reg.r_cx = pt2.g<<8 | pt2.b;
   intr(0x10, &reg);
   */
   outportb(0x3C8,i);

   outportb(0x3C9,pt2.r);
   outportb(0x3C9,pt2.g);
   outportb(0x3C9,pt2.b);

   delay(10);

   //delay(10);
  }
 */
}

void undopalette( char pl[] )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 union REGPACK reg;

 int i,d;

 /*********
 for (i=0; i<=63; i++)
  {
   pt[i].r=i; pt[i].g=i; pt[i].b=i;
   //pt[127-i].r=i; pt[127-i].g=i; pt[127-i].b=i;
  }
 *********/

 for ( d=ms ; d>=1 ; d-- )
  {
   for (i=0; i<=255; i++)
    {
     pt[i].r=((pl[3*i]*d)/ ms );
     pt[i].g=((pl[3*i+1]*d)/ms );
     pt[i].b=((pl[3*i+2]*d)/ms );
    }

   for (i=0; i<=255; i++)
    {
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
    }

   /*
   reg.r_ax = 0x10 << 8 | 0x12 ;
   reg.r_bx = 0;
   reg.r_cx = 255;
   reg.r_es = _DS;
   reg.r_dx = (unsigned)pt;
   intr(0x10, &reg);
   */

   //delay(10);
  }
 /*
 for (i=0; i<=255; i++)
  {
   pt2.r=(pl[3*i]/4);
   pt2.g=(pl[3*i+1]/4);
   pt2.b=(pl[3*i+2]/4);

   /*
   reg.r_ax = 0x10 << 8 | 0x10 ;
   reg.r_bx = i;
   reg.r_dx = pt2.r<<8;
   reg.r_cx = pt2.g<<8 | pt2.b;
   intr(0x10, &reg);
   */
   outportb(0x3C8,i);

   outportb(0x3C9,pt2.r);
   outportb(0x3C9,pt2.g);
   outportb(0x3C9,pt2.b);

   delay(10);

   //delay(10);
  }
 */
}


void main ( int argc , char *argv[] )
{
 int c,ch;
 char mt[800];
 char mt2[800];
 char mt3[800];
 char mt4[800];
 char mtx[400];
 char at;

 initmodes( 19 );

 //put_vga_pixel (500,500,50 );
 //for (c=0 ; c<=255 ; c++ )
 // put_vga_pixel (c,c,c );
 int fh;
 int x,y;

 //loadpalette("NPAL.COL");

 char far *scrn;
 char far *scrn2;
 char *sb;
 scrn=(char far *)MK_FP(0xA000,0);
 scrn2=(char far *)MK_FP(0xA000,32000);
 char fnev[50];

 y=0;
 fh=open(/*"$64.IMG"*/argv[1], O_BINARY | O_RDWR);
 lseek( fh,32,SEEK_SET );
 read( fh,mt,768 );
 //dopalette( mt );

 clearpalette();

 sb=(char *)malloc(32000);
   read( fh,sb, 32000 );
   _fmemcpy( scrn , sb , 32000 );
   read( fh,sb, 32000 );
   _fmemcpy( scrn2 , sb , 32000 );
 close(fh);

 //getch();

 for ( c=0 ; c<=255 ; c++ )
  {
   mt[3*c]/=4;
   mt[3*c+1]/=4;
   mt[3*c+2]/=4;
  }

 dopalette( mt );
 /***
 ch=0;
 while( ch!=27)
 {
  dopalette( mt );

  getch();

  undopalette( mt );

  ch=toupper(getch());
 }
 ***/

 //initmodes( 3 );
}




/* detects VGA cards */

/****************
int huge detectVGA256(void)
{
   int driver, mode, sugmode = 0;

   detectgraph(&driver, &mode);
   if (driver == VGA)
      return sugmode;
   else
      return grError;
}
************/
