
PAGE  59,132

;
;					                                 
;				HSCMEM	                                 
;					                                 
;      Created:   30-Jan-94		                                 
;      Code type: zero start		                                 
;      Passes:    5          Analysis	Options on: none                 
;					                                 
;

.286c


SEG_A		SEGMENT	BYTE PUBLIC
		ASSUME	CS:SEG_A, DS:SEG_A


		ORG	0

HSCMEM		PROC	FAR

START:
		;PUSH CS ; ***
		;POP DS  ; ***

		PUSH	DS
		PUSH	ES
		CMP	AH,6
		JG	HSC_RET			; Jump if >
		SHL	AH,1			; Shift w/zeros fill
		MOV	AL,AH
		XOR	AH,AH			; Zero register
		MOV	DI,AX
		JMP	WORD PTR CS:[DI+14H]	;*7 entries
		;JMP	WORD PTR CS:[DI+OFFSET DATA_4]	;*7 entries
		nop	                        ;*ASM fixup - displacement
; 14h offset:
DATA_4		DW	OFFSET HSCStart    ; ah=0 - start
DATA_5		DW	OFFSET POLL_MUSIC    ; ah=1 - poll music
DATA_6		DW	OFFSET HSCStop  ; ah=2 - stop music
DATA_7		DW	OFFSET LOC_8    ; 3 : fade out music
DATA_8		DW	OFFSET SNDINIT  ; ah=4 - init
DATA_9		DW	OFFSET RASTER_Set   ; 5 rasterbar
DATA_10		DW	OFFSET LOC_12   ; 6 link user irq bl=0 |1 link ds:dx
HSC_RET:
		POP	ES
		POP	DS
		RETF				; Return far

; Indexed Entry Point 

HSCStart:
		CMP	BYTE PTR CS:DATA_16,0
		JE	LOC_3			; Jump if equal
		PUSHA				; Save all regs
		CALL	INT1CRestore
		POPA				; Restore all regs
LOC_3:
		PUSHA				; Save all regs
		CALL	INT1CHook
		POPA				; Restore all regs
		JMP	SHORT HSC_RET

; Indexed Entry Point 

POLL_MUSIC:
		CMP	BYTE PTR CS:DATA_15,0
		JE	LOC_6			; Jump if equal
		CMP	BYTE PTR CS:DATA_16,0
		JE	LOC_6			; Jump if equal
		PUSHA				; Save all regs
		PUSH	DS
		PUSH	ES
		MOV	DS,CS:MusicSeg
		MOV	DI,OFFSET DATA_34
		DEC	BYTE PTR CS:[DI]
		MOV	AH,CS:[DI]
		CMP	AH,0
		JNE	LOC_5			; Jump if not equal
		MOV	AL,CS:DATA_36
		MOV	CS:[DI],AL
		CALL	SUB_2
LOC_5:
		CALL	SUB_9
		CALL	SUB_10
		CALL	SUB_1
		;;MOV	BX,893H ; USERINTR offs-je

		MOV	BX,OFFSET USERINTR
		CALL	DWORD PTR CS:[BX]	;*1 entry
		POP	ES			; linked user irq
		POP	DS
		POPA				; Restore all regs
LOC_6:
		MOV	BYTE PTR CS:DATA_15,0
		JMP	SHORT HSC_RET

; Indexed Entry Point 

HSCStop:
		CMP	BYTE PTR CS:DATA_16,0
		JE	HSC_RET			; Jump if equal
		PUSHA				; Save all regs
		CALL	INT1CRestore
		POPA				; Restore all regs
		JMP	SHORT HSC_RET

; Indexed Entry Point 

LOC_8:
		MOV	BYTE PTR CS:DATA_37,0FFH
		JMP	SHORT HSC_RET

; Indexed Entry Point 

SNDINIT:
		PUSHA				; Save all regs
		CALL	CardDetect
		CMP	AX,0FFFFH
		JNE	LOC_10			; Jump if not equal
		POPA				; Restore all regs
		MOV	AX,0FFFFH
		STC				; Set carry flag
		JMP	HSC_RET
LOC_10:
		POPA				; Restore all regs
		MOV	AX,CS:CardAddr
		CLC				; Clear carry flag
		JMP	HSC_RET

; Indexed Entry Point 

RASTER_Set:
		XOR	BYTE PTR CS:RASTER_State,0FFH
		NOP
		JMP	HSC_RET

; Indexed Entry Point 

LOC_12:
		CMP	BL,0
		JE	LOC_13			; Jump if equal
		MOV	WORD PTR CS:USERINTR,DX
		MOV	WORD PTR CS:USERINTR+2,DS
		JMP	HSC_RET
LOC_13:
		PUSH	AX
		MOV	AX,0E2H
		MOV	WORD PTR CS:USERINTR,AX
		PUSH	CS
		POP	AX
		MOV	WORD PTR CS:USERINTR+2,AX
		POP	AX
		JMP	HSC_RET
		DB	0CBH

HSCMEM		ENDP

;
;
;                       External Entry Point
;
;

INT_1CH_ENTRY	PROC	FAR
		PUSHA				; Save all regs
		PUSH	DS
		PUSH	ES
		CMP	BYTE PTR CS:DATA_14,0
		JE	LOC_14			; Jump if equal
		MOV	BYTE PTR CS:DATA_15,1
		JMP	LOC_26
LOC_14:
		MOV	DS,CS:MusicSeg
		XOR	AL,AL			; Zero register
		CMP	CS:RASTER_State,AL ; do rasters?
		JE	NO_RASTERS		   ; no -> Jump
		MOV	DX,3DAH
LOC_15:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JNZ	LOC_15			; Jump if not zero
		MOV	DX,3DAH
LOC_16:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JZ	LOC_16			; Jump if zero
		MOV	DX,3DAH
LOC_17:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JZ	LOC_17			; Jump if zero
		MOV	DX,3DAH
LOC_18:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JNZ	LOC_18			; Jump if not zero
		MOV	DX,3DAH
LOC_19:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,1
		JNZ	LOC_19			; Jump if not zero
		MOV	DX,3DAH
LOC_20:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,1
		JZ	LOC_20			; Jump if zero
		MOV	DX,3C0H
		MOV	AL,0
		OUT	DX,AL			; port 3C0H, EGA attributes
		MOV	AL,1
		OUT	DX,AL			; port 3C0H, EGA attributes
		MOV	AL,20H			; ' '
		OUT	DX,AL			; port 3C0H, EGA attributes

NO_RASTERS:
		MOV	DI,OFFSET DATA_34
		DEC	BYTE PTR CS:[DI]
		MOV	AH,CS:[DI]
		CMP	AH,0
		JNE	LOC_22			; Jump if not equal
		MOV	AL,CS:DATA_36
		MOV	CS:[DI],AL
		CALL	SUB_2
LOC_22:
		CALL	SUB_9
		CALL	SUB_10
		CALL	SUB_1
		XOR	AL,AL			; Zero register
		CMP	CS:RASTER_State,AL
		JE	NO_RASTER_END		; Jump if equal

					; else do end of rasters
		MOV	DX,3DAH
LOC_23:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,1
		JNZ	LOC_23			; Jump if not zero
		MOV	DX,3DAH
LOC_24:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,1
		JZ	LOC_24			; Jump if zero
		MOV	DX,3C0H
		MOV	AL,0
		OUT	DX,AL			; port 3C0H, EGA attributes
		MOV	AL,0
		OUT	DX,AL			; port 3C0H, EGA attributes
		MOV	AL,20H			; ' '
		OUT	DX,AL			; port 3C0H, EGA attributes
NO_RASTER_END:
		;;MOV	BX,893H
		MOV	BX,OFFSET USERINTR
		CALL	DWORD PTR CS:[BX]	;*1 entry
LOC_26:
		POP	ES
		POP	DS
		POPA				; Restore all regs
		CMP	BYTE PTR CS:DATA_19,0
		JE	LOC_RET_27		; Jump if equal
		JMP	DWORD PTR CS:OLDINT1C

LOC_RET_27:
		IRET				; Interrupt return
INT_1CH_ENTRY	ENDP


;
;                              SUBROUTINE
;

SUB_1		PROC	NEAR
		CMP	BYTE PTR CS:DATA_37,0
		JE	LOC_RET_28		; Jump if equal
		CMP	BYTE PTR CS:DATA_38,3FH	; '?'
		JE	LOC_RET_28		; Jump if equal
		INC	CS:DATA_38
		PUSH	ES
		PUSH	CS
		POP	ES
		MOV	CX,12H
		MOV	DI,OFFSET DATA_31
		MOV	AL,1
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		POP	ES

LOC_RET_28:
		RETN
SUB_1		ENDP


;
;                              SUBROUTINE
;

SUB_2		PROC	NEAR
		MOV	SI,CS:MusicPatterns
		MOV	BX,CS:MusicOrder
		XOR	AX,AX
		MOV	AL,CS:M_ORDPOS
		ADD	BX,AX
		XOR	AX,AX
		MOV	AL,[BX]
		MOV	CS:M_CURRPATT,AL  ; (AH=0) AX(AL)-ben a pattern szama
		MOV	BX,480H        ; egy pattern hossza
		MUL	BX			; dx:ax = reg * ax
		ADD	SI,AX          ; AX - curr. pattern offsetje
				       ; [seg]:SI - az aktualis pattern eleje
		XOR	AX,AX			; Zero register
		MOV	AL,CS:M_SORPOS  ; curr pos (?
		MOV	BL,12H         ; egy zene sor hossza
		MUL	BL			; ax = reg * al
		ADD	SI,AX          ; [seg]:SI - az akt. pattern akt. sora
		MOV	CX,9           ; egy sorban 9 elem...

LOCLOOP_29:
		CALL	SUB_3       ; call sub_3 with each snd entry
		LOOP	LOCLOOP_29		; Loop if cx > 0

		MOV	DI,OFFSET M_SORPOS
		INC	BYTE PTR CS:[DI]
		MOV	BL,CS:[DI]
		CMP	BL,40H			; '@'
		JNE	LOC_RET_30		; Jump if not equal
		XOR	AL,AL			; Zero register
		MOV	CS:[DI],AL
		MOV	DI,OFFSET M_ORDPOS
		MOV	AL,1
		ADD	CS:[DI],AL
		MOV	SI,CS:MusicOrder
		XOR	BX,BX			; Zero register
		MOV	BL,CS:[DI]
		MOV	AL,[BX+SI]
		CMP	AL,0FFH
		JNE	LOC_RET_30		; Jump if not equal
		XOR	AL,AL			; Zero register
		MOV	CS:[DI],AL

LOC_RET_30:
		RETN
SUB_2		ENDP


;
;  SUBROUTINE - DS:SI points to next note entry
;               CL : 9 - <csatorna>
;

SUB_3		PROC	NEAR
		XOR	AX,AX			; Zero register
		MOV	AL,[SI]
		INC	SI
		CMP	AL,80H      ; Instr. change?
		JNE	LOC_31			; Jump if not equal
		JMP	LOC_42
LOC_31:
		CMP	AL,0        ; semmi hang?
		JE	LOC_32			; Jump if equal
		MOV	AH,9
		SUB	AH,CL       ; ah=csatorna, al-hang (01..)
		CALL	NOTE_Play       ; egyebkent hang-play

LOC_32:                             ; nincs semm hang -> attr?
		MOV	AL,[SI]
		INC	SI
		CMP	AL,0        ; van attr?
		JNE	LOC_33			; Jump if not equal
		JMP	LOC_RET_41
LOC_33:                             ; van attr. -> mi?
		CMP	AL,1
		JNE	LOC_34			; Jump if not equal
		MOV	AH,3FH			; '?'
		MOV	CS:M_SORPOS,AH
		JMP	LOC_RET_41
LOC_34:
		MOV	AH,AL
		AND	AX,0FF0H
		SHR	AL,4			; Shift w/zeros fill
		CMP	AL,1
		JNE	LOC_36			; Jump if not equal
		MOV	DI,OFFSET DATA_27
		MOV	BX,9
		SUB	BX,CX
		SHL	BX,1			; Shift w/zeros fill
		INC	AH
		ADD	CS:[BX+DI],AH
		MOV	WORD PTR CS:[BX+DI+12H],1
LOC_35:
		JMP	LOC_RET_41
LOC_36:
		CMP	AL,2
		JNE	LOC_37			; Jump if not equal
		MOV	DI,OFFSET DATA_27
		MOV	BX,9
		SUB	BX,CX
		SHL	BX,1			; Shift w/zeros fill
		INC	AH
		SUB	CS:[BX+DI],AH
		MOV	WORD PTR CS:[BX+DI+12H],1
		JMP	SHORT LOC_35
LOC_37:
		CMP	AL,0AH
		JNE	LOC_38			; Jump if not equal
		SHL	AH,2			; Shift w/zeros fill
		MOV	DI,OFFSET DATA_28
		MOV	BX,9
		SUB	BX,CX
		MOV	CS:[BX+DI],AH
		MOV	BYTE PTR CS:[BX+DI+12H],1
		JMP	SHORT LOC_RET_41
LOC_38:
		CMP	AL,0BH
		JNE	LOC_39			; Jump if not equal
		SHL	AH,2			; Shift w/zeros fill
		MOV	DI,OFFSET DATA_28
		MOV	BX,9
		SUB	BX,CX
		MOV	CS:[BX+DI+9],AH
		MOV	BYTE PTR CS:[BX+DI+1BH],1
		CMP	AX,265AH
		INC	BX
		JMP	SHORT LOC_RET_41
LOC_39:
		CMP	AL,0CH
		JNE	LOC_40			; Jump if not equal
		SHL	AH,2			; Shift w/zeros fill
		MOV	DI,OFFSET DATA_28
		MOV	BX,9
		SUB	BX,CX
		MOV	CS:[BX+DI],AH
		MOV	BYTE PTR CS:[BX+DI+12H],1
		PUSH	SI
		PUSH	AX
		PUSH	BX
		MOV	SI,OFFSET DATA_46
		MOV	AL,CS:[BX+SI]
		XOR	AH,AH			; Zero register
		MOV	BX,0CH
		MUL	BX			; dx:ax = reg * ax
		MOV	SI,CS:MusicInstr
		ADD	SI,AX
		POP	BX
		POP	AX
		TEST	BYTE PTR [SI+8],1
		POP	SI
		JZ	LOC_RET_41		; Jump if zero
		MOV	CS:[BX+DI+9],AH
		MOV	BYTE PTR CS:[BX+DI+1BH],1
		JMP	SHORT LOC_RET_41
LOC_40:
		CMP	AL,0FH
		INC	AH
		MOV	CS:DATA_36,AH
		MOV	CS:DATA_34,AH

LOC_RET_41:
		RETN
LOC_42:                           ; instrument change
		MOV	AL,[SI]
		AND	AL,7FH
		INC	SI
		MOV	AH,9
		SUB	AH,CL     ; ah-ban a csatorna
		CALL	INSTR_CHANGE     ; (al-ben az uj instrument)

		JMP	SHORT LOC_RET_41
SUB_3		ENDP


;
;     SUBROUTINE - restore 1c vect
;

INT1CRestore	PROC	NEAR
		CMP	BYTE PTR CS:DATA_18,0
		JE	LOC_43			; Jump if equal
		MOV	AX,251CH
		MOV	DX,WORD PTR CS:OLDINT1C
		MOV	CX,WORD PTR CS:OLDINT1C+2
		MOV	DS,CX
		INT	21H			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		MOV	BYTE PTR CS:DATA_18,0
LOC_43:
		XOR	AL,AL			; Zero register
		CALL	SUB_6
		MOV	BYTE PTR CS:DATA_16,0
		RETN
INT1CRestore	ENDP


;
;    SUBROUTINE - save & hook 1Ch & music params use
;

INT1CHook	PROC	NEAR
		MOV	CS:DATA_14,BL  ; play mode 0/1
		MOV	CS:DATA_19,BH  ; include/cut irq 0/1
		MOV	CS:MusicSeg,ES  ; Music data seg.
		MOV	CS:MusicInstr,SI  ; Music data - instruments
		ADD	SI,600H
		MOV	CS:MusicOrder,SI  ; Music data - order
		ADD	SI,33H
		MOV	CS:MusicPatterns ,SI  ; Music data - patterns
		MOV	DS,CS:MusicSeg
		XOR	AL,AL			; Zero register
		CALL	SUB_6
		MOV	AL,1
		MOV	AH,20H			; ' '
		CALL	ADL_OUT
		MOV	AL,8
		MOV	AH,40H			; '@'
		CALL	ADL_OUT
		MOV	AL,0BDH
		MOV	AH,0
		CALL	ADL_OUT
		XOR	AX,AX			; Zero register
		MOV	CX,9

LOCLOOP_44:
		CALL	INSTR_CHANGE
		ADD	AX,101H
		LOOP	LOCLOOP_44		; Loop if cx > 0

		MOV	BYTE PTR CS:DATA_37,0
		MOV	BYTE PTR CS:DATA_38,0
		MOV	BYTE PTR CS:DATA_34,1
		XOR	AL,AL			; Zero register
		MOV	CS:M_ORDPOS,AL
		MOV	CS:M_CURRPATT,AL
		MOV	CS:M_SORPOS,AL
		MOV	AL,2
		MOV	CS:DATA_36,AL
		PUSH	ES
		PUSH	CS
		POP	ES
		MOV	CX,12H
		MOV	DI,OFFSET DATA_31
		MOV	AL,1
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	CX,9
		MOV	DI,OFFSET DATA_47
		MOV	AL,0FFH
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		POP	ES
		MOV	AX,351CH
		INT	21H			; DOS Services  ah=function 35h
						;  get intrpt vector al in es:bx
		MOV	WORD PTR CS:OLDINT1C+2,ES
		MOV	WORD PTR CS:OLDINT1C,BX
		MOV	AX,251CH
		PUSH	CS
		POP	DS
		MOV	DX,OFFSET INT_1CH_ENTRY
		INT	21H			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		MOV	AL,0FFH
		MOV	CS:DATA_16,AL
		MOV	CS:DATA_18,AL
		RETN
INT1CHook	ENDP


;
;                              SUBROUTINE
;

SUB_6		PROC	NEAR
		MOV	AL,1
		MOV	AH,0
		CALL	ADL_OUT
		MOV	AL,0B0H
		CALL	ADL_OUT
		MOV	AL,0B1H
		CALL	ADL_OUT
		MOV	AL,0B2H
		CALL	ADL_OUT
		MOV	AL,0B3H
		CALL	ADL_OUT
		MOV	AL,0B4H
		CALL	ADL_OUT
		MOV	AL,0B5H
		CALL	ADL_OUT
		MOV	AL,0B6H
		CALL	ADL_OUT
		MOV	AL,0B7H
		CALL	ADL_OUT
		MOV	AL,0B8H
		CALL	ADL_OUT
		MOV	AL,80H
		MOV	AH,0FFH
		CALL	ADL_OUT
		MOV	AL,81H
		CALL	ADL_OUT
		MOV	AL,82H
		CALL	ADL_OUT
		MOV	AL,83H
		CALL	ADL_OUT
		MOV	AL,84H
		CALL	ADL_OUT
		MOV	AL,85H
		CALL	ADL_OUT
		MOV	AL,88H
		CALL	ADL_OUT
		MOV	AL,89H
		CALL	ADL_OUT
		MOV	AL,8AH
		CALL	ADL_OUT
		MOV	AL,8BH
		CALL	ADL_OUT
		MOV	AL,8CH
		CALL	ADL_OUT
		MOV	AL,8DH
		CALL	ADL_OUT
		MOV	AL,90H
		CALL	ADL_OUT
		MOV	AL,91H
		CALL	ADL_OUT
		MOV	AL,92H
		CALL	ADL_OUT
		MOV	AL,93H
		CALL	ADL_OUT
		MOV	AL,94H
		CALL	ADL_OUT
		MOV	AL,95H
		CALL	ADL_OUT
		PUSH	ES
		PUSH	CS
		POP	ES
		MOV	DI,OFFSET DATA_27
		MOV	AX,0
		MOV	CX,9
		REP	STOSW			; Rep when cx >0 Store ax to es:[di]
		MOV	AX,1
		MOV	CX,9
		REP	STOSW			; Rep when cx >0 Store ax to es:[di]
		MOV	DI,OFFSET DATA_28
		MOV	AL,0
		MOV	CX,12H
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	AL,1
		MOV	CX,12H
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	DI,OFFSET DATA_46
		MOV	AL,0FFH
		MOV	CX,9
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	DI,OFFSET DATA_44
		MOV	AL,0
		MOV	CX,9
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	CX,9
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	DI,OFFSET DATA_47
		MOV	AL,0FFH
		MOV	CX,9
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		POP	ES
		RETN
SUB_6		ENDP


;
;   SUBROUTINE - instrument change
;        AH:csatorna AL:uj hangszer
;

INSTR_CHANGE	PROC	NEAR
		PUSHA				; Save all regs
		XOR	CX,CX			; Zero register
		MOV	DI,OFFSET DATA_46
		XOR	BX,BX			; Zero register
		MOV	BL,AH
		CMP	CS:[BX+DI],AL
		JNE	LOC_45			; Jump if not equal
		JMP	LOC_46
LOC_45:
		MOV	CS:[BX+DI],AL
		MOV	CL,AH
		XOR	AH,AH			; Zero register
		MOV	BX,0CH
		MUL	BX			; dx:ax = reg * ax
		MOV	SI,CS:MusicInstr
		ADD	SI,AX
		MOV	AL,0B0H
		ADD	AL,CL
		XOR	AH,AH			; Zero register
		CALL	ADL_OUT
		MOV	AL,0C0H
		ADD	AL,CL
		MOV	AH,[SI+8]
		CALL	ADL_OUT
		MOV	DI,OFFSET DATA_22
		ROL	CX,1			; Rotate
		ADD	DI,CX
		ROR	CX,1			; Rotate
		MOV	AL,20H			; ' '
		ADD	AL,CS:[DI]
		MOV	AH,[SI]
		CALL	ADL_OUT
		MOV	AL,20H			; ' '
		ADD	AL,CS:[DI+1]
		MOV	AH,[SI+1]
		CALL	ADL_OUT
		MOV	AL,60H			; '`'
		ADD	AL,CS:[DI]
		MOV	AH,[SI+4]
		CALL	ADL_OUT
		MOV	AL,60H			; '`'
		ADD	AL,CS:[DI+1]
		MOV	AH,[SI+5]
		CALL	ADL_OUT
		MOV	AL,80H
		ADD	AL,CS:[DI]
		MOV	AH,[SI+6]
		CALL	ADL_OUT
		MOV	AL,80H
		ADD	AL,CS:[DI+1]
		MOV	AH,[SI+7]
		CALL	ADL_OUT
		MOV	AL,0E0H
		ADD	AL,CS:[DI]
		MOV	AH,[SI+9]
		CALL	ADL_OUT
		MOV	AL,0E0H
		ADD	AL,CS:[DI+1]
		MOV	AH,[SI+0AH]
		CALL	ADL_OUT
		MOV	AL,40H			; '@'
		ADD	AL,CS:[DI]
		MOV	AH,[SI+2]
		CALL	ADL_OUT
		MOV	AL,40H			; '@'
		ADD	AL,CS:[DI+1]
		MOV	AH,[SI+3]
		CALL	ADL_OUT
		MOV	DI,OFFSET DATA_28
		ADD	DI,CX
		MOV	AL,[SI+2]
		MOV	CS:[DI],AL
		MOV	BYTE PTR CS:[DI+12H],1
		MOV	AL,[SI+3]
		MOV	CS:[DI+9],AL
		MOV	BYTE PTR CS:[DI+1BH],1
		MOV	AL,[SI+0BH]
		AND	AL,0F0H
		SHR	AL,4			; Shift w/zeros fill
		MOV	DI,OFFSET DATA_39
		ADD	DI,CX
		MOV	CS:[DI],AL
LOC_46:
		POPA				; Restore all regs
		RETN
INSTR_CHANGE	ENDP


;
;  SUBROUTINE - Note Play
;                              ah=csatorna, al=hang (01..)
;

NOTE_Play	PROC	NEAR
		PUSHA				; Save all regs
		CMP	AL,7FH
		JE	LOC_47			; Jump if equal
		XOR	CX,CX			; Zero register
		MOV	CL,AH
		MOV	DI,CX
		MOV	CL,1
		MOV	CS:DATA_44[DI],AL
		MOV	CS:DATA_45[DI],CL
		DEC	AL
		MOV	CS:DATA_35,AL
		XOR	CX,CX			; Zero register
		MOV	CL,AH
		MOV	DI,969H
		ROL	CX,1			; Rotate
		ADD	DI,CX
		ROR	CX,1			; Rotate
		MOV	AL,0B0H
		ADD	AL,CL
		XOR	AH,AH			; Zero register
		CALL	ADL_OUT
		MOV	BX,OFFSET DATA_27
		ROL	CX,1			; Rotate
		MOV	DI,CX
		ROR	CX,1			; Rotate
		ADD	DI,BX
		MOV	SI,OFFSET DATA_21
		XOR	BX,BX			; Zero register
		MOV	BL,CS:DATA_35
		ROL	BX,1			; Rotate
		MOV	AX,CS:[BX+SI]
		MOV	CS:[DI],AX
		MOV	WORD PTR CS:[DI+12H],1
		POPA				; Restore all regs
		RETN
LOC_47:
		MOV	AL,AH
		XOR	AH,AH			; Zero register
		MOV	BX,OFFSET DATA_27
		ROL	AX,1			; Rotate
		MOV	DI,AX
		ADD	DI,BX
		MOV	AX,CS:[DI]
		AND	AH,0DFH
		MOV	CS:[DI],AX
		MOV	WORD PTR CS:[DI+12H],1
		POPA				; Restore all regs
		RETN
NOTE_Play	ENDP


;
;                              SUBROUTINE
;

SUB_9		PROC	NEAR
		PUSHA				; Save all regs
		MOV	CX,9
		MOV	DI,8
LOC_48:
		MOV	BYTE PTR CS:DATA_48[DI],0
		CMP	BYTE PTR CS:DATA_45[DI],0
		JE	LOC_50			; Jump if equal
		MOV	AL,80H
		MOV	AH,CS:DATA_28[DI]
		AND	AH,3FH			; '?'
		SUB	AL,AH
		MOV	AH,CS:DATA_30[DI]
		AND	AH,3FH			; '?'
		SUB	AL,AH
		SHR	AL,3			; Shift w/zeros fill
		CMP	AL,0FH
		JBE	LOC_49			; Jump if below or =
		MOV	AL,0FH
LOC_49:
		INC	AL
		MOV	CS:DATA_47[DI],AL
		MOV	BYTE PTR CS:DATA_45[DI],0
		MOV	BYTE PTR CS:DATA_48[DI],0FFH
LOC_50:
		CMP	BYTE PTR CS:DATA_47[DI],0FFH
		JE	LOC_51			; Jump if equal
		DEC	CS:DATA_47[DI]
LOC_51:
		DEC	DI
		LOOP	LOCLOOP_52		; Loop if cx > 0

		POPA				; Restore all regs
		RETN

LOCLOOP_52:
		JMP	SHORT LOC_48
SUB_9		ENDP


;
;                              SUBROUTINE
;

SUB_10		PROC	NEAR
		PUSHA				; Save all regs
		MOV	CX,9

LOCLOOP_53:
		DEC	CX
		CALL	SUB_11
		INC	CX
		LOOP	LOCLOOP_53		; Loop if cx > 0

		POPA				; Restore all regs
		RETN
SUB_10		ENDP


;
;              SUBROUTINE - vmi hang kirako...
;                           CX = 9-csatorna (?)  (0..8)
;

SUB_11		PROC	NEAR
		MOV	BX,OFFSET DATA_27
		ROL	CX,1   			; CX*2
		MOV	SI,CX  			; SI <- 0..16
		ROR	CX,1   			; CX/2 - back
		MOV	DI,OFFSET DATA_39  ; (9 bytes)
		ADD	DI,CX              ; now curr. in 9 bytes
		CMP	BYTE PTR CS:[DI],0  ; some state if channel note
		JNE	LOC_54		    ; if ! 0 jump
		CMP	WORD PTR CS:[BX+SI+12H],0
		JE	LOC_55			; Jump if equal
LOC_54:
		MOV	WORD PTR CS:[BX+SI+12H],0
		MOV	AL,0A0H
		ADD	AL,CL
		MOV	AH,CS:[BX+SI]
		ADD	AH,CS:[DI]
		CALL	ADL_OUT
		MOV	AL,0B0H
		ADD	AL,CL
		MOV	AH,CS:[BX+SI+1]
		CALL	ADL_OUT
LOC_55:
		MOV	DI,OFFSET DATA_22
		ROL	CX,1		   ; Rotate
		ADD	DI,CX              ; DI <- 0..16
		ROR	CX,1		   ; Rotate
		MOV	SI,OFFSET DATA_28
		ADD	SI,CX
		CMP	BYTE PTR CS:[SI+12H],0
		JE	LOC_56			; Jump if equal
		MOV	BYTE PTR CS:[SI+12H],0
		MOV	AL,40H			; '@'
		ADD	AL,CS:[DI]
		MOV	DX,AX
		MOV	AL,3FH			; '?'
		SUB	AL,CS:[SI]
		PUSH	DX
		MOV	DH,AL
		AND	DH,0C0H
		AND	AX,3FH
		PUSH	DX
		MOV	BL,3FH			; '?'
		SUB	BL,CS:DATA_38
		XOR	BH,BH			; Zero register
		MUL	BX			; dx:ax = reg * ax
		MOV	BX,3FH
		DIV	BX			; ax,dx rem=dx:ax/reg
		POP	DX
		MOV	DL,AL
		MOV	AL,3FH			; '?'
		SUB	AL,DL
		AND	AL,3FH			; '?'
		OR	AL,DH
		POP	DX
		MOV	AH,AL
		MOV	AL,DL
		CALL	ADL_OUT
LOC_56:
		CMP	BYTE PTR CS:[SI+1BH],0
		JE	LOC_RET_59		; Jump if equal
		MOV	BYTE PTR CS:[SI+1BH],0
		MOV	AL,40H			; '@'
		ADD	AL,CS:[DI+1]
		MOV	DX,AX
		MOV	AL,CS:[SI+9]
		PUSH	DI
		PUSH	AX
		PUSH	DX
		PUSH	BX
		MOV	DI,OFFSET DATA_46
		MOV	BX,CX
		MOV	AL,CS:[BX+DI]
		XOR	AH,AH			; Zero register
		MOV	BX,0CH
		MUL	BX			; dx:ax = reg * ax
		MOV	DI,CS:MusicInstr
		ADD	DI,AX
		TEST	BYTE PTR [DI+8],1
		JNZ	LOC_57			; Jump if not zero
		POP	BX
		POP	DX
		POP	AX
		POP	DI
		JMP	SHORT LOC_58
LOC_57:
		POP	BX
		POP	DX
		POP	AX
		POP	DI
		MOV	AL,3FH			; '?'
		SUB	AL,CS:[SI+9]
		PUSH	DX
		MOV	DH,AL
		AND	DH,0C0H
		AND	AX,3FH
		PUSH	DX
		MOV	BL,3FH			; '?'
		SUB	BL,CS:DATA_38
		XOR	BH,BH			; Zero register
		MUL	BX			; dx:ax = reg * ax
		MOV	BX,3FH
		DIV	BX			; ax,dx rem=dx:ax/reg
		POP	DX
		MOV	DL,AL
		MOV	AL,3FH			; '?'
		SUB	AL,DL
		AND	AL,3FH			; '?'
		OR	AL,DH
		POP	DX
LOC_58:
		MOV	AH,AL
		MOV	AL,DL
		CALL	ADL_OUT

LOC_RET_59:
		RETN
SUB_11		ENDP


;
;     SUBROUTINE - Card Detect
;  Returns address in AX (ex.:0388h), FFFF-error
;

CardDetect	PROC	NEAR
		PUSH	BX
		PUSH	DX
		MOV	BX,OFFSET CARD_Addrlist
LOC_60:
		MOV	DX,CS:[BX]
		MOV	CS:CardAddr,DX
		INC	DX
		MOV	CS:CardStat,DX
		MOV	DX,3DAH
LOC_61:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JNZ	LOC_61			; Jump if not zero
		MOV	DX,3DAH
LOC_62:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JZ	LOC_62			; Jump if zero
		MOV	DX,3DAH
LOC_63:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JZ	LOC_63			; Jump if zero
		MOV	DX,3DAH
LOC_64:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JNZ	LOC_64			; Jump if not zero
		MOV	AL,4
		MOV	AH,60H			; '`'
		CALL	ADL_OUT
		MOV	AL,4
		MOV	AH,80H
		CALL	ADL_OUT
		MOV	DX,CS:CardAddr
		IN	AL,DX			; port 388H, comm 8273 status
		AND	AL,0E0H
		MOV	CS:DATA_25,AL
		MOV	AL,2
		MOV	AH,0FFH
		CALL	ADL_OUT
		MOV	AL,4
		MOV	AH,21H			; '!'
		CALL	ADL_OUT
		MOV	DX,3DAH
LOC_65:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JNZ	LOC_65			; Jump if not zero
		MOV	DX,3DAH
LOC_66:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JZ	LOC_66			; Jump if zero
		MOV	DX,3DAH
LOC_67:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JZ	LOC_67			; Jump if zero
		MOV	DX,3DAH
LOC_68:
		IN	AL,DX			; port 3DAH, CGA/EGA vid status
		TEST	AL,8
		JNZ	LOC_68			; Jump if not zero
		MOV	DX,CS:CardAddr
		IN	AL,DX			; port 388H, comm 8273 status
		AND	AL,0E0H
		MOV	CS:DATA_26,AL
		MOV	AL,4
		MOV	AH,60H			; '`'
		CALL	ADL_OUT
		MOV	AL,4
		MOV	AH,80H
		CALL	ADL_OUT
		CMP	BYTE PTR CS:DATA_25,0
		JNE	HSCStop0			; Jump if not equal
		CMP	BYTE PTR CS:DATA_26,0C0H
		JNE	HSCStop0			; Jump if not equal
		MOV	AX,CS:CardAddr
LOC_69:
		POP	BX
		POP	DX
		RETN
HSCStop0:
		ADD	BX,2
		MOV	DX,CS:[BX]
		CMP	DX,0FFFFH
		JE	HSCStop1			; Jump if equal
		JMP	LOC_60
HSCStop1:
		MOV	AX,0FFFFH
		JMP	SHORT LOC_69
CardDetect		ENDP


;
;    SUBROUTINE - Adl_Out
;
;      outputs AL,AH to card at address CardAddr
;
;

ADL_OUT		PROC	NEAR
		MOV	DX,CS:CardAddr
		OUT	DX,AL
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		INC	DX
		MOV	AL,AH
		OUT	DX,AL
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		IN	AL,DX
		RETN
ADL_OUT		ENDP

; (:0893h poz-on van...)
USERINTR	DW	0,0 ;OFFSET SUB_14, SEG SUB_14
DATA_14		DB	0
DATA_15		DB	0
DATA_16		DB	0
RASTER_State	DB	0
DATA_18		DB	0
DATA_19		DB	0
CARD_Addrlist	DW	0388h,0388h,0388h,0FFFFH ; card addresses
DATA_21		DB	0
		DB	 00H, 6BH, 21H, 81H, 21H, 98H
		DB	 21H,0B0H, 21H,0CAH, 21H,0E5H
		DB	 21H, 02H, 22H, 20H, 22H, 41H
		DB	 22H, 63H, 22H, 87H, 22H,0AEH
		DB	 22H, 6BH, 25H, 81H, 25H, 98H
		DB	 25H,0B0H, 25H,0CAH, 25H,0E5H
		DB	 25H, 02H, 26H, 20H, 26H, 41H
		DB	 26H, 63H, 26H, 87H, 26H,0AEH
		DB	 26H, 6BH, 29H, 81H, 29H, 98H
		DB	 29H,0B0H, 29H,0CAH, 29H,0E5H
		DB	 29H, 02H, 2AH, 20H, 2AH, 41H
		DB	 2AH, 63H, 2AH, 87H, 2AH,0AEH
		DB	 2AH, 6BH, 2DH, 81H, 2DH, 98H
		DB	 2DH,0B0H, 2DH,0CAH, 2DH,0E5H
		DB	 2DH, 02H, 2EH, 20H, 2EH, 41H
		DB	 2EH, 63H, 2EH, 87H, 2EH,0AEH
		DB	 2EH, 6BH, 31H, 81H, 31H, 98H
		DB	 31H,0B0H, 31H,0CAH, 31H,0E5H
		DB	 31H, 02H, 32H, 20H, 32H, 41H
		DB	 32H, 63H, 32H, 87H, 32H,0AEH
		DB	 32H, 6BH, 35H, 81H, 35H, 98H
		DB	 35H,0B0H, 35H,0CAH, 35H,0E5H
		DB	 35H, 02H, 36H, 20H, 36H, 41H
		DB	 36H, 63H, 36H, 87H, 36H,0AEH
		DB	 36H, 6BH, 39H, 81H, 39H, 98H
		DB	 39H,0B0H, 39H,0CAH, 39H,0E5H
		DB	 39H, 02H, 3AH, 20H, 3AH, 41H
		DB	 3AH, 63H, 3AH, 87H, 3AH,0AEH
		DB	 3AH, 6BH, 3DH, 81H, 3DH, 98H
		DB	 3DH,0B0H, 3DH,0CAH, 3DH,0E5H
		DB	 3DH, 02H, 3EH, 20H, 3EH, 41H
		DB	 3EH, 63H, 3EH, 87H, 3EH,0AEH
		DB	3EH
DATA_22		DB	3
		DB	 00H, 04H, 01H, 05H, 02H, 0BH
		DB	 08H, 0CH, 09H, 0DH, 0AH, 13H
		DB	 10H, 14H, 11H, 15H, 12H
CardAddr	DW	?
CardStat	DW	?
DATA_25		DB	0
DATA_26		DB	0
DATA_27		DW	9 DUP (0)
DATA_27_PL12h	DB	1, 0, 1, 0, 1, 0    ; data_27 plus 12h
		DB	1, 0, 1, 0, 1, 0
		DB	1, 0, 1, 0, 1, 0
DATA_28		DB	9 DUP (0)
DATA_30		DB	9 DUP (0)
DATA_31		DW	9 DUP (101H)
OLDINT1C	DD	0 ; old int 1C vect.
DATA_34		DB	0
DATA_35		DB	0
DATA_36		DB	0
DATA_37		DB	0
DATA_38		DB	0
DATA_39		DB	9 DUP (0)
MusicSeg	DW	?
MusicInstr	DW	?
MusicOrder	DW	?
MusicPatterns 	DW	?
DATA_44		DB	9 DUP (0)
DATA_45		DB	9 DUP (0)
DATA_46		DB	9 DUP (0FFh)        ;DW	4 DUP (0FFFFH)
DATA_47		DB	9 DUP (0FFH)
DATA_48		DB	9 DUP (0)
M_ORDPOS	DB	0
M_CURRPATT	DB	0
M_SORPOS	DB	0
		DB	0DH, 0AH
		DB      '*** HSC-Player 1.1 (c) by Neo Software Design/'
		DB	'ripp and speed up by Chicken/ECR ***', 0DH
		DB	0AH
		DB	0, 0, 0, 0, 0, 0

SEG_A		ENDS



		END	START
