#include <process.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <alloc.h>
#include <dos.h>
#include <conio.h>
#include <string.h>

extern pascal char far HSCPLAYER;
extern pascal char HSC_NOTE[9];
extern pascal char HSC_POSITION;

void HSC_startup( void );

#define PLAY_BACKGROUND 0
#define PLAY_POLL       1
char play_def = PLAY_BACKGROUND;

#define INCLUDE_IRQ     0
#define CUTOFF_IRQ      1
char irq_def = CUTOFF_IRQ;

int AdLib_act = 0;

int HSC_playing = 0;

char far *HSC_driver_mem = NULL;
void far (*HSC_driver)(void) = NULL;

#pragma startup HSC_startup

int HSC_reset( void ); // 1-Ok, 0-Error
void HSC_startmusic( char far *music );
void HSC_stopmusic( void );
void HSC_fadeoutmusic( void );
void HSC_pollmusic( void );


int HSC_reset( void ) // 1-Ok, 0-Error
{
 HSC_driver_mem = &HSCPLAYER;
 HSC_driver = (void (far*)())HSC_driver_mem;

 _AH=4;
 (*HSC_driver)();
 asm JC nemjo;
 AdLib_act=1;
 return 1;

nemjo:
 return(0);
}

void HSC_startmusic( char far *music )
{
 if (!AdLib_act) return;

 _ES=FP_SEG(music);
 _SI=FP_OFF(music);
 _BL=play_def;
 _BH=irq_def;
 _AH=0;
 (*HSC_driver)();

 HSC_playing=1;
}

void HSC_stopmusic( void )
{
 if (!AdLib_act) return;

 _AH=2;
 (*HSC_driver)();
 HSC_playing=0;
}

void HSC_fadeoutmusic( void )
{
 if (!AdLib_act) return;

 _AH=3;
 (*HSC_driver)();
}

void HSC_pollmusic( void )
{
 if (!AdLib_act) return;

 _AH=1;
 (*HSC_driver)();
}

char crmsg[]={"Portions (C) 1993 by NOSASOFT"};
int csum=0x7091;

void HSC_startup( void )
{
 int c,d,f=0;

 //asm int 3

 d=strlen(crmsg);
 for (c=0 ; c<d ; c++)
  f+=crmsg[c]*c;

 if (f!=csum)
  {
   printf("HSC: -Ne basztass!\r\n");
   exit(1);
  }
}