#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <dos.h>

const int D  = 300;
const int KX = 640;
const int KY = 480;

class Test
    {
      public:
	Test();
	~Test() { };
	void Nagyit(float a, float b);
	void ForgatX(float a);
	void ForgatY(float a);
	void ForgatZ(float a);
	void Eltol(float x, float y);

	void Meginicializalom_a_grafikamat();
	void BClr();
	void Draw();
	void Draws();

	void save();
        void load();

      protected:
	float x[8],y[8],z[8];
	int h[8];
	float sx[8],sy[8],sz[8];
	int sh[8];
    };


void Test::BClr()
{
  char c;
  while(kbhit()) c=getch();
}


void Test::Meginicializalom_a_grafikamat()
{
  int i=DETECT,j;

  initgraph(&i,&j,"");
  int errorcode = graphresult();

  if (errorcode != grOk)
  {
     printf("Graphics error: %s\n", grapherrormsg(errorcode));
     exit(1);
  }

  outtextxy(150,170,"Video Card detected and put into Graphics Mode");
  delay(1500);
  cleardevice();
  line(0,getmaxy() / 2,getmaxx(),getmaxy() / 2);
  line(getmaxx() / 2,0,getmaxx() / 2,getmaxy());
}

Test::Test()
{
  x[0]=2; y[0]=-2;
  z[0]=-2; h[0]=2;

  x[1]=2; y[1]=-2;
  z[1]=2; h[1]=2;

  x[2]=-2; y[2]=-2;
  z[2]=2; h[2]=2;

  x[3]=-2; y[3]=-2;
  z[3]=-2; h[3]=2;

  x[4]=2; y[4]=2;
  z[4]=-2; h[4]=2;

  x[5]=2; y[5]=2;
  z[5]=2; h[5]=2;

  x[6]=-2; y[6]=2;
  z[6]=2; h[6]=2;

  x[7]=-2; y[7]=2;
  z[7]=-2; h[7]=2;
}

void Test::Eltol(float xx, float yy)
{
  for (char b=0; b < 8; b++)
  {
    x[b]=x[b]+xx;
    y[b]=y[b]+yy;
    h[b]=1;
  }
}

void Test::Nagyit(float a, float b)
{
  for (char d=0; d < 8; d++)
  {
    x[d]=x[d]*a;
    y[d]=y[d]*b;
    h[d]=1;
  }
}

void Test::ForgatX(float a)
{
  for (char d=0; d < 8; d++)
  {
    y[d]=y[d] * cos(a) + z[d] * -sin(a);
    z[d]=y[d] * sin(a) + z[d] * cos(a);
    h[d]=1;
  }
}


void Test::ForgatY(float a)
{
  for (char b=0; b < 8; b++)
  {
    x[b]=x[b] * cos(a) + z[b] * -sin(a);
    z[b]=x[b] * sin(a) + z[b] * cos(a);
    h[b]=1;
  }
}

void Test::ForgatZ(float a)
{
  for (char b=0; b < 8; b++)
  {
    x[b]=x[b] * cos(a) + y[b] * -sin(a);
    y[b]=x[b] * sin(a) + y[b] * cos(a);
    h[b]=1;
  }
}

void Test::Draw()
{
  line(D * x[0] / (z[0] + 10) + KX / 2, KY / 2 - D * y[0] / (z[0] + 10),
       D * x[1] / (z[1] + 10) + KX / 2, KY / 2 - D * y[1] / (z[1] + 10));

  line(D * x[0] / (z[0] + 10) + KX / 2, KY / 2 - D * y[0] / (z[0] + 10),
       D * x[3] / (z[3] + 10) + KX / 2, KY / 2 - D * y[3] / (z[3] + 10));

  line(D * x[0] / (z[0] + 10) + KX / 2, KY / 2 - D * y[0] / (z[0] + 10),
       D * x[4] / (z[4] + 10) + KX / 2, KY / 2 - D * y[4] / (z[4] + 10));


  line(D * x[5] / (z[5] + 10) + KX / 2, KY / 2 - D * y[5] / (z[5] + 10),
       D * x[1] / (z[1] + 10) + KX / 2, KY / 2 - D * y[1] / (z[1] + 10));

  line(D * x[5] / (z[5] + 10) + KX / 2, KY / 2 - D * y[5] / (z[5] + 10),
       D * x[4] / (z[4] + 10) + KX / 2, KY / 2 - D * y[4] / (z[4] + 10));

  line(D * x[5] / (z[5] + 10) + KX / 2, KY / 2 - D * y[5] / (z[5] + 10),
       D * x[6] / (z[6] + 10) + KX / 2, KY / 2 - D * y[6] / (z[6] + 10));


  line(D * x[2] / (z[2] + 10) + KX / 2, KY / 2 - D * y[2] / (z[2] + 10),
       D * x[1] / (z[1] + 10) + KX / 2, KY / 2 - D * y[1] / (z[1] + 10));

  line(D * x[2] / (z[2] + 10) + KX / 2, KY / 2 - D * y[2] / (z[2] + 10),
       D * x[3] / (z[3] + 10) + KX / 2, KY / 2 - D * y[3] / (z[3] + 10));

  line(D * x[2] / (z[2] + 10) + KX / 2, KY / 2 - D * y[2] / (z[2] + 10),
       D * x[6] / (z[6] + 10) + KX / 2, KY / 2 - D * y[6] / (z[6] + 10));


  line(D * x[7] / (z[7] + 10) + KX / 2, KY / 2 - D * y[7] / (z[7] + 10),
       D * x[4] / (z[4] + 10) + KX / 2, KY / 2 - D * y[4] / (z[4] + 10));

  line(D * x[7] / (z[7] + 10) + KX / 2, KY / 2 - D * y[7] / (z[7] + 10),
       D * x[3] / (z[3] + 10) + KX / 2, KY / 2 - D * y[3] / (z[3] + 10));

  line(D * x[7] / (z[7] + 10) + KX / 2, KY / 2 - D * y[7] / (z[7] + 10),
       D * x[6] / (z[6] + 10) + KX / 2, KY / 2 - D * y[6] / (z[6] + 10));
}

void Test::Draws()
{
  line(D * sx[0] / (sz[0] + 10) + KX / 2, KY / 2 - D * sy[0] / (sz[0] + 10),
       D * sx[1] / (sz[1] + 10) + KX / 2, KY / 2 - D * sy[1] / (sz[1] + 10));

  line(D * sx[0] / (sz[0] + 10) + KX / 2, KY / 2 - D * sy[0] / (sz[0] + 10),
       D * sx[3] / (sz[3] + 10) + KX / 2, KY / 2 - D * sy[3] / (sz[3] + 10));

  line(D * sx[0] / (sz[0] + 10) + KX / 2, KY / 2 - D * sy[0] / (sz[0] + 10),
       D * sx[4] / (sz[4] + 10) + KX / 2, KY / 2 - D * sy[4] / (sz[4] + 10));


  line(D * sx[5] / (sz[5] + 10) + KX / 2, KY / 2 - D * sy[5] / (sz[5] + 10),
       D * sx[1] / (sz[1] + 10) + KX / 2, KY / 2 - D * sy[1] / (sz[1] + 10));

  line(D * sx[5] / (sz[5] + 10) + KX / 2, KY / 2 - D * sy[5] / (sz[5] + 10),
       D * sx[4] / (sz[4] + 10) + KX / 2, KY / 2 - D * sy[4] / (sz[4] + 10));

  line(D * sx[5] / (sz[5] + 10) + KX / 2, KY / 2 - D * sy[5] / (sz[5] + 10),
       D * sx[6] / (sz[6] + 10) + KX / 2, KY / 2 - D * sy[6] / (sz[6] + 10));


  line(D * sx[2] / (sz[2] + 10) + KX / 2, KY / 2 - D * sy[2] / (sz[2] + 10),
       D * sx[1] / (sz[1] + 10) + KX / 2, KY / 2 - D * sy[1] / (sz[1] + 10));

  line(D * sx[2] / (sz[2] + 10) + KX / 2, KY / 2 - D * sy[2] / (sz[2] + 10),
       D * sx[3] / (sz[3] + 10) + KX / 2, KY / 2 - D * sy[3] / (sz[3] + 10));

  line(D * sx[2] / (sz[2] + 10) + KX / 2, KY / 2 - D * sy[2] / (sz[2] + 10),
       D * sx[6] / (sz[6] + 10) + KX / 2, KY / 2 - D * sy[6] / (sz[6] + 10));


  line(D * sx[7] / (sz[7] + 10) + KX / 2, KY / 2 - D * sy[7] / (sz[7] + 10),
       D * sx[4] / (sz[4] + 10) + KX / 2, KY / 2 - D * sy[4] / (sz[4] + 10));

  line(D * sx[7] / (sz[7] + 10) + KX / 2, KY / 2 - D * sy[7] / (sz[7] + 10),
       D * sx[3] / (sz[3] + 10) + KX / 2, KY / 2 - D * sy[3] / (sz[3] + 10));

  line(D * sx[7] / (sz[7] + 10) + KX / 2, KY / 2 - D * sy[7] / (sz[7] + 10),
       D * sx[6] / (sz[6] + 10) + KX / 2, KY / 2 - D * sy[6] / (sz[6] + 10));
}

void Test::save()
{
  for(char b=0; b < 8; sx[b]=x[b],sy[b]=y[b],sz[b]=z[b],sh[b++]=1);
}

void Test::load()
{
  for(char b=0; b < 8; x[b]=sx[b],y[b]=sy[b],z[b]=sz[b],h[b++]=1);
}

