Unit Matrix;

Interface
 Type
   HPont = record
     x,y : Integer;
     h   : Word;
   end;

   HSzog = Array[1..3] of HPont;

 Const
   XMirr : Array[1..3,1..3] of Integer = ((1,0,0),(0,-1,0),(0,0,1));
   YMirr : Array[1..3,1..3] of Integer = ((-1,0,0),(0,1,0),(0,0,1));
   OMirr : Array[1..3,1..3] of Integer = ((-1,0,0),(0,-1,0),(0,0,1));

 Procedure Eltol(Pont : HPont; Var Eltol : HPont; x,y : integer);
 Procedure Nagyit(Pont : HPont; Var Nagyit : HPont; a,b : Real);
 Procedure Forgat(Pont : HPont; Var Forgat : HPont; a : Real);
 Procedure XTukor(Pont :HPont; Var XT : HPont);
 Procedure YTukor(Pont :HPont; Var XT : HPont);
 Procedure OTukor(Pont :HPont; Var XT : HPont);
 Procedure Meginicializalom_a_grafikamat;


Implementation

 Uses Graph, Crt;

 Procedure Meginicializalom_a_grafikamat;

 Var
  i,j : Integer;

 Begin
  i:=detect;
  initgraph(i,j,'D:\TP\BGI');
  OutTextXY(150,170,'Video Card detected and put into Graphics Mode');
  Delay(1500);
  cleardevice;
  Line(0,getmaxy div 2,getmaxx,getmaxy div 2);
  Line(getmaxx div 2,0,getmaxx div 2,getmaxy);
 End;


 Procedure Eltol(Pont : HPont; Var Eltol : HPont; x,y : integer);

 Begin
  Eltol.x:=Pont.x+x;
  Eltol.y:=Pont.y+y;
  Eltol.h:=1;
 End;

 Procedure Nagyit(Pont : HPont; Var Nagyit : HPont; a,b : Real);

 Begin
  Nagyit.x:=Round(Pont.x*a);
  Nagyit.y:=Round(Pont.y*b);
  Nagyit.h:=1;
 End;

 Procedure Forgat(Pont : HPont; Var Forgat : HPont; a : Real);

 Begin
  Forgat.x:=Round(Pont.x*Cos(a))+Round(Pont.y*-Sin(a));
  Forgat.y:=Round(Pont.x*Sin(a))+Round(Pont.y*Cos(a));
  Forgat.h:=1;
 End;

 Procedure XTukor(Pont :HPont; Var XT : HPont);

 Begin
  XT.x:=Pont.x*XMirr[1,1]+Pont.y*XMirr[1,2];
  XT.y:=Pont.x*XMirr[2,1]+Pont.y*XMirr[2,2];
  XT.h:=1;
 End;

 Procedure YTukor(Pont :HPont; Var XT : HPont);

 Begin
  XT.x:=Pont.x*YMirr[1,1]+Pont.y*YMirr[1,2];
  XT.y:=Pont.x*YMirr[2,1]+Pont.y*YMirr[2,2];
  XT.h:=1;
 End;

 Procedure OTukor(Pont :HPont; Var XT : HPont);

 Begin
  XT.x:=Pont.x*OMirr[1,1]+Pont.y*OMirr[1,2];
  XT.y:=Pont.x*OMirr[2,1]+Pont.y*OMirr[2,2];
  XT.h:=1;
 End;

End.
