#include <mem.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>

#include "..\gus\forte.h"
#include "..\gus\gf1proto.h"
#include "..\gus\extern.h"
#include "..\gus\ultraerr.h"
#include "..\gus\utility.h"

#include "..\SB\sbdriver.h"
#include "..\SB\SB.h"

#include "..\gendig\gendig.h"

#define TVOCNUM 128

l_voc l_vocs[TVOCNUM];
int vocn; // number of CURR voc-s
dig_devs cur_device=DIG_NONE;

/* GUS vars */
ULTRA_CFG config;

/* SB vars */
unsigned SbIOaddr;
unsigned SbIRQ;
unsigned SbDMAchan;
int	SbType;
unsigned int SB_status; // volatile is kellene!!

int Sb_Get_Params( void );

/*---------------------------------------------------------*/

int dig_init( dig_devs device )
{
 int c;
 memset(l_vocs,0,sizeof(l_voc)*TVOCNUM);

 if (device==DIG_GUS)
  {
   /* Get the ULTRASND environment string parameters */
   UltraGetCfg(&config);

   if (UltraProbe(config.base_port) == NO_ULTRA)
    {
     cur_device=DIG_NONE;
     return -1;
    }

   if (UltraOpen(&config,14) == NO_ULTRA)
    {
     cur_device=DIG_GUS;
     return -1;
    }

   UltraEnableOutput();

   cur_device=DIG_GUS;
   return 0; // OK
  }

 if (device==DIG_SB)
  {
   Sb_Get_Params();
   LoadDriver(0);

   SetIOAddr(SbIOaddr);
   SetIRQ(SbIRQ);

   InitialiseDriver();

   SetStatusWord(&SB_status);

   SpeakerOnOff(1);

   //if (SB_present)
   SetStatusWord(&SB_status);

   cur_device=DIG_SB;
   return 0; // OK
  }

 return 0;
}

int dig_close( void )
{
 if (cur_device==DIG_GUS)
  {
   /* Shut sound down & re-init hardware ... */
   UltraClose();

   cur_device=DIG_NONE;
   return 0;
  }

  if (cur_device==DIG_SB)
  {
   SpeakerOnOff(0);
   UninstallDriver();

   cur_device=DIG_NONE;
   return 0;
  }

 return 0;
}

int dig_loadvoc( int num, char *fname )
{
 FILE *f;
 char far *buf;
 char buf2[10];
 long length;
 unsigned xx;
 unsigned long len;
 unsigned long vlen;

 f = fopen(fname,"rb");
 if(!f)
  return -1;

 if (cur_device==DIG_NONE)
  {
   fclose(f);
   return 0;
  }

 length = filelength(fileno(f)) - 0x1a;

 len = length;
 buf = (char far *)farmalloc(/*(int)*/len);
 if (!buf)
  return -1;

 fseek(f,0x1a,SEEK_SET);
// _dos_read(fileno(f),buf2,3,&xx);
 _dos_read(fileno(f),buf,length,&xx);
 fclose(f);

 //xx=buf[1];
 //vlen=xx;
 //vlen+=buf[2]*256;
 //vlen+=buf[3]*65536;
 vlen=0;
 _fmemcpy(&vlen,&buf[1],3);

 l_vocs[num].van=1;
 l_vocs[num].mem=buf;

 if (cur_device==DIG_SB)
  {
   return 0;
  }

 if (cur_device==DIG_GUS)
  {
   int voice;
   unsigned long mpos;

   if (UltraAllocVoice(-1,&voice) != ULTRA_OK)
    {
     farfree(buf);
     return -1; //!!!! elfogyott a voices
    }

   if (UltraMemAlloc(vlen,&mpos) != ULTRA_OK)
    {
     farfree(buf);
     return -1;
    }

   l_vocs[num].gmem=mpos;

   UltraDownload(&buf[6],0|128,mpos,vlen-6,TRUE);
   UltraSetBalance(voice,7); // set pan to middle
   UltraSetFrequency(voice,REALRATE(buf[4]));
   l_vocs[num].res1=UltraPrimeVoice(voice,mpos,mpos,mpos+vlen,0);

   l_vocs[num].van=voice+1;

   farfree(buf);
   return 0;
  }



 return 0;
}

int dig_vocbalance( int num, int bal )
{
 if (!l_vocs[num].van)
  return -1;

 int rbal;
 if (cur_device==DIG_GUS)
  {
   rbal=(bal+255)/34;
   UltraSetBalance(l_vocs[num].van-1,rbal);
   return 0;
  }

 return 0;
}

//------------------------------------------------------//

int dig_playvoc( int num )
{
 if (!l_vocs[num].van)
  return -1;

 if (cur_device==DIG_GUS)
  {
   UltraSetVoice(l_vocs[num].van-1,l_vocs[num].gmem);
   UltraSetVolume(l_vocs[num].van-1,4095);
   UltraGoVoice(l_vocs[num].van-1,l_vocs[num].res1);
   return 0;
  }

 if (cur_device==DIG_SB)
  {
   if (SB_status) StopVoiceProcess();
   farOutputVoice(l_vocs[num].mem);
   return 0;
  }

 return 0;
}

//------------------------------------------------------//

int dig_unloadvoc( int num )
{
 if (!l_vocs[num].van)
  return -1;

 if (cur_device==DIG_GUS)
  {
   long len;
   //UltraSetVoice(l_vocs[num].van-1,l_vocs[num].gmem);
   //UltraSetVolume(l_vocs[num].van-1,4095);
   //UltraGoVoice(l_vocs[num].van-1,l_vocs[num].res1);

   // need 2 unload!!
   memcpy(&len,&l_vocs[num].mem,2);
   UltraMemFree(len,l_vocs[num].gmem);

   memset(&l_vocs[num],0,sizeof(l_voc));
   return 0;
  }

 if (cur_device==DIG_SB)
  {
   farfree(l_vocs[num].mem);
   memset(&l_vocs[num],0,sizeof(l_voc));
   return 0;
  }

 return 0;
}

//------------------------------------------------------//


int dig_stopall( void )
{
 //if (!l_vocs[num].van)
 // return -1;

 if (cur_device==DIG_GUS) // not yet impl'd
  {
   int c;
   for (c=0;c<14;c++)
    UltraStopVoice(c);

   return 0;
  }

 if (cur_device==DIG_SB)
  {
   if (SB_status) StopVoiceProcess();
   return 0;
  }

 return 0;
}

clock_t s_st;

void sync_start( void )
{
 s_st=clock();
}

int sync_wait( int ticks, int esc_key )
{
 clock_t s_c;

 s_c=clock();
 if ( (s_c-s_st)>=ticks )
  return 0;

 do
  {
   s_c=clock();
   if (esc_key)
    if (kbhit())
     return(1);
  }
 while ( (s_c-s_st)<ticks );

 return 0;
}
