#include <conio.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <alloc.h>
#include <mem.h>
#include <stdlib.h>
#include <io.h>
#include <dos.h>
#include <fcntl.h>
#include <sys\stat.h>

#include "..\screen.h"
#include "..\utils\swdes.h"
#include "..\comm\crc.h"

// 5700 bytes might not be enough: text+\r\n\r\n...\r\n -> text+2*100 !!!

extern char DIARYSCR;
extern char DIARYHLP;
extern char DIARYINTRO;
int ndx,mf;

struct s_ndx
 {
  long pos;
  date dt;
 };

s_ndx *nx;
int nx_cnt=0;
int top_pos=0;
int cur_pos=1;

char pass[8];
char tbuf[8],tbuf2[8];

char act_entry[101][57];

#define EW_LEFT 20
#define EW_TOP 4
#define OLDALH 21 // oldal merete

#define SCR(xx,yy)       act_entry[yy-1][xx-1]
//#define PUTSCR(xx,yy)    { gotoxy(xx,yy); e_color(xx,yy); putch(SCR(xx,yy)); }

#define S_CHR(x,y)	    scraddr[(x-1)*2+160*(y-1)]
#define S_ATTR(x,y) 	    scraddr[(x-1)*2+160*(y-1)+1]
#define PUT_CHR(x,y,char)   S_CHR(x,y)=char
#define PUT_EWCHR(x,y,char) S_CHR(x+EW_LEFT-1,y+EW_TOP-1)=char
#define PUTSCR(xx,yy)       PUT_EWCHR(xx,yy,SCR(xx,yy));

char *month[]={"","Jan","Feb","Mar","Apr","May","Jun",
                  "Jul","Aug","Sep","Okt","Nov","Dec"};

int etomb[]= {LIGHTBLUE,CYAN,LIGHTCYAN};

int nx_comp( const void *a, const void *b)
{
 if ( ((s_ndx *)a)->dt.da_year < ((s_ndx *)b)->dt.da_year )
  return -1;
 if ( ((s_ndx *)a)->dt.da_year > ((s_ndx *)b)->dt.da_year )
  return 1;

 if ( ((s_ndx *)a)->dt.da_mon < ((s_ndx *)b)->dt.da_mon )
  return -1;
 if ( ((s_ndx *)a)->dt.da_mon > ((s_ndx *)b)->dt.da_mon )
  return 1;

 if ( ((s_ndx *)a)->dt.da_day < ((s_ndx *)b)->dt.da_day )
  return -1;
 if ( ((s_ndx *)a)->dt.da_day > ((s_ndx *)b)->dt.da_day )
  return 1;

 return 0;
}

void set_entryscr(void)
{
 window(EW_LEFT,EW_TOP,76,22);
 gotoxy(1,1);
}

void set_mainscr(void)
{
 window(1,1,80,25);
}

int e_color( int xp, int yp )
{
 if (xp>=5+(yp*9)%11+6+(yp*7)%9+5+(yp*11)%13+7+(yp*9)%11)
  {
   textcolor(etomb[0]);
   return(etomb[0]);
  }
 if (xp>=5+(yp*9)%11+6+(yp*7)%9+5+(yp*11)%13)
  {
   textcolor(etomb[1]);
   return(etomb[1]);
  }
 if (xp>=5+(yp*9)%11+6+(yp*7)%9)
  {
   textcolor(etomb[2]);
   return(etomb[2]);
  }
 if (xp>=5+(yp*9)%11)
  {
   textcolor(etomb[1]);
   return(etomb[1]);
  }
 if (xp>=1)
  {
   textcolor(etomb[0]);
   return(etomb[0]);
  }
}

void e_paint( void )
{
 int c,d;

 for (c=1;c<=19;c++)
  {
   for (d=1 ; d<=56 ; d++)
    {
     S_ATTR(d+EW_LEFT-1,c+EW_TOP-1)=e_color(d,c);
    }
  }
}

void entry2scr( char *bf )
{
 int kar;
 int x=1,y=1,c;

 memset(act_entry,' ',57*101);
 for (c=0;c<100;c++)
  act_entry[c][56]=0;

 for (c=0;c<strlen(bf);c++)
  {
   kar=bf[c];
   if (kar=='\r')
    x=1;
   else
    if (kar=='\n')
     y++;
    else
     {
      SCR(x,y)=kar;
      x++;
      if (x>56)
       {
        x=1;
        y++;
       }
     }
   //putch(karx);
  }

 //*x1=x; *y1=y;
}

void scr2entry( char *bf ) // buf must be at least: 57*101=5,8Kbytes!
{
 int c,d;
 char *p,*q,*r;
 int ef=0;

 bf[0]='\0';
 p=bf;
 for (c=1;c<=100;c++)
  {
   q=&SCR(1,c);
   r=&q[strlen(q)-1];
   while (*r==' ')
    *(r--)='\0';
   if (q)
    strcat(p,q);
   if ((c!=100)&&(strlen(q)<56))
    strcat(p,"\r\n");
  }
 q=&p[strlen(p)-1];
 while (*q=='\r' || *q=='\n')
  q--;
 *(q+1)='\0';
}

int edit_entry( char *bf, int maxlen )
{
 set_entryscr();
 clrscr();
 e_paint();

 int ins_mode=1;
 int x=1,y=1,c,d;
 char karx;
 int kar,kar2;
 char *p;

 entry2scr(bf);
 /*
 if (bf[0]!='\0')
  for (c=1;c<=18;c++)
   {
    gotoxy(1,c);
    p=&SCR(1,c);
    for (d=1 ; *p!='\0'&& d<=56 ; d++,p++)
     {
      e_color(d,c);
      putch(*p);
     }
   }
 */
 for (c=1;c<=19;c++)
  {
   p=&SCR(1,c);
   for (d=1 ; *p!='\0'&& d<=56 ; d++,p++)
    {
     //e_color(d,c);
     PUT_EWCHR(d,c,*p);
    }
   int e;
   for (e=d ; e<=56 ; e++)
    PUT_EWCHR(e,c,' ');
  }

 if (bf[0]!='\0')
  for (c=19;c>1;c--)
   {
    x=-1;
    for (d=56;d>1;d--)
     if (SCR(d,c)!=' ')
      {
       x=d; y=c;
       x++;
       if (x>56)
        {
         y++; x=1;
        }
       break;
      }
    if (x!=-1)
     break;
   }

 if (ins_mode)
  {
   S_CHR(70,24)='I';
   S_ATTR(70,24)=WHITE;
   S_CHR(71,24)='N';
   S_ATTR(71,24)=LIGHTGRAY;
   S_CHR(72,24)='S';
   S_ATTR(72,24)=DARKGRAY;
  }
 else
  {
   S_CHR(70,24)=' ';
   S_CHR(71,24)=' ';
   S_CHR(72,24)=' ';
  }

 int cnt=0;
 int kilep=0;
 cursoron();
 gotoxy(x,y);
 do
  {
   //e_color(x,y);
   kar=getch();
   if (!kar)
    kar2=getch();

   switch (kar)
    {
     case 14:// Ctrl-N -- insline
            cursoroff();
             for (c=100;c>y;c--)
              {
               for (d=1 ; d<=56 ; d++)
                {
                 SCR(d,c)=SCR(d,c-1);
                 if (c<=19)
                  PUTSCR(d,c);
                }
              }
             for (d=1 ; d<=56 ; d++)
              {
               SCR(d,y)=' ';
               if (y<=19)
                PUTSCR(d,y);
              }
             cursoron();
             gotoxy(x,y);
            break;
     case 25:// Ctrl-Y
             cursoroff();
             for (c=y+1;c<=100;c++)
              {
               for (d=1 ; d<=56 ; d++)
                {
                 SCR(d,c-1)=SCR(d,c);
                 if (c<=19+1)
                  PUTSCR(d,c-1);
                }
              }
             cursoron();
             gotoxy(x,y);
            break;
     case 27:kilep=1;
            break;
     case 13:y++; x=1;
             gotoxy(x,y);
            break;
     case  9://Tab
             if (x<56)
              x=((x+8)/8)*8;
             else
              {
               x=1;
               y++;
              }
             gotoxy(x,y);
     	    break;
     case  8://Backspace ******
             if (x>1)
              x--;
             else
              if (y>1)
               {
                y--;
                x=56;
               }

             cursoroff();
             for (c=y;c<=100;c++)
              {
               for (d=(c==y)?(x+1):2 ; d<=56 ; d++)
                {
                 SCR(d-1,c)=SCR(d,c);
                 if (c<=19)
                  PUTSCR(d-1,c);
                }
               if (c!=100)
                {
                 SCR(56,c)=SCR(1,c+1);
                 if (c<=19)
                  PUTSCR(56,c);
                }
              }
             cursoron();
             //gotoxy(x,y);

             //SCR(x,y)=' ';
             //gotoxy(x,y);
             //putch(' ');
             //PUT_EWCHR(x,y,' ');
             gotoxy(x,y);
            break;
     case  0:switch (kar2)
              {
               case 72:if (y>1) y--;
                      break;
               case 80:if (y<100) y++;
                      break;
               case 75:if (x>1) x--;
                      break;
               case 77:if (x<56) x++;
                      break;
               case 71://home
                       if (x!=1)
                        x=1;
                       else
                        y=1;
                      break;
               case 79://end
                       int tx;
                       tx=x;
                       x=56;
                       while (SCR(x,y)==' ')
                        x--;
                       if (x<56) x++;
                       if (tx==x)
                        {
                         y=19;
                         x=56;
                         while (SCR(x,y)==' ')
                          x--;
                         if (x<56) x++;
                        }
                      break;
               case 82:// Ins
                       ins_mode=!ins_mode;
                       //for (c=70;c<=72;c++)
                       // S_ATTR(c,24)=WHITE;
                       if (ins_mode)
                        {
			 S_CHR(70,24)='I';
                         S_ATTR(70,24)=WHITE;
                         S_CHR(71,24)='N';
                         S_ATTR(71,24)=LIGHTGRAY;
                         S_CHR(72,24)='S';
                         S_ATTR(72,24)=DARKGRAY;
                        }
                       else
                        {
                         S_CHR(70,24)=' ';
                         S_CHR(71,24)=' ';
                         S_CHR(72,24)=' ';
                        }
                      break;
               case 83:// Del
                       cursoroff();
                       for (c=y;c<=100;c++)
                        {
                         for (d=(c==y)?(x+1):2 ; d<=56 ; d++)
                          {
                           SCR(d-1,c)=SCR(d,c);
                           if (c<=19)
                            PUTSCR(d-1,c);
                          }
                         if (c!=100)
                          {
                           SCR(56,c)=SCR(1,c+1);
                           if (c<=19)
                            PUTSCR(56,c);
                          }
                        }
                       cursoron();
                       gotoxy(x,y);
                      break;
              }
             gotoxy(x,y);
            break;
     default:
             if (ins_mode)
              {
               cursoroff();
               int lkar,lkar2;
               for (c=y;c<=100;c++)
                {
                 lkar2=lkar;
                 if (c!=100)
                  {
                   lkar=SCR(56,c);
                  }
                 for (d=56 ; d!=((c==y)?(x):1) ; d--)
                  {
                   SCR(d,c)=SCR(d-1,c);
                   if (c<=19)
                    PUTSCR(d,c);
                  }

                 if (c!=100 && c!=y)
                  SCR(1,c)=lkar2;
                 if (c<=19)
                  PUTSCR(1,c);
                }
              }
             PUT_EWCHR(x,y,kar);
             SCR(x,y)=kar;

             cursoron();
             gotoxy(x,y);

             /*
             PUT_EWCHR(x,y,kar);
             SCR(x,y)=kar;
             */
             x++;
             if (x>56)
              {
               x=1;
               y++;
              }
             gotoxy(x,y);
    }
  }
 while (!kilep);
 cursoroff();
 S_CHR(70,24)=' '; // INS clear
 S_CHR(71,24)=' ';
 S_CHR(72,24)=' ';
 //bf[0]=250;
 //cgets(bf);
 //bf+=2;
 //bf[cnt++]='\0';

 scr2entry(bf);

 set_mainscr();
 return(strlen(bf)+1);
}

void datekiir( int pos, date da )
{
 gotoxy(3,2-1+pos);
 cprintf("%4d.%3s.%2d.",da.da_year,month[da.da_mon],da.da_day);
}

void nodatekiir( int pos )
{
 gotoxy(3,2-1+pos);
 cprintf("%4s %3s %2s ","","","");
}

void old_kiir()
{
 int c,e,f;
 e=nx_cnt-top_pos;
 if (e>OLDALH)
  e=OLDALH;
 for (c=1;c<=e;c++)
  {
   if (c==cur_pos)
    textcolor(LIGHTRED);
   else
    textcolor(RED);
   datekiir(c,nx[top_pos+c-1].dt);
  }
 for (f=e+1;f<=OLDALH;f++)
  nodatekiir(c);
}

int entry_kiir( int l_break=0 )
{
 int c,d,e,x,y;
 char *bf, *p;

 /*
 textcolor(RED);
 gotoxy(37,12);
 cputs("Decompressing...");
 */
 PUT_EWCHR(1,1,'.');

 x=cur_pos+top_pos;

 lseek(mf,nx[x-1].pos,SEEK_SET);
 read(mf,&d,sizeof(int));
 bf=(char *)malloc(d);
 read(mf,bf,d);

 kinit(pass,DEC);
 d=((d+7)/8)*8;
 for (c=0;c < (d/8);c++)
  {
   if (kbhit() && l_break)
    {
     free(bf);
     return 1;
    }

   memcpy(tbuf2,&bf[c*8],8);
   des(&bf[c*8],tbuf);
   memcpy(&bf[c*8],tbuf,8);
   for (e=0;e<8;e++)
    tbuf2[e]^=tbuf[e];

   kinit(tbuf2,DEC);
  }

 set_entryscr();
 //clrscr();//***
 //textcolor(CYAN);
 gotoxy(1,1);
 //textcolor(etomb[0]);

 if (kbhit() && l_break)
  {
   set_mainscr();
   free(bf);
   return 1;
  }
 entry2scr(bf);
 if (kbhit() && l_break)
  {
   set_mainscr();
   free(bf);
   return 1;
  }
 //char *p;

 for (c=1;c<=19;c++)
  {
   if (kbhit() && l_break)
    {
     set_mainscr();
     free(bf);
     return 1;
    }

   /*
   gotoxy(1,c);
   p=&SCR(1,c);
   for (d=1 ; *p!='\0'&& d<=56 ; d++,p++)
    {
     e_color(d,c);
     putch(*p);
    }
   clreol();
   */
   //gotoxy(1,c);
   p=&SCR(1,c);
   for (d=1 ; *p!='\0'&& d<=56 ; d++,p++)
    {
     //e_color(d,c);
     PUT_EWCHR(d,c,*p);
    }
   int e;
   for (e=d ; e<=56 ; e++)
    PUT_EWCHR(e,c,' ');
  }
 /*
 int xx=1,yy=1;
 for (p=bf ; *p!='\0' ; p++)
  {
   e_color(xx,yy);
   putch(*p);
   if (*p=='\r')
    {
     xx=1;
     textcolor(etomb[0]);
    }
   else
    if (*p=='\n')
     yy++;
    else
     {
      xx++;
      if (xx>56)
       {
        xx=1;
        yy++;
       }
     }

  }
 */
 //cprintf("%s",bf);
 free(bf);
 set_mainscr();
 return 0;
}

void newentry(void)
{
 char *buf;
 char s[250];
 date dt,today;
 int siz,yi,mi,di;

 getdate(&today);

 gotoxy(30,24);
 clreol();
 cprintf("Date: %n%4d.%n%2d.%n%2d.",&yi,today.da_year,&mi,today.da_mon,&di,today.da_day);
 yi+=30; mi+=30; di+=30;

 cursoron();
 textcolor(YELLOW);
 gotoxy(yi,24);
 gets(s);
 if (s[0]!='\0')
  dt.da_year=atoi(s);
 else
  dt.da_year=today.da_year;

 gotoxy(mi,24);
 //cprintf(" Month:");
 gets(s);
 if (s[0]!='\0')
  dt.da_mon=atoi(s);
 else
  dt.da_mon=today.da_mon;
 gotoxy(di,24);
 //cprintf(" Day:");
 gets(s);
 if (s[0]!='\0')
  dt.da_day=atoi(s);
 else
  dt.da_day=today.da_day;
 cursoroff();
 gotoxy(1,24); clreol();

 nx[nx_cnt].dt=dt;


 //long fm=coreleft();


 buf=(char *)malloc(5701);
 if (!buf)
  {
   gotoxy(1,1);
   textattr(YELLOW+BLINK);
   cprintf("Mem alloc error at point#1 !\r\n");
   exit(1);
  }

 buf[0]='\0';
 siz=edit_entry(buf,5700);
 lseek(mf,0,SEEK_END);
 nx[nx_cnt].pos=tell(mf);

 kinit(pass,ENC);
 int c,e;
 siz=((siz+7)/8)*8;
 for (c=0;c < (siz/8);c++)
  {
   memcpy(tbuf2,&buf[c*8],8);
   des(&buf[c*8],tbuf);
   memcpy(&buf[c*8],tbuf,8);

   for (e=0;e<8;e++)
    tbuf2[e]^=tbuf[e];
   kinit(tbuf2,ENC);
  }

 write(mf,&siz,sizeof(siz));
 write(mf,buf,siz);
 free(buf);


 nx_cnt++;
}

void edit( void )
{
 char *buf;
 char s[250];
 date dt,today;
 int siz,yi,mi,di;

 int c,d,e,xpp,x,y;
 char *p;


 xpp=cur_pos+top_pos;

 buf=(char *)malloc(5800);
 if (!buf)
  {
   gotoxy(1,1);
   textattr(YELLOW+BLINK);
   cprintf("Mem alloc error at point#2 !\r\n");
   exit(1);
  }

 lseek(mf,nx[xpp-1].pos,SEEK_SET);
 read(mf,&d,sizeof(int));
 //bf=(char *)malloc(d);
 read(mf,buf,d);

 kinit(pass,DEC);
 d=((d+7)/8)*8;
 for (c=0;c < (d/8);c++)
  {
   memcpy(tbuf2,&buf[c*8],8);
   des(&buf[c*8],tbuf);
   memcpy(&buf[c*8],tbuf,8);
   for (e=0;e<8;e++)
    tbuf2[e]^=tbuf[e];

   kinit(tbuf2,DEC);
  }

 //set_entryscr();
 //clrscr();

 siz=edit_entry(buf,5800);
 lseek(mf,0,SEEK_END);
 nx[xpp-1].pos=tell(mf);

 kinit(pass,ENC);
 //int c,e;
 siz=((siz+7)/8)*8;
 for (c=0;c < (siz/8);c++)
  {
   memcpy(tbuf2,&buf[c*8],8);
   des(&buf[c*8],tbuf);
   memcpy(&buf[c*8],tbuf,8);

   for (e=0;e<8;e++)
    tbuf2[e]^=tbuf[e];
   kinit(tbuf2,ENC);
  }

 write(mf,&siz,sizeof(siz));
 write(mf,buf,siz);
 free(buf);
}

//---------------------------------------------------------------------

void main( void )
{
 ndx=open("diary.ndx",O_RDWR|O_BINARY|O_CREAT,S_IREAD|S_IWRITE);
 mf=open("diary.dat",O_RDWR|O_BINARY|O_CREAT,S_IREAD|S_IWRITE);

 directvideo=1; // use RAM
 cursoroff();

 int d;
 nx=(s_ndx *)calloc(2000,sizeof(s_ndx));
 for (d=0;d < (filelength(ndx)/sizeof(s_ndx));d++)
  {
   read(ndx,&nx[nx_cnt],sizeof(s_ndx));
   //if (nx[nx_cnt].year!=-1)
   nx_cnt++;
  }

 desinit();

 kepkiir(0,&DIARYINTRO);

 char bfx[500];
 unsigned int crcx,crcy,aa;
 int c,e;
 char s[32+2],*p;
 int ntry=0;

 int kilep=0;
 do
  {
   s[0]=32;
   gotoxy(23,12);
   textcolor(MAGENTA);
   for (c=0;c<32;c++)
    putch('');

   gotoxy(23,12);
   textcolor(LIGHTMAGENTA);
   int kr,cc;
   cursoron();
   s[32]='\0';
   for (cc=0;cc<32;cc++)
    {
     kr=getch();
     if (kr==13)
      {
       s[cc]='\0';
       break;
      }
     if (kr==27)
      {
       textattr(7);
       clrscr();
       exit(1);
      }
     if (kr==8)
      {
       if (cc>0)
        {
         cc-=2;
         textcolor(MAGENTA);
         cprintf("\b\b");
         textcolor(LIGHTMAGENTA);
        }
       else
        cc--;
      }
     else
      {
       putch('*');
       s[cc]=kr;
      }
     /*
     if (kr==0)
      {
       getch();
       cc-=1;
      }
     */

    }
   p=s;
   cursoroff();
   memset(pass,0xAF,8);
   memcpy(pass,p,(strlen(p)>8) ? 8 : strlen(p));
   memset(s,0,34);

   if (filelength(mf)==0)
    kilep=1;
   else
    {
     lseek(mf,0,SEEK_SET);
     read(mf,bfx,500);

     kinit(pass,DEC);
     for (c=0;c<32;c++)
      {
       memcpy(tbuf2,&bfx[c*8],8);
       des(&bfx[c*8],tbuf);
       memcpy(&bfx[c*8],tbuf,8);
       for (e=0;e<8;e++)
        tbuf2[e]^=tbuf[e];

       kinit(tbuf2,DEC);
      }

     CRC cr2;
     // crcx=11;
     for (c=0;c<128;c++)
      {
       //aa=bfx[c];//*((unsigned int *)&bfx[c*2]);
       aa=*((unsigned int *)&bfx[c*2]);
       cr2+=aa;
      }
     crcx=cr2.value();
     crcy=*((int *)&bfx[256]);
     if (crcx==crcy)
      kilep=1;
     else
      {
       ntry++;
       gotoxy(23,13);
       textattr(RED+BLINK);
       cprintf("Wrong password! Try#%d",ntry);
      }
    }
   if (ntry>=3 && !kilep)
    {
     textattr(7);
     clrscr();
     cursoron();
     exit(1);
    }
  }
 while (!kilep);

 if (filelength(mf)==0)
  {
   CRC cr;

   memset(bfx,0,500);

   for (c=0;c<256;c++)
    bfx[c]=random(256);

   //crcx=11;
   for (c=0;c<128;c++)
      {
       aa=*((unsigned int *)&bfx[c*2]);
       cr+=aa;
      }
   crcx=cr.value();
   *((int *)&bfx[256])=crcx;

   kinit(pass,ENC);
   for (c=0;c<32;c++)
    {
     memcpy(tbuf2,&bfx[c*8],8);
     des(&bfx[c*8],tbuf);
     memcpy(&bfx[c*8],tbuf,8);

     for (e=0;e<8;e++)
      tbuf2[e]^=tbuf[e];
     kinit(tbuf2,ENC);
    }

   write(mf,bfx,500);
  }

 kepkiir(0,&DIARYSCR);

 kilep=0;
 int kar,kar2;
 //int c;

 //newentry();

 e_paint();

 do
  {
   qsort(&nx[0],nx_cnt,sizeof(s_ndx),nx_comp);

   old_kiir();
   if (nx_cnt)
    entry_kiir(1);

   kar=toupper(getch());
   if (!kar)
    kar2=getch();

   switch (kar)
    {
     case  27:kilep=1;
             break;
     case 'N':newentry();
             break;
     case 'E':edit();
             break;
     case 'D'://Delete
              if (!nx_cnt)
	       break;
              int kr;
              gotoxy(1,24); clreol();
              cprintf("Delete entry? [Y/N] ");
              //gotoxy(1,24);
              cursoron();
              do { kr=toupper(getch()); } while(!(kr=='Y'||kr=='N'||kr==27));
              cursoroff();
              if (kr!='Y')
               {
                gotoxy(1,24); clreol();
                break;
               }
              int xx;
              xx=cur_pos+top_pos;
              nx[xx-1]=nx[nx_cnt-1];
              nx_cnt--;
              if (nx_cnt==0)
               {
                set_entryscr();
                clrscr();
                e_paint();
                set_mainscr();
               }
              gotoxy(1,24); clreol();
             break;
     case   0:switch(kar2)
               {
                case 59:// F1 key
                        char *oldscr;
                        oldscr=(char *)malloc(4000);
                        kepvesz(oldscr);
                        kepkiir(3,&DIARYHLP);
                        while (kbhit())
			 getch();
                        getch();
                        kepkiir(3,oldscr);
                        free(oldscr);
                       break;
                case 71:top_pos=0;
                        cur_pos=1;
                       break;
                case 72:if (cur_pos>1)
                         cur_pos--;
                        else
                         if (top_pos>0)
                          top_pos--;
                       break;
                case 80:if ((cur_pos<OLDALH)&&(top_pos+cur_pos<nx_cnt))
                         cur_pos++;
                        else
                         if (top_pos+OLDALH<nx_cnt)
                          top_pos++;
                       break;
                case 79://cur_pos=nx_cnt-top_pos
                       break;
               }
             break;
    }
  }
 while (!kilep);

 lseek(ndx,0,SEEK_SET);
 for (c=0;c<nx_cnt;c++)
  write(ndx,&nx[c],sizeof(s_ndx));
 chsize(ndx,sizeof(nx[0])*nx_cnt);

 memset(act_entry,0,57*101);
 memset(pass,0,8);

 free(nx);
 cursoron();
 clrscr();
}
