/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    _GETBUF.C                                         */
/********************************************************/

int _getbuf(bufsize, dbfptr) /*** error assignment: 3300 ***/
	U2BYTES bufsize;
	DBFFILE  *dbfptr;
{
	extern char *malloc();
	extern int _dbcerr;

	if (!(dbfptr->_bfptr = malloc(bufsize))) {
		_dbcerr = 3301;
		return(1);
	}
	dbfptr->_bufsize = bufsize;
	return(0);
} /* end of _getbuf() */

/**************************************************************
* NAME         _rlsbuf
*
* USED BY      dBcreat, dBopen
*
* ABSTRACT     release buffer
*
* DESCRIPTION  This function deallocates a buffer used for disk I/O.
*
****************************************************************/
int _rlsbuf(dbfptr)
	DBFFILE *dbfptr;
{
	/* extern int rlsmem(); */

	if (dbfptr->_bfptr) free(dbfptr->_bfptr);
	dbfptr->_bfptr = (char *) 0;
	dbfptr->_first = (RECNUM) 0;
	dbfptr->_bfhas = 0;
	return(0);
} /* end of _rlsbuf() */

/**************************************************************
* NAME         _getbuf2
*
* USED BY      dBopen
*
* ABSTRACT     get buffer for record fields
*
* DESCRIPTION  This function allocates a buffer for record fields.
*
****************************************************************/
int _getbuf2(dbfptr)    /*** error assignment: 3400 ***/
	DBFFILE  *dbfptr;
{
extern char *malloc();
extern int _dbcerr;

if (!(dbfptr->_flds
    = (dBFIELD *) malloc( (U2BYTES) (sizeof(dBFIELD) * dbfptr->_nflds)))) {
	_dbcerr = 3401;
	return(1);
}
return(0);
} /* end of _getbuf2() */

/**************************************************************
* NAME         _rlsbuf2
*
* USED BY      dBclose
*
* ABSTRACT     release buffer used for record fields
*
* DESCRIPTION  This function deallocates a buffer used for record fields.
*
****************************************************************/
int _rlsbuf2(dbfptr)
	DBFFILE  *dbfptr;
{
/* extern int rlsmem(); */

if (dbfptr->_flds)
free((char *) dbfptr->_flds);

dbfptr->_flds = (dBFIELD *) 0;
dbfptr->_nflds = (FLDNUM) 0;

return(0);
} /* end of _rlsbuf2() */
