/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBUPDR.C                                          */
/********************************************************/

int dBrecall(dbffd, recno)
	char   *dbffd;
	RECNUM recno;
{
	char *space;

	space = " ";

	return(_update(dbffd, recno, space, 3));

} /* end of dBrecall() */


int dBdelete(dbffd, recno)
	char   *dbffd;
	RECNUM recno;
{
	char *astrisk;

	astrisk = "*";

	return(_update(dbffd, recno, astrisk, 2));

} /* end of dBdelete() */


int dBupdr(dbffd, recno, record)
	char   *dbffd;
	RECNUM recno;
	char   *record;
{
	return(_update(dbffd, recno, record, 1));
} /* end of dBupdr() */

static int _update(dbffd, recno, record, mode) /*** error assignment: 700 ***/
	char   *dbffd;
	RECNUM recno;
	char   *record;
	int    mode;
{
DBFFILE *dbfptr;
RECNUM size, offset;
U2BYTES copylen;
char *cptr;
char dbfmode;
int  rc, chgmode;
extern int _dbfoff(), dBsize(), _getbuf(), dBflush();
extern int _dbcerr;


dbfptr = (DBFFILE *) dbffd;

if (_dbfoff(dbfptr)) {
	return(1);
}
if ((rc = dBsize(dbffd, &size)) != 0) return(rc);
if ((recno > size) || !recno) {
	_dbcerr = 701;
	return(3); /* record number too big or zero */
}

dbfmode = dbfptr->_dbfmode;
offset = (RECNUM) 0; /* default offset used in many cases */
chgmode = 1; /* change mode */

if (!dbfptr->_bfptr) {
	/* attach I/O buffer */
	if (_getbuf( dbfptr->_bufsize, dbfptr) == 1) {
		return(1);
	}
	if (_updread(dbfptr, recno) != 0)	{
		_rlsbuf(dbfptr);
		_dbcerr = 702;
		return(1);
	}
}
else {  /* I/O buffer already attached */
    if (dbfmode & 0x0f) { /* read/append/insert/update */
	if (recno < dbfptr->_first
		    || (dbfptr->_first + dbfptr->_bfhas) <= recno) {
		/* this requested record is NOT in the buffer :
		   flush the buffer first if necessary */
		if (dbfmode & 0x0e)
			if (dBflush(dbffd) != 0) {
				_rlsbuf(dbfptr);
				return(4);
			}
		if (_updread(dbfptr, recno) != 0) {
			_rlsbuf(dbfptr);
			_dbcerr = 703;
			return(1);
		}
	} else {
		 /* requested record is in the buffer */
		if (dbfmode & 0x06) chgmode = 0; /* don't change mode */
		offset = recno - dbfptr->_first;
	}
    } else if (dbfmode & 0x10) {
	if (dBflush(dbffd) != 0) {
		_rlsbuf(dbfptr);
		return(4);
	}
	if (_updread(dbfptr, recno) != 0) {
		_dbcerr = 704;
		return(1);
	}
    } else {
	_dbcerr = 705;
	return(1);
    }
}

cptr = dbfptr->_bfptr + dbfptr->_len * offset;

switch(mode) {
case 1:
	*cptr++ = ' ';
	copylen = (U2BYTES) (dbfptr->_len - 1);
	break;

case 2:
case 3:
	copylen = 1;

} /* end of switch() */

_copydn(record, cptr, copylen);

if (chgmode) dbfptr->_dbfmode = 0x08;

return(0);
} /* end of _update() */



static int _updread(dbfptr, recno)
	DBFFILE *dbfptr;
	RECNUM  recno;
{
	int size;
	extern long lseek();

	/*** read records ***/
	/* place needle at the beginning of read segment of the record */
	if (lseek( dbfptr->_dbffn,
	   	   (long) ((dbfptr)->_begdata) + (long) dbfptr->_len * (recno - 1),
	   	   0) == -1L) {
		_rlsbuf(dbfptr);
		return(1);
	}

	/* then, read one or more records from disk to buffer */
	if ((size= read(dbfptr->_dbffn, dbfptr->_bfptr, dbfptr->_bufsize))
			== -1) {
			_rlsbuf(dbfptr);
			return(1);
	}

	dbfptr->_first = recno;
	dbfptr->_bfhas = size / dbfptr->_len;
	return(0);
} /* end of _updread() */
