/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBTKEY.C                                          */
/********************************************************/

int dBtkey(ndxfd, key, recno)
	char   *ndxfd;
	char   *key;
	RECNUM *recno;
{
NDXFILE *ndxptr;
int rc;

ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) return(1);

ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage &= 0x3f;

switch(rc = _lockey(ndxptr, ndxptr->_rootblk, key, recno))
{
case 1:
case 4:
	_errrls(ndxptr);
	break;
default:			/* MI-SOFT	*/
	memcpy(ndxptr->_actkey,key,ndxptr->_keylen);
	ndxptr->_actpointer = *recno;
	break;
}
return(rc);
} /* end of dBtkey() */


/**************************************************************
* NAME         _lockey
* 
* CALLED BY    dBtkey
*
* DESCRIPTION  This function finds a key in an index file
*	       and sets the sequential-read pointer.
*
* CALLING SEQUENCE
*		ndxptr->_svptr = ndxptr->_svector;
*		_lockey(ndxptr, ndxptr->_rootblk, key, recno);
****************************************************************/
int _lockey(ndxptr, thisblk, key, recno) /** error assignment: 2600 **/
	NDXFILE  *ndxptr;
	BLKNO    thisblk;
	char	 *key;
	RECNUM   *recno;
{
BYTE found;
BYTE keynum;
BLKNO nextblk;
BYTE *blkptr, *bufptr;
int i, rc;
extern int _dbcerr;
extern int _rdblk(), _comparek(), _nkeycomp();
extern NBYTES _nbytes();


if ((rc = _rdblk(ndxptr, thisblk)) != 0) return(rc);

blkptr = ndxptr->_svptr->_nxbfptr;
bufptr = blkptr;
keynum = *bufptr;
bufptr += 4;
if (keynum == 0) {
	_dbcerr = 2601;
	return(7); /* no key has been entered */
}
nextblk = (BLKNO) _nbytes(bufptr);
if (nextblk) keynum--;

found = 0;
for (i=1; i<=keynum; i++) {

	if (ndxptr->_keytype == 0) 
		rc = _comparek(bufptr+8, key, ndxptr->_keylen);
	else
		rc = _nkeycomp(bufptr+8, key, ndxptr->_keylen);
	
	switch (rc) {

	case 0: /* left less than right */
		/* not found yet: keep searching */
		/* The following index may be the very last index
		   in a high-level index block:
		   In such a case, "i" indicates that the last index
		   in the block should be the corrsponding index. */

		bufptr += ndxptr->_kptrlen;
		continue; /* this is the only case that make the loop */

	case 2: /* left greater than right */
		/* found the spot to insert */
		found = 2;
		break;

	case 1: /* left equal to right */
		found = 1;
		break;
		   
	} /* end of switch */

	break;
	
} /* end of for-loop */

ndxptr->_svptr->_nxidno = i;

if (nextblk) {
	/* get next block # for this entry */
	nextblk = (BLKNO) _nbytes(bufptr++);

 	/* go down to next block */
	ndxptr->_svptr++;
	rc = _lockey(ndxptr, nextblk, key, recno);
	ndxptr->_svptr--;
	return(rc);
}

if (found == 1 || found == 2) {
	*recno = (RECNUM) _nbytes(bufptr + 4);
	memcpy(key,(bufptr+8),ndxptr->_keylen);		/* MI-SOFT	*/


	if (found == 1) return(0);
	_dbcerr = 2602;
	return(8);	
}
ndxptr->_svector[0]._nxusage |= 0x40;
_dbcerr = 2603;
return(9); /* the requested key is larger than existing keys */

} /* end of _lockey() */
