/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBPUTRK.C                                         */
/********************************************************/

int dBputrk(dbffd, ndxfd, key, record) /*** error assignment: 2400 ***/
	char *dbffd;
	char *ndxfd;
	char *key;
	char *record;
{
DBFFILE  *dbfptr;
NDXFILE  *ndxptr;
RECNUM   recno, size;
char	svkey[100];		/* MI-SOFT	*/
int      rc, update;
extern int dBsize(), dBtkey(), dBakey(), dBupdr(), dBputr();
extern int _dbcerr;


dbfptr = (DBFFILE *) dbffd;
ndxptr = (NDXFILE *) ndxfd;

if (dbfptr->_dbfmode == 0x00) {
	_dbcerr = 2401;
	return(1);
}
if (ndxptr->_ndxmode == 0x00) {
	_dbcerr = 2402;
	return(1);
}
if (dBsize(dbffd, &size) != 0) return(1);

memcpy(svkey,key,ndxptr->_keylen);
switch (rc = dBtkey(ndxfd, key, &recno)) {
 
case 0:
	/* requested key already exists in this index file */
	if (recno > size) {
		_dbcerr = 2403;
		return(10); /* no such rec. no. in .DBF */
	}
	update = 1; /* update an existing record later */
	break;
case 8:
	memcpy(key,svkey,ndxptr->_keylen);
case 7:
case 9:
	update = 0; /* add a record and a key later */
	recno = size + (RECNUM) 1;
	break;

default: /* includes "case d_ERROR:" */
	return(1);
} /* end of switch */

/* call to dBtkey was OK */

if (update) {
	rc = dBupdr(dbffd, recno, record);
}
else {
	rc = dBputr(dbffd, recno, record);
}

switch (rc) {
case 0:
	break;

/* this case should not happen, since this condition was already checked
case d_BADREC:
	return(d_NOSYNC);
*/

case 4:
	return(4);

default:
	return(1);
}

if (update) return(0);

/* This is the situation where the requested key does not exist in the
   current index file(.NDX) */

return(dBakey(ndxfd, key, recno));

} /* end of dBputrk() */
