/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBPUTM.C                                          */
/********************************************************/

int dBputm(dbtfd, memo, field) /* ERROR NB. ASSIGNMENT: 4400 */
	char   *dbtfd;
	char   *memo;  /* terminated with 0 or 2 0x1a's */
	char   *field; /* return: .DBF memo field format */
{
DBTFILE *dbtptr;
char *cptr, *cptr1, *cptr2;
U2BYTES  i; /* # of input characters processed */
int       j; /* # of characters processed in a line */
int       k; /* # of output characters accumulated */
BLKNO eof;
int mod;
char *memobuf;
long end, last;
int diff;
int keeploop; /* 0=>reached end of memo: 1=>not reached end of memo
		 100=>reached end of memo && 
		      memo contents + EOF marker exceeded BUFSIZ */
int wtsize;
extern int _dbtoff(), write();
/* extern int rlsmem(); */
extern char *malloc();
extern long lseek();
extern int _dbcerr;
extern U2BYTES _dbcmsiz;

dbtptr = (DBTFILE *) dbtfd;

if (_dbtoff(dbtptr)) return(1);

for (i=1, cptr=field; i<=10; i++) *cptr++ = ' ';
if ( (!(*memo)) || (*memo == (BYTE) 0x1a) ) return(0);

eof = dbtptr->_dbteof - (BLKNO) 1;
last = (long) eof * 512;

if ((end = lseek(dbtptr->_dbtfn, (long) 0L, 2)) == -1L)
{
    _dbcerr = 4401;
    return(1);
}
diff = (int) (end - last);
if (512 < diff)
{
    if (lseek(dbtptr->_dbtfn, last + 512, 0) == -1L)
    {
	_dbcerr = 4402;
	return(1);
    }
}
else if (diff <= 0)
{
    _dbcerr = 4403; /* memo file corrupted */
    return(1);
}
else if (diff < 512)
{
    diff = 512 - diff;
    if (!(memobuf = malloc((U2BYTES) diff)))
    {
	_dbcerr = 4404;
	return(1);
    }
    cptr = memobuf;
    for (i=1; i<=diff; i++) *cptr++ = 0;
    if (write(dbtptr->_dbtfn, memobuf, diff) != diff)
    {
	free(memobuf);
	_dbcerr	= 4405;
	return(4);
    }
    free(memobuf);
}
/* (diff == BLKSIZ) => existing .DBT file is in block boundary */

if (!(memobuf = malloc((U2BYTES) 512 + 5)))
{
    _dbcerr = 4406;
    return(1);
}

cptr = memobuf;
i = 1;
j = 1;
k = 0;
keeploop = 1;
while (keeploop)
{
    while (2)
    {
	if (    !(*memo)
	     || ((*memo == (BYTE) 0x1a) && (*(memo+1) == (BYTE) 0x1a))
	     || (i > _dbcmsiz) )
	{
	    if (keeploop != 100) keeploop = 0;
	    break; /* get out from 2nd-loop */
        }
	if (((*memo & (BYTE) 0x7f) == (BYTE) 0x0d)
	    && ((*(memo+1) & (BYTE) 0x7f) == (BYTE) 0x0a))
	{
	    *cptr++ = (BYTE) 0x8d;
	    *cptr++ = (BYTE) 0x0a;
	    memo += 2;
	    k += 2;
	    j = 1;
	    i += 2;
	}
	else
	{
	    *cptr++ = *memo++;
	    k++;
	    if (j == 66)
	    {
		if (   ((*cptr & (BYTE) 0x7f) != (BYTE) 0x0d)
		    || ((*(cptr+1) & (BYTE) 0x7f) != (BYTE) 0x0a))
		{
		    *cptr++ = (BYTE) 0x8d;
		    *cptr++ = (BYTE) 0x0a;
	        }
	        k += 2;
	        j = 0;
	    }
	    i++;
	    j++;
	} /* end of if-else.... */
	if (cptr >= (memobuf + 512)) break; /* break from 2nd-loop */
    } /* end of 2nd-level while-loop */

    if (keeploop == 0)
    {
	*cptr++ = (BYTE) 0x1a;
	*cptr++ = (BYTE) 0x1a;
	k += 2;
    }

    wtsize = (cptr >= memobuf + 512) ? 512 : cptr - memobuf;
    if (write(dbtptr->_dbtfn, memobuf, wtsize) != wtsize)
    {
	_dbcerr = 4407;
	free(memobuf);
	return(4);
    }
    if (keeploop == 100) break; /* break from 1st-while loop */

    if (cptr <= memobuf + 512) cptr = memobuf;
    else /* cptr > memobuf + BUFSIZ */
    {
	cptr1 = memobuf + 512;
	cptr2 = memobuf;
	while (cptr1 < cptr) *cptr2++ = *cptr1++;
	cptr = cptr2;
	if (keeploop == 0) keeploop = 100;
    }
} /* end of 1st-level while-loop */

free(memobuf);

cptr = field + 9;
eof = dbtptr->_dbteof;
mod = eof % (BLKNO) 10;
*cptr-- = mod + '0';
eof = eof - mod;
for (i=1; i<=9 && eof; i++)
{
	eof = eof / (BLKNO) 10;
	mod = eof % (BLKNO) 10;
	*cptr-- = mod + '0';
	eof = eof - mod;
}
dbtptr->_dbteof += k/512 + 1;

return(0);
} /* end of dBputm() */
