/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBNKEY.C                                           */
/********************************************************/

int dBnkey(ndxfd, key, recno) /*** error assignment: 2000 ***/
	char	 *ndxfd;
	char	 *key;
	RECNUM   *recno;
{
extern int _dbcerr;
NDXFILE *ndxptr;
int rc;
extern NBYTES _nbytes();

ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr))
	return(1);

if (ndxptr->_svector[0]._nxusage & 0x80)
	{
	/*
	 *	place the sequential ptr at the very first key
	 *	in the index file
	 */
	ndxptr->_svptr = ndxptr->_svector;
	rc = _1stkey(ndxptr, ndxptr->_rootblk, key, recno);
	}
else if (ndxptr->_svector[0]._nxusage & 0x40)
	{
	/*	reached the end of the index file: no more keys
	 *	place the sequential ptr at the very first key
	 *	in the index file
	 */
	rc= 9;
	}
else if ((rc = _findexact((char*)ndxptr,key,recno)) == 0)
	{
	ndxptr->_svptr = ndxptr->_endofsv;
	rc = _gnextk(ndxptr, key, recno);
	}
else if (rc == 8)	/* findexact found the next higher key		*/
	rc = 0;

switch(rc)
{
case 0:
	memcpy(ndxptr->_actkey,key,ndxptr->_keylen);
	ndxptr->_actpointer = *recno;
	break;
case 1:
case 4:
	_errrls(ndxptr);
	break;
case 9:
	ndxptr->_svptr = ndxptr->_svector;
	ndxptr->_svptr->_nxusage = (ndxptr->_svptr->_nxusage & 0x3f) | 0x40;
	_dbcerr = 2010;
	break;
}

return(rc);	
} /* end of dBnkey() */


/****************************************************************************
* NAME         _gnextk
* 
* CALLED BY    dBnkey
*
* ABSTRACT     get next key
*
* DESCRIPTION  This function loacates the sequential-read pointer to the
*	       next key in the index file.
*
* CALLING SEQUENCE
*		_gnextk(ndxptr);
*
*****************************************************************************/
int _gnextk(ndxptr, key, recno)		/* MI-SOFT: originally was static */
 	NDXFILE  *ndxptr;
	char     *key;
	RECNUM   *recno;
{
BYTE *blkptr, *bufptr;
BYTE keynum;
BLKNO nextblk;  /* non-0: this block contains keys and associated record #
		       0: this block contains indices to another block      */
int i;
extern int _dbcerr;
extern int _1stkey();
extern NBYTES _nbytes();

/*
if (ndxptr->_svector[0]._nxusage & 0x80) {
	place the sequential ptr at the very first key in the index file
	ndxptr->_svptr = ndxptr->_svector;
	return(_1stkey(ndxptr, ndxptr->_rootblk, key, recno));
}

if (!(ndxptr->_svector[0]._nxusage & 0x40))
*/

while (ndxptr->_svector <= ndxptr->_svptr) {
	blkptr = ndxptr->_svptr->_nxbfptr; /* equivalent to _rdblk() */
	bufptr = blkptr;
	keynum = *bufptr++;
	if (keynum >= ndxptr->_svptr->_nxidno) ndxptr->_svptr->_nxidno += 1;
	if (keynum >= ndxptr->_svptr->_nxidno) {
		/* _nxidno & keynum both start at 1:
		   don't need to go backward or left since there are one or
		   more indices still remaining in this block */
		bufptr = blkptr + 4
		+ (U2BYTES) (ndxptr->_svptr->_nxidno - 1) * ndxptr->_kptrlen;

		nextblk = (BLKNO) _nbytes(bufptr);
		if (nextblk) {
			ndxptr->_svptr++;
			return(_1stkey(ndxptr, nextblk, key, recno));
		}
		bufptr += 4;
		*recno = (RECNUM) _nbytes(bufptr);
		bufptr += 4;
		for (i=1; i<=ndxptr->_keylen; i++) *key++ = *bufptr++;
		return(0);
	}
	ndxptr->_svptr--; /* place ptr to vector one previous place */

} /* end of while loop */	

/*** reached the end of the index file: no more keys ***/
/* place the sequential ptr at the very first key in the index file */
ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage =
	(ndxptr->_svptr->_nxusage & 0x3f) | 0x40;
_dbcerr = 2010;
return(9);

} /* end of _gnextk() */


/****************************************************************************
* NAME         _1stkey
* 
* CALLED BY    _gnextk
*
* ABSTRACT     1st key
*
* DESCRIPTION  This function locates the sequential-read pointer at the
*	       first index of a particular root block.
*
* CALLING SEQUENCE
*	(1)	To set ptr to the very first key in the entire index file:
*		ndxptr->_svptr = ndxptr->_svector;
*		_1stkey(ndxptr, root block #, ptr to key, ptr to recno);
*
*	(2)	To set ptr to the first key from the block _svptr is
*		pointing to:
*		_1stkey(ndxptr, current block # of interest, &key, &recno);
*
*****************************************************************************/
static int _1stkey(ndxptr, thisblk, key, recno)
	NDXFILE *ndxptr;
	BLKNO   thisblk;
	char    *key;
	RECNUM  *recno;
{
BYTE *blkptr, *bufptr;
BYTE keynum;
BLKNO nextblk;  /* non-0: this block contains keys and associated record #
		       0: this block contains indices to another block      */
int rc, i;
extern int _dbcerr;
extern int _rdblk();
extern NBYTES _nbytes();

/* read this block */
if ((rc = _rdblk(ndxptr, thisblk)) != 0) return(rc);

blkptr = ndxptr->_svptr->_nxbfptr;
bufptr = blkptr;

keynum = *bufptr;

if ( keynum == 0 ) {
	/* no key has been entered in the index file */
	_dbcerr = 2020; /* corrupt index file ? */
	return(7);
}

ndxptr->_svptr->_nxidno = 1; /* the first index in the block */

nextblk = (BLKNO) _nbytes(bufptr + 4);

if (nextblk) {
	/* go down to next level */
	ndxptr->_svptr++;
	if ((rc = _1stkey(ndxptr, nextblk, key, recno)) != 0)
	{
		if (rc == 7) rc = 1;
		return(1); /* corrupt index file or read failure */
	}
	return(0);
}

/* reached the lowest level index block */
bufptr = blkptr + 8;
*recno = (RECNUM) _nbytes(bufptr);
bufptr += 4;
for (i=1; i<=ndxptr->_keylen; i++) *key++ = *bufptr++;

ndxptr->_svector[0]._nxusage &= 0x3f;
if (ndxptr->_endofsv < ndxptr->_svptr) ndxptr->_endofsv = ndxptr->_svptr;

return(0);

} /* end of _1stkey() */

/***********************************************
 *                  dBckey()                   *
 ***********************************************/

int dBckey(ndxfd, key, recno) /*** error assignment: 1900 ***/
	char	 *ndxfd;
	char	 *key;
	RECNUM   *recno;

{
NDXFILE	*ndxptr;
int		i;
BYTE		*bufptr;
struct _seqacc	*endsv;
BYTE		usg;
extern int	_dbcerr;
extern NBYTES	_nbytes();


ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) return(1);

usg = ndxptr->_svector[0]._nxusage;
if (usg & 0x80) {
	_dbcerr = 1901;
	return(11);
}
if (usg & 0x40) {
	_dbcerr = 1902;
	return(9);
}
if (_findexact((char*)ndxptr,key,recno) != 0)	/* MI-SOFT		*/
	{
	_dbcerr = 1901;
	return(11);
	}

endsv = ndxptr->_endofsv;
bufptr = endsv->_nxbfptr + 8
	 + (U2BYTES) (endsv->_nxidno - 1) * ndxptr->_kptrlen;
*recno = (RECNUM) _nbytes(bufptr);
bufptr += 4;
for (i=1; i<=ndxptr->_keylen; i++) *key++ = *bufptr++;

return(0);
} /* end of dBckey() */


/**********************************************
*                  dBrewind()                 *
**********************************************/

int dBrewind(ndxfd)
	char *ndxfd;
{
NDXFILE *ndxptr;
extern int _ndxoff();

ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) {
	return(1);
}
/* rewind the sequential ptr to the first position in the index file */
ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage = (ndxptr->_svptr->_nxusage & 0x3f) | 0x80;
return(0);
} /* end of dBrewind() */

