/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBMOPEN.C                                         */
/********************************************************/

static DBTFILE _dbtfiles[10];


int dBmopen(dbtname, dbtfd) /*** error assignment: 4100 ***/
       char *dbtname; /* pointer to a file name character string
                         that represents the .DBT file
	 	         to be opened */
       char **dbtfd;  /* memo file descriptor */
{
	int found;
	int fn;	    /* file number */
	DBTFILE *dbtptr;
	char   header[4];
	extern DBTFILE _dbtfiles[];
	extern int _dbcerr;
	extern NBYTES _nbytes();

	found = 0;
	for (dbtptr=_dbtfiles; dbtptr < _dbtfiles + 10; dbtptr++) 
	{
		if (dbtptr->_dbtmode == 0x00)
		{
			dbtptr->_dbtmode = 0x01; /* prevent this slot
						     from collision */
			found = 1;
			break; /* found free slot */
		}
	}
	if (!found)
	{
		_dbcerr = 4101;
		return(1); /* no free slot */
	}

if ((fn=open(dbtname,
			0x0002 | 0x8000)
) < 0)
	{
		dbtptr->_dbtmode = 0x00;
		_dbcerr = 4102;
		return(1); /* open failure */
	}

	if (read(fn, header, 4) != 4)
	{
		dbtptr->_dbtmode = 0x00;
		close(fn);
		_dbcerr = 4103;
		return(1); /* read failure */
	}
	dbtptr->_odbteof = dbtptr->_dbteof = (BLKNO) _nbytes(header);

	dbtptr->_dbtfn = fn;
	dbtptr->_dbtmode = 0x01; /* initially open for reading */

	*dbtfd = (char *) dbtptr;
	return(0);

} /* end of dBmopen() */

                                              
int dBmclose(dbtfd) /*** error assignment: 4200 ***/
	char *dbtfd;
{
extern int _dbtoff();
int rc;
char upbuf[4];
DBTFILE *dbtptr;
extern int _dbcerr;


dbtptr = (DBTFILE *) dbtfd; /* cast to DBTFILE first */

if (_dbtoff(dbtptr)) return(1);

rc = 0;
if (dbtptr->_odbteof != dbtptr->_dbteof)
{
	_bytesn(dbtptr->_dbteof, upbuf);

	if (lseek(dbtptr->_dbtfn, 0L, 0) == -1L)  rc++;
	if (write(dbtptr->_dbtfn, upbuf, 4) != 4) rc++;
}
dbtptr->_dbtmode = 0x00;
if (rc)
{
	close(dbtptr->_dbtfn);
	_dbcerr = 4201;
	return(4);
}

if (close(dbtptr->_dbtfn))
{
	_dbcerr = 4202;
	return(1);
}
return(0);
} /* end of dBmclose() */



int _dbtoff(dbtptr)   /*** error assignment: 4290 - 4299 ***/
	DBTFILE *dbtptr;
{
extern DBTFILE _dbtfiles[];
extern int _dbcerr;

if ((dbtptr < _dbtfiles) || ((_dbtfiles + 10) <= dbtptr) ||
    (dbtptr->_dbtmode == 0x00))
{
	_dbcerr = 4290;
	return(1); /* DBT file not open */
}
return(0); /* DBT file open */
} /* end of _dbtoff() */
