/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*  DBMISC.C                                            */
/********************************************************/

struct WORDREGS {
	unsigned int ax;
	unsigned int bx;
	unsigned int cx;
	unsigned int dx;
	unsigned int si;
	unsigned int di;
	unsigned int cflag;
	};

/* byte registers */

struct BYTEREGS {
	unsigned char al, ah;
	unsigned char bl, bh;
	unsigned char cl, ch;
	unsigned char dl, dh;
	};

/* general purpose registers union - overlays the corresponding word and
 * byte registers.
 */

union REGS {
	struct WORDREGS x;
	struct BYTEREGS h;
	};

/* segment registers */

struct SREGS {
	unsigned int es;
	unsigned int cs;
	unsigned int ss;
	unsigned int ds;
	};

/* dosexterror struct */

struct DOSERROR {
	int exterror;
	char class;
	char action;
	char locus;
	};

int dBsize(dbffd, size) /*** error assignment: 1000 ***/
/*---------------------*/
	char   *dbffd;
	RECNUM *size;
{
	DBFFILE *dbfptr;
	extern int _dbfoff();
	extern int _dbcerr;

	
	dbfptr = (DBFFILE *) dbffd;

	if (_dbfoff(dbfptr)) {
		return(1);
	}

	switch (dbfptr->_dbfmode) {
	case 0x01:
	case 0x08:
		*size = dbfptr->_alcnum;
		break;
	case 0x02:
	case 0x04:
		*size = dbfptr->_alcnum + dbfptr->_bfhas;
		break;
	case 0x10: /* for temporary solution */
		*size = dbfptr->_alcnum - dbfptr->_bfhas;
		break;
	default:
		_dbcerr = 1001;
		return(1);
	}
	return(0);
} /* end of dBsize() */

void dBstrcpy(string, adjmode, length, origstr)
/*---------------------------------------------*/

     /* <input parameters> */
     char  adjmode; /* mode of adjustment
                          'r' or 'R' => right-adjusted
                          'l' or 'L' => left-adjusted
                          others     => left-adjusted  */ 
     int   length;   /* length of formatted string */
     char  *origstr; /* original string to be formatted */

     /* <output parameter> */
     char  *string;  /* pointer to a character array where a formatted
                        string will be returned */ 
{
char *cptr;
int i, rlen;

if (!length) return; /* nothing to do */

for (cptr=string, i=length; i--;) *cptr++ = ' '; /* put blanks */

if (adjmode == 'r' || adjmode == 'R')
{
    /* right-adjusted */
    for(rlen=0; *origstr++; rlen++);
    origstr--;
    origstr--;
    
    for(cptr=string + length - 1; rlen-- && length--;) *cptr-- = *origstr--;
}
else
{
    /* left-adjusted */
    for(cptr=string; length-- && *origstr;) *cptr++ = *origstr++;
}

} /* end of dBstrcpy() */

void _copydn(from, to, len)
/*-------------------------*/
	BYTE	 *from, *to;
	U2BYTES len;
{
BYTE *fromptr, *toptr;

if (!len) return;

fromptr = from + (len - 1);
toptr   = to   + (len - 1);

while (len--) *toptr-- = *fromptr--;

} /* end of _copydn() */


/****************************************************************************
* NAME         _copyup
* 
* CALLED BY    _delkey
*
* ABSTRACT     copy up a block of memory to another
*
* DESCRIPTION  This function copies up a block of memory to another.
*	       Typically used to copy a segment of buffer contents to
*	       another buffer.
*	       This is also used to shift up a buffer segment.
*
*****************************************************************************/
void _copyup(from, to, len)
	BYTE	 *from, *to;
	U2BYTES len;
{
	while (len--) *to++ = *from++;

} /* end of _copyup() */


/****************************************************************************
* NAME         _copykey
* 
* CALLED BY    _addkey
*
* ABSTRACT     copy a key
*
* DESCRIPTION  copy key elements, pack and copy them in a memory segment,
*	       e.g, in a buffer.
*
*****************************************************************************/
void _copykey(to, nextblk, recno, key, len)
	BYTE     *to;
	BLKNO    nextblk;
	RECNUM   recno;
	BYTE	 *key;
	U2BYTES len;
{
	*to++ = (BYTE) (nextblk & (BYTE) 0xff);
	*to++ = (BYTE) ((nextblk >> 8) & (BYTE) 0xff);
	*to++ = (BYTE) ((nextblk >> 16) & (BYTE) 0xff);
	*to++ = (BYTE) ((nextblk >> 24) & (BYTE) 0xff);
	*to++ = (BYTE) (recno & (BYTE) 0xff);
	*to++ = (BYTE) ((recno >> 8) & (BYTE) 0xff);
	*to++ = (BYTE) ((recno >> 16) & (BYTE) 0xff);
	*to++ = (BYTE) ((recno >> 24) & (BYTE) 0xff);
	while (len--) *to++ = *key++;
} /* end of _copykey() */

int _nkeycomp(key1, key2, len)
/*-----------------------------*/
	BYTE *key1, *key2;
	U2BYTES len;
{
double left=0.0, right=0.0;
BYTE *cptr;
int i;

cptr = (BYTE *) &left;
for (i=1; i<=8; i++) *cptr++ = *key1++;
cptr = (BYTE *) &right;
for (i=1; i<=8; i++) *cptr++ = *key2++;
if (left > right) return(2);
if (left == right) return(1);
return(0);

} /* end of _nkeycomp() */
int _comparek(key1, key2, len)
	BYTE *key1, *key2;
	U2BYTES len;
{
	while (len--) {
		if (*key1 < *key2) return(0);
		if (*key1 > *key2) return(2);
		key1++;
		key2++;
	}
	return(1);
} /* end of _comparek() */

int _rdblk(ndxptr, thisblk) /*** error assignment: 2700 ***/
/*--------------------------*/
	NDXFILE  *ndxptr;
	BLKNO    thisblk;
{
BYTE   *cptr;
BLKNO  checkblk;
extern long lseek();
extern int read(), write();
extern NBYTES _nbytes();
extern char *malloc();
extern int _dbcerr;

if (ndxptr->_svptr->_nxblkno != thisblk)
{
	if (ndxptr->_svptr->_nxusage & 0x1e)
	{
		/* then, physically write */
		cptr = ndxptr->_svptr->_nxbfptr;

		/* nextblk check */
		checkblk = (BLKNO) _nbytes(cptr + 4);
		if (checkblk && (*cptr > 1)) *cptr -= 1;

		if (lseek(ndxptr->_ndxfn,
			  (long) ndxptr->_svptr->_nxblkno * 512,
			   0) == -1L)
		{		_dbcerr = 2701;
				return(1);
		}
		if (write(ndxptr->_ndxfn,
			  ndxptr->_svptr->_nxbfptr, 512) != 512)
		{
			_dbcerr = 2702;
			return(4);
		}
	}
	if (!ndxptr->_svptr->_nxbfptr)
	{
		if ( !(ndxptr->_svptr->_nxbfptr
		       = malloc( (U2BYTES) 512) ) )
		{
			_dbcerr = 2703;
			return(1);
		}
	}
	if (lseek(ndxptr->_ndxfn, (long) thisblk * 512, 0) == -1L)
	{
		_dbcerr = 2704;
		return(1);
	}
	if (read(ndxptr->_ndxfn, ndxptr->_svptr->_nxbfptr, 512) != 512)
	{
		_dbcerr = 2705;
		return(1);
	}
	ndxptr->_svptr->_nxblkno = thisblk;
	ndxptr->_svptr->_nxidno  = 1;

	/* nextblk check */
	cptr = ndxptr->_svptr->_nxbfptr;
 	checkblk = (BLKNO) _nbytes(cptr + 4);
	if (checkblk && *cptr) *cptr += 1;
	ndxptr->_svptr->_nxusage = 0x01;
	if (ndxptr->_endofsv < ndxptr->_svptr)
		ndxptr->_endofsv = ndxptr->_svptr;
}

return(0);
} /* end of _rdblk() */

int _scrasc(ascii, start, inputlen, decplace)
/*-------------------------------------------*/
	char *ascii;
	char **start;
	int  *inputlen;
	int  *decplace;
{
int foundig, posflag, negflag, zeroflag;
int ilen, dec;
char *digptr, digit;

digptr = ascii;
while (*digptr++ == ' '); /* skip leading blanks */
digptr--;
if (!*digptr) return(1);

ilen = dec = 0;
zeroflag = 1;
foundig = posflag = negflag = 0;

while (digit = *digptr++) {
	if (digptr > ascii + 64) return(1); /* too long */
	if (digit > '9') return(1);
	if (digit == '0') {
		if (!foundig) continue; /* screen out leading zero */
	} else if (digit >= '1') {
		zeroflag = 0;
		if (!foundig) {
			foundig = 1;
			*start = digptr - 1;
		}
	}
	else if (digit == '.') {
		if (dec) return(1);
		if (*(digptr - 2) == '-') return(1);
		if ((*(digptr - 2) == '0') && !ilen) ilen = 1;
		if (*digptr == 0) {
			if (!ilen) return(1);
			break; /* get out of loop */
		}
		dec = ilen + 1;
		if (!foundig) {
			foundig = 1;
			*start = digptr - 2;
		}
	}
	else if (digit == '-') {
		if (negflag) return(1);
		foundig = negflag = 1;
		*start = digptr - 1;
	}
	else if (digit == '+') {
		if (posflag) return(1);
		posflag = 1;
		continue; /* '+' is not counted as part of length */
	}
	else return(1); /* illegal input character */

	ilen++;

} /* end of while-loop */

*inputlen = (zeroflag) ? 0 : ilen;
*decplace = (dec) ? ilen - dec : 0;

return(0);

} /* end of _scrasc() */

NBYTES _nbytes(bufptr)
	BYTE *bufptr;
{
NBYTES number;

number  = (NBYTES) *bufptr++;
number |= ((NBYTES) *bufptr++) << 8;
number |= ((NBYTES) *bufptr++) << 16;
number |= ((NBYTES) *bufptr) << 24;
return(number);
} /* end of _nbytes() */

void _bytesn(var, cptr)
	NBYTES var;
	char   *cptr;
{
	*cptr++ = (BYTE) (var & (BYTE) 0xff);
  	*cptr++ = (BYTE) ((var >> 8) & (BYTE) 0xff);
	*cptr++ = (BYTE) ((var >> 16) & (BYTE) 0xff);
	*cptr   = (BYTE) ((var >> 24) & (BYTE) 0xff);
} /* end of _bytesn() */


void _errrls(ndxptr)
	NDXFILE *ndxptr;
{
while (ndxptr->_svector <= ndxptr->_endofsv)
{
	ndxptr->_endofsv->_nxblkno = (BLKNO) 0;
	ndxptr->_endofsv->_nxidno = 0;
	if (ndxptr->_endofsv->_nxbfptr) 
		free(ndxptr->_endofsv->_nxbfptr);
	ndxptr->_endofsv->_nxbfptr = (char *) 0;
	ndxptr->_endofsv->_nxusage = 0x00;
	ndxptr->_endofsv--;
}
ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage |= 0x80;
} /* end of _errrls() */

void _curdate(month, day, year)
	BYTE *month, *day, *year;
{
union REGS reg;
extern int intdos();
	reg.x.ax = 0x2a00;
	intdos(&reg, &reg);
	*year  = (BYTE) ((reg.x.cx - 1900) & (BYTE) 0xff);	/* year  */
	*month = (BYTE) ((reg.x.dx >> 8) & (BYTE) 0xff);	/* month */
	*day   = (BYTE) (reg.x.dx & (BYTE) 0xff);		/* day   */
} /* end of _curdate() */

