/*--->  dBsemaph.ac -- assembly language functions to handle <---*/
/*--->  NOVELL semaphore calls (INT 21H, function C5H)       <---*/
/*--->                     MI-SOFT                           <---*/


int s_open(name,value,handle)
/*
 *	Opens a semaphore with the given name and initial value.
 *	The return value is the completion code, 00H if OK
 */
char	 *name;			/* the name of the semaphore	*/
unsigned value;			/* the initial value		*/
char	 *handle;		/* address of the handle	*/

{
#asm

sname	equ	4[bp]
value	equ	6[bp]
handle equ	8[bp]

	push	si
	push	di

	mov	ah,0C5H			; semaphore function
	mov	al,00H			; open a semaphore
	mov	dx,sname		; points to the name
	xor	cx,cx
	mov	cl,value		; initial value

	int	21H

	mov	bh,00H			; clear the unused byte
	mov	ah,00H			; clear the unused byte

	mov	si,handle
	mov	[si],cx 		; semaphore handle
	mov	[si+2],dx		; semaphore handle

	pop	di
	pop	si

#endasm
}



int s_exam(handle,value)
/*
 *	Examines the semaphore, indentified by the handle
 *	Returns the competion code, 00H if OK
 */
char *handle;			/* points to the handle-structure	*/
int  *value;			/* address of the semaphore value	*/

{
#asm

handle	equ	4[bp]
value	equ	6[bp]

	push	si
	push	di

	mov	ah,0C5H			; semaphore function
	mov	al,01H			; examine a semaphore

	mov	si,handle		; load the handle to CX,DX
	mov	cx,[si]
	mov	dx,[si+2]

	int	21H

	mov	dh,00H			; clear the unused byte
	mov	ah,00H			; clear the unused byte

	mov	si,value		; return the semaphore value
	mov	[si],cx

	pop	di
	pop	si

#endasm
}



int s_wait(handle,timeout)
/*
 *	Decrements the the semaphore value and checks
 *	whether it is negative. If negative, waits timeout
 *	times or till the semaphore will be freed.
 *	When returns, the semaphore value will be incremented.
 *	Returns the completion code, 00H if OK
 */
char *handle;			/* address of the semaphore handle	*/
int  timeout;			/* the time to wait			*/

{
#asm

handle	equ	4[bp]
time	equ	6[bp]

	push	si
	push	di

	mov	ah,0C5H			; semaphore function
	mov	al,02H			; wait for a semaphore

	mov	si,handle		; load the handle to CX,DX
	mov	cx,[si]
	mov	dx,[si+2]

	mov	bp,[time]		; time out value

	int	21H

	mov	ah,00H			; clear the unused byte

	pop	di
	pop	si

#endasm
}



s_sign(handle)
/*
 *	This call increments the semaphore value. If the value
 *	becomes positive, then the next wait call will succeed.
 *	The function returns the completion code, 00H if OK
 */
char *handle;			/* points to the semaphore handle*/

{
#asm

handle	equ	4[bp]

	push	si
	push	di

	mov	ah,0C5H			; semaphore function
	mov	al,03H			; signal a semaphore

	mov	si,handle		; load the handle to CX,DX
	mov	cx,[si]
	mov	dx,[si+2]

	int	21H

	mov	ah,00H			; clear the unused byte

	pop	di
	pop	si

#endasm
}



s_close(handle)
/*
 *	Decrements the open count of the semaphore
 */
char *handle;			/* points to the semaphore handle*/

{
#asm

handle	equ	4[bp]

	push	si
	push	di

	mov	ah,0C5H			; semaphore function
	mov	al,04H			; close a semaphore

	mov	si,handle		; load the handle to CX,DX
	mov	cx,[si]
	mov	dx,[si+2]

	int	21H

	mov	ah,00H			; clear the unused byte

	pop	di
	pop	si

#endasm
}




int log_rec(record)
/*
 *	Logs and locks the record excusievly
 */

char	*record;		/* record name		*/

{
#asm

rec	equ	4[bp]

	mov	ah,0d0h
	mov	al,01h
	mov	dx,rec		; a rekord neve
	mov	bp,00h

	int	21H

	mov	ah,00H

#endasm
}


int clear_rec(record)
/*
 *	Unlocks and unlogs the record
 */
char	*record;		/* record name		*/

{
#asm

rec	equ	4[bp]

	mov	ah,0d4H
	mov	dx,rec

	int	21H

	mov	ah,00H

#endasm
}



int is_network()
/*
 *	Checks, wheter the system is compatible with
 *	NOVELL NetWare 4.6 or later.
 *	Returns 1, if ok.
 */

{
#asm

	mov	ax,0c601h
	int	21h
	mov	ax,0c602h
	int	21h
	mov	ah,00h

#endasm
}

