/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBKEXPR.C                                          */
/********************************************************/

int dBkexpr(ndxfd, keytype, keyexpr, kexprlen, keylen)
				/*** error assignment: 2500 ***/
	char   *ndxfd;
	char   *keytype;
	char   *keyexpr;
	int    *kexprlen;
	KEYLEN *keylen;
{	
NDXFILE *ndxptr;
char	*buffer, *bufptr;
int     i;
extern char *malloc();
extern int _dbcerr;


ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) {
	return(1);
}

/*** read the header information ***/
/* locate the target block */
if (lseek(ndxptr->_ndxfn, 0L, 0) == -1L) {
	_errrls(ndxptr);
	_dbcerr = 2501;
	return(1);
}

if (!(buffer = malloc((U2BYTES) 0x200))) {
	_errrls(ndxptr);
	_dbcerr	= 2502;
	return(1);
}
bufptr = buffer;

if (read(ndxptr->_ndxfn, bufptr, 0x200) != 0x200) {
	free(buffer);
	_errrls(ndxptr);
	_dbcerr = 2503;
	return(1); /* read failure */
}

*keytype = (ndxptr->_keytype == 0) ? 'C' : 'N';
bufptr += 0x18;

for (i=1; i<=350 && (*keyexpr++ = *bufptr++); i++);
if (i > 350) { /* originally 512 - 10 = 502 */
	free(buffer);
	_errrls(ndxptr);
	_dbcerr = 2504;
	return(5);
}
*kexprlen = i;
*keylen = ndxptr->_keylen;

free(buffer);

return(0);

} /* end of dBkexpr() */
