/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include <fcntl.h>
#include <types.h>
#include <stat.h>
#include <share.h>
#include <io.h>

#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*  DBICREAT.C                                          */
/********************************************************/

int dBicreat(ndxname, keyexpr, keylen, keytype)
			/*** error assignment: 1300 ***/
	char   *ndxname;
	char   *keyexpr;
	KEYLEN keylen;
	char   keytype; /* 'C', 'N' or 'D' */
{
	int fn;    /* file number */
	BYTE *bp, *bufptr;
	int  i;    /* general purpose integer variable */
	BYTE klen;
	extern int _dbcerr;
	extern char *malloc();


	/* check keytype */
	if (keytype >= 'a') keytype -= (BYTE) 0x20;
	if (keytype != 'C' && keytype != 'N' && keytype != 'D')
	{
		_dbcerr = 1301;
		return(1);
	}

	if (keytype == 'C') klen = (BYTE) keylen;
	else 		    klen = 8;

	if ((klen == 0) || (klen > 100))
	{
		_dbcerr = 1302;
		return(1);
	}

	/* get buffer space for this file */
	if (!(bp = malloc((U2BYTES) 1024)))
	{
		_dbcerr = 1303;
		return(1);
	}
	bufptr = bp;

	for (i=1; i<=1024; i++) *bufptr++ = (BYTE) 0;
	*bp = 0x01; /* root block */
	*(bp + 4) = 0x02; /* eof block */
	*(bp + 0x0c) = klen;
	*(bp + 0x0e) = (512 - 8) / (klen + 8);
	*(bp + 0x10) = (keytype == 'C') ? 0x00 : 0x01;
	*(bp + 0x12) = klen + 8;
	bufptr = bp + 0x18;

	for (i=0; i<451 && (*bufptr++ = *keyexpr++); i++);
	if ((i == 0) || (i >= 450))
	{
		free(bp);
		_dbcerr = 1304;
		return(6);
	}

	_bytesn( (NBYTES) 0, bp + 512); /* initially no keys */

if ((fn =
	sopen(ndxname, O_CREAT|O_TRUNC|O_RDWR|O_BINARY,
			SH_DENYRW,
			S_IREAD|S_IWRITE)) < 0)  {
		free(bp);
		_dbcerr = 1305;
		return(1); /* creation failed */
	}

	/* write the buffer */
	if (write(fn, bp, 1024) != 1024)
	{
		free(bp);
		close(fn);
		_dbcerr = 1306;
		return(4);
	}
	close(fn);
	free(bp);
	return(0);

} /* end of dBicreat() */
