/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBGETR.C                                           */
/********************************************************/

int dBgetr(dbffd, recno, record, status)
	char   *dbffd;
	RECNUM recno;
	char   *record;
	char   *status;
{
	extern int _recread();

	return(_recread(dbffd, recno, 0, record, status));
} /* end of dBgetr() */

int _recread(dbffd, recno, option, record, status)
				/*** error assignment: 400 ***/
	char   *dbffd;
	RECNUM recno;
	int    option;
	char   *record;
	char   *status;
{
int fn; /* file number */
DBFFILE *dbfptr;  
int bufofst; /* buffer offset to read record from buffer */
int readlen; /* length of bytes read by "read()" */
RECNUM size;
RECNUM firstrec;
int rc;
extern long lseek();
extern int dBsize(), dBflush(), read(), _getbuf(), _rlsbuf(), _dbfoff();
extern int _dbcerr;


dbfptr = (DBFFILE *) dbffd;

if (_dbfoff(dbfptr)) return(1);

if ((rc = dBsize(dbffd, &size)) != 0) return(rc);
if ((recno > size) || !recno)
{
	_dbcerr = 401;
	return(3); /* too large record number or zero */
}
fn = dbfptr->_dbffn;
if ((dbfptr->_dbfmode & 0x10) && dbfptr->_bfhas)
{
	if (dBflush(dbffd) != 0)
	{
		_rlsbuf(dbfptr);
		return(4);
	}
}

if (dbfptr->_bfptr && dbfptr->_first <= recno &&
	recno < (dbfptr->_first + dbfptr->_bfhas))
{
		/* preserve the current _dbfmode */
		/* requested record is already in the buffer */
		bufofst = (recno - dbfptr->_first) * dbfptr->_len;
}
else 
{	/* no records have been read yet, or
	  the requested record is not in the buffer */
	if ((dbfptr->_dbfmode & 0x0e) && dbfptr->_bfhas)
	{
		if (dBflush(dbffd) != 0)
		{
			_rlsbuf(dbfptr);
			return(4);
		}
	}

	/* change mode */ 
	dbfptr->_dbfmode = 0x01;

	/* attach read-buffer */
	if (!dbfptr->_bfptr)
	{
		/* attach I/O buffer */
		if (_getbuf( dbfptr->_bufsize, dbfptr ) != 0)
			return(1);
	}

	if (option == 0)
	{
	    firstrec = recno;
	}
	else
	{
	    if (recno <= (RECNUM) dbfptr->_maxnum)
		firstrec = (RECNUM) 1;
	    else
		firstrec= recno - (RECNUM) dbfptr->_maxnum + (RECNUM) 1;
	}
	/*** read records ***/
	/* place needle at the beginning of read segment of the record */
	if (lseek( fn,
	   	   (long) ((dbfptr)->_begdata) + (long) dbfptr->_len * (firstrec - 1),
	   	   0) == -1L)
	{
		_rlsbuf(dbfptr);
		_dbcerr = 402;
		return(1);
	}

	/* then, read one or more records from disk to buffer */
	if ((readlen = read(fn, dbfptr->_bfptr, dbfptr->_bufsize)) == -1)
	{
		_rlsbuf(dbfptr);
		_dbcerr = 403;
		return(1);
	}

	dbfptr->_first = firstrec;
	dbfptr->_bfhas = readlen / dbfptr->_len;

	if (option == 0)
	{
		bufofst = 0;
	}
	else	/* option == PREVIOUS */
	{ 
		if (firstrec == (RECNUM) 1)
		{
			bufofst = dbfptr->_len * (int) (recno - firstrec);
		}
		else
		{
			bufofst = dbfptr->_len * (dbfptr->_bfhas - 1);
		}
	}
}

/* finally read record from buffer */
_copyup(dbfptr->_bfptr + bufofst + 1, record, (U2BYTES) dbfptr->_len - 1);
*status = (*(dbfptr->_bfptr + bufofst) == ' ') ? 0 : 1;
return(0);
} /* end of _recread() */
