/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBGETM.C                                          */
/********************************************************/

int dBgetm(dbtfd, field, memo) /*** error assignment: 400 (4300?)***/
	char   *dbtfd;
	char   *field;
	char   *memo;
{
DBTFILE *dbtptr;
BLKNO f;
char *memoptr, *cptr;
int readlen; /* length of bytes read by "read()" */
int i, j;
U2BYTES mbufsiz;
extern U2BYTES _dbcmsiz;
extern long lseek();
extern int dBsize(), dBflush(), read(), _getbuf(), _rlsbuf(), _dbtoff();
extern int _dbcerr;
extern char *malloc();
/* extern int rlsmem(); */


dbtptr = (DBTFILE *) dbtfd;

if (_dbtoff(dbtptr)) return(1);

f = (BLKNO) 0;
for (i=1; i<=10; i++)
{
	if (*field++ == ' ') continue;
	field--;
	if (*field < '0' || '9' < *field)
	{
		_dbcerr = 4301;
		return(1);
	}
	f = f * 10 + (*field++ - '0');
}

if (lseek(dbtptr->_dbtfn, (long) f * 512, 0) == -1L)
{
	_dbcerr = 4302;
	return(1);
}

if (!(memoptr = malloc((U2BYTES) 512)))
{
	_dbcerr	= 4303;
	return(1);
}

i = 0; /* assume: some data exists */
for (mbufsiz=_dbcmsiz; mbufsiz; )
{
	/* then, read one or more records from disk to buffer */
	if ((readlen = read(dbtptr->_dbtfn, memoptr, 512)) == -1)
	{
		_dbcerr = 4304;
		free(memoptr);
		return(1);
	}

	if (!readlen) i = 1; /* no more data */
	cptr = memoptr;
	for (j=1; j<=readlen && mbufsiz; j++)
	{
		if (*cptr == (BYTE) 0x1a)
		{	/* another 0x1a may follow */
			i = 1; /* end of memo blocks */
			break;
		}
		*memo++ = *cptr++ & (BYTE) 0x7f;
		mbufsiz--;
	}
	if (i)
	{
		/* end of memo blocks or no more data */
		*memo = 0; /* NULL */
		free(memoptr);
		return(0);
	}
}
	
_dbcerr = 4305;
free(memoptr);
return(1); /* shouldn't come down here if the file is good */

} /* end of dBgetm() */
