/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/* DBFLUSH.C                                            */
/********************************************************/

int dBflush(dbffd) /*** error assignment: 1200 ***/
	char *dbffd;
{
extern long lseek();
extern int write(), _shiftdn(), _shiftup(), _dbfoff(), _rlsbuf();
BYTE mode;
long position;
int  size;
int  rc;
DBFFILE *dbfptr;
RECNUM rmblksz;
extern int _dbcerr;


dbfptr = (DBFFILE *) dbffd;

if (_dbfoff(dbfptr)) {
	return(1);
}

if (dbfptr->_bfhas == 0) return(0);

mode = dbfptr->_dbfmode;

size = (int) dbfptr->_bfhas * dbfptr->_len;

if (mode & 0x02) {
 	/* place file pointer at the end of all records allocated */
	if (lseek(dbfptr->_dbffn,
		  (long) ((dbfptr)->_begdata) + (long) dbfptr->_len * dbfptr->_alcnum,
		  0) == -1L) {
		_rlsbuf(dbfptr);
		_dbcerr = 1201;
		return (1);
	}

} else if (mode & 0x04) {
	/* make a space to insert records by shifting down the necessary
	   portion of the disk data */
	if (lseek(dbfptr->_dbffn, (long) ((dbfptr)->_begdata), 0) == -1L) {
		_rlsbuf(dbfptr);
		_dbcerr = 1202;
		return(1);
	}

	position = (long) dbfptr->_len * (dbfptr->_first - 1);
	if ((rc = _shiftdn(dbfptr->_dbffn, position, position,
     		           (long) (dbfptr->_alcnum - (dbfptr->_first - 1))
				  * dbfptr->_len + 1,
		           size)) != 0)
	{
		_rlsbuf(dbfptr);
		return(rc);
	}
} else if (mode & 0x08) {
	/* place file pointer at the record to be updated */
	if (lseek(dbfptr->_dbffn,
	       (long) ((dbfptr)->_begdata) + (long) dbfptr->_len * (dbfptr->_first - 1),
	       0) == -1L) {
		_rlsbuf(dbfptr);
		_dbcerr = 1203;
		return(1);
	}

} else if (mode & 0x10) {
	/* remove records */
	rmblksz = dbfptr->_first - 1 + dbfptr->_bfhas;
	if (lseek(dbfptr->_dbffn, (long) ((dbfptr)->_begdata), 0) == -1L) {
		_rlsbuf(dbfptr);
		_dbcerr = 1204;
		return(1);
	}

	position = (long) dbfptr->_len * rmblksz;

	if ((rc = _shiftup(dbfptr->_dbffn, position, position,
             	       (long) (dbfptr->_alcnum - rmblksz) * dbfptr->_len + 1,
     		       size)) != 0)
	{
			_rlsbuf(dbfptr);
			return(rc);
	}
} else if (mode & 0x01) return(0);
else {
	_rlsbuf(dbfptr);
	_dbcerr = 1205;
	return(1);
}

if (mode & 0x0e) {
	if (mode & 0x02) {
		*(dbfptr->_bfptr + size) = 0x1a;
		size += 1;
	}

	if (write(dbfptr->_dbffn, dbfptr->_bfptr, size) != size) {
		_rlsbuf(dbfptr);
		_dbcerr = 1206;
		return(4);
	}
}

if (mode & 0x10) dbfptr->_alcnum -= dbfptr->_bfhas;
else if (mode != 0x08) dbfptr->_alcnum += dbfptr->_bfhas;

dbfptr->_first = (RECNUM) 0;
dbfptr->_bfhas = 0;
dbfptr->_dbfupd = 1; /* indicate .DBF file has been updated */

return(_writedhead(dbfptr));		/* MI-SOFT	*/
} /* end of dBflush() */


static int _shiftdn(fn, curtoblk, curtostp, blksize, sftsize)

             /*<input parameter>*/
	     int  fn;	    /* file descriptor */
             long curtoblk; /* distance from current position to beginning
		               of block to be shifted */
	     long curtostp; /* distance from current position to a desired
		               stop position */
	     long blksize;  /* size of block to be shifted in bytes */
	     int  sftsize;  /* shift size */

             /*<output parameter>*/
	     /* none */

             /*<return value>*/
             /* SUCCESS:  successfully shifted down
                d_ERROR:  error
		d_WTFAIL: disk-write failure
	      */
{
BYTE *bufptr;
long origloc, here, diskmove, la;
int  rwlen;
extern long lseek();
extern int  read(), write();
/* extern int rlsmem(); */
extern char *malloc();
extern int _dbcerr;

origloc = lseek(fn, 0L, 1);

if (!(bufptr = malloc((U2BYTES) 16384))) {
	_dbcerr = 1210;
	return(1);
}

if ( (long) 16384 > blksize) {
	diskmove = curtoblk;
	rwlen = (int) blksize;
}
else {
	diskmove = curtoblk - 16384 + blksize;
	rwlen = 16384;
}

/* position at the beginning of shifting block */
if (lseek(fn, diskmove, 1) == -1L) {
	free(bufptr);
	_dbcerr = 1211;
	return(1);
}

la = blksize;
while (1) {

	if ((rwlen = read(fn, bufptr, rwlen)) == -1) {
		free(bufptr);
		_dbcerr = 1212;
		return(1);
	}

	if (lseek(fn, (long) (sftsize - rwlen), 1) == -1L) {
		free(bufptr);
		_dbcerr = 1213;
		return(1);
	}

	if (write(fn, bufptr, rwlen) != rwlen) {
		free(bufptr);
		_dbcerr = 1214;
		return(4);
	}

	la -= (long) rwlen;

	if (la <= 0L) break;

	if ( (long) 16384 > la) {
		diskmove = -la - rwlen - sftsize;
		rwlen = (int) la;
	}
	else {
		diskmove = (long) (-rwlen - sftsize - 16384);
		rwlen = 16384;
	}

	if (lseek(fn, diskmove, 1) == -1L) {
		free(bufptr);
		_dbcerr = 1215;
		return(1);
	}

} /* end of while-loop */

free(bufptr);

here = lseek(fn, 0L, 1);

/* bring the disk positioner to a desired stop location */
if (lseek(fn, (long) origloc - here + curtostp, 1) == -1L) {
	_dbcerr = 1216;
	return(1);
}                  /* -(here - origloc) + curtostp */

return(0);

} /* end of _shiftdn() */


/**************************************************************
* NAME		_shiftup	
*
* USED BY	dBflush
*
* ABSTRACT	shift up a block of memory(in disk)
*
* DESCRIPTION	This function shifts up a block of memory in disk.
****************************************************************/
static int _shiftup(fn, curtoblk, curtostp, blksize, sftsize)

             /*<input parameter>*/
	     int  fn;	    /* file descriptor */
             long curtoblk; /* distance from current position to beginning
			       of block to be shifted */
	     long curtostp; /* distance from current position to a desired
			       stop position */
	     long blksize;  /* size of block to be shifted in bytes */
	     int  sftsize;  /* shift size */

             /*<output parameter>*/
	     /* none */

             /*<return value>*/
             /* SUCCESS:  successfully appended
		d_ERROR:  error
		d_WTFAIL: disk-write failure */
{
BYTE *bufptr;
long origloc, here, la;
int rwlen;
extern long lseek();
extern int  read(), write();
/* extern int rlsmem(); */
extern char *malloc();
extern int _dbcerr;


origloc = lseek(fn, 0L, 1);

if (!(bufptr = malloc( (U2BYTES) 16384))) {
	_dbcerr = 1220;
	return(1);
}

if (lseek(fn, (long) curtoblk, 1) == -1L) {
	free(bufptr);
	_dbcerr = 1221;
	return(1);
}

la = blksize;
while ( la > 0L ) {
	if ( (long) 16384 > la) {
		rwlen = (int) la;
	}
	else {
		rwlen = 16384;
	}

	if ((rwlen = read(fn, bufptr, rwlen)) == -1) {
		free(bufptr);
		_dbcerr = 1222;
		return(1);
	}

	if (lseek(fn, (long) -(sftsize + rwlen), 1) == -1L)  {
		free(bufptr);
		_dbcerr = 1223;
		return(1);
	}

	if (write(fn, bufptr, rwlen) != rwlen) {
		free(bufptr);
		_dbcerr = 1224;
		return(4); /* imp. error */
	}

	if (lseek(fn, (long) sftsize, 1) == -1L) {
		free(bufptr);
		_dbcerr = 1225;
		return(1);
	}

	la -= (long) rwlen;
} /* end of while-loop */

free(bufptr);

here = lseek(fn, 0L, 1);

/* bring the disk positioner to a desired stop location */
if (lseek(fn, (long) origloc - here + curtostp, 1) == -1L) {
	_dbcerr = 1226;
	return(1);
}                  /* -(here - origloc) + curtostp */

return(0);
} /* end of _shiftup() */
