/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include <fcntl.h>
#include <types.h>
#include <stat.h>
#include <share.h>
#include <io.h>

#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*  DBREAT.C                                            */
/********************************************************/

int dBcreat(dbfname, nofields, fields) /*** error assignment: 100 ***/
	char    *dbfname;
	FLDNUM  nofields;
	dBFIELD fields[];
{
int fn;    /* file number */
DBFFILE dbffl;
BYTE *bufptr, *cptr;
BYTE fldtype;
int  c;  /* general purpose character variable */
int  i;  /* general purpose integer variable */
RECLEN reclen; /* record length */
U2BYTES firstrec; /* first record address */
extern int _dbcerr;
BYTE memotype;
extern int _getbuf(), _rlsbuf(), strlen(), strcpy();
extern void _curdate();

/* get buffer space for this file */
if (_getbuf(4200, &dbffl) == 1) return(1);

cptr = bufptr = dbffl._bfptr;
for (i=1; i<=0x20; i++) *cptr++ = (char) 0;

_curdate(bufptr + 2, bufptr + 3, bufptr + 1);

/* number of records allocated */
*(bufptr + 4) = 0; /* initially no records allocated */
*(bufptr + 5) = 0;
*(bufptr + 6) = 0;
*(bufptr + 7) = 0;

/*** fill fields ***/
if (nofields == 0) {
	_rlsbuf(&dbffl);
	_dbcerr = 101;
	return(1);
}
if (nofields > 128)
{
	_rlsbuf(&dbffl);
	_dbcerr = 102;
	return(1);
}
bufptr = dbffl._bfptr + 0x20;

reclen = (RECLEN) 0;
for (i=1; i<=nofields; i++, fields++)
{
	cptr = bufptr;
	for (c=1; c<=0x20; c++) *cptr++ = (char) 0;

	/* field name */
	if (strlen(fields->fieldnm) > 10)
	{
		_rlsbuf(&dbffl);
		_dbcerr = 103;
		return(1);
	}
	strcpy(bufptr, fields->fieldnm);

	/* field type */
	memotype = 0;
	fldtype = fields->type & 0x5f; /* toupper() */
	switch(fldtype) {
	case 'C':
	case 'N':
	case 'L':
	case 'D':
		break;
	case 'M':
		memotype = 1;
		break;
	default:
		_rlsbuf(&dbffl);
		_dbcerr = 104;
		return(1);
	}

	*(bufptr + 0xb) = fldtype;

	/* field width */
	if (fldtype == 'L') c = 1;
	else if (fldtype == 'M') c = 10;
	else if (fldtype == 'D') c = 8;
	else c = fields->width;

	if ( (c == 0) || (c > 254) )
	{
		_dbcerr = 105;
		return(1);
	}

	reclen += c;

	if (reclen > (RECLEN) 4000)
	{
		_dbcerr = 106;
		return(1);
	}

	*(bufptr + 0x10) = (BYTE) c;

	/* decimal point */
	*(bufptr + 0x11) = (fldtype == 'N') ? fields->dec : (BYTE) 0;

	bufptr += 0x20;
	
} /* end of for (i=1; nofields; i++) */

*(dbffl._bfptr + 0) = (memotype) ? 0x83 : 0x03; /* file type */

*bufptr++ = 0x0d;
*bufptr++ = (BYTE) 0;
*bufptr++ = 0x1a;

/* first record address */
firstrec = (U2BYTES) (bufptr - dbffl._bfptr) - 1;
bufptr = dbffl._bfptr;
*(bufptr + 8) = (BYTE) (firstrec & (BYTE) 0xff);
*(bufptr + 9) = (BYTE) ((firstrec >> 8) & (BYTE) 0xff);

/* record length */
reclen++; /* 1 byte used for ACTIVE/INACTIVE flag */
*(bufptr + 0x0a) = (BYTE) (reclen & (BYTE) 0xff);
*(bufptr + 0x0b) = (BYTE) ((reclen >> 8) & (BYTE) 0xff);

if ((fn =
	sopen(dbfname, O_CREAT|O_TRUNC|O_RDWR|O_BINARY,
			SH_DENYRW,
			S_IREAD|S_IWRITE)) < 0)  {

	_rlsbuf(&dbffl);
	_dbcerr = 107;
	return(1); /* creation failed */
}

/* write the buffer */
firstrec++;
if (write(fn, dbffl._bfptr, (int) firstrec) != (int) firstrec)
{
	_rlsbuf(&dbffl);
	close(fn);
	_dbcerr = 108;
	return(4);
}

close(fn);
_rlsbuf(&dbffl);
return(0);

} /* end of dBcreat() */
