/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBAKEY.C                                           */
/********************************************************/

extern void _copydn(), _copyup(), _copykey();

/*
 *   dBakey(index file descriptor, key, record number)
 */
int dBakey(ndxfd, key, recno) /*** error assignment: 1600 ***/
	char	 *ndxfd;
	char	 *key;
	RECNUM   recno;
{
int fn; /* file number */
NDXFILE  *ndxptr;  
BYTE     *newbr1, *newbr2;
int rc;


ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) return(1);

fn = ndxptr->_ndxfn;
ndxptr->_ndxmode = 0x06;

ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage &= 0x3f;

newbr1 = newbr2 = (BYTE *) 0;
rc = _addkey(ndxptr, ndxptr->_rootblk, recno, key, &newbr1, &newbr2);

if (newbr1) free(newbr1);
if (newbr2) free(newbr2);

if (rc != 0)
	_errrls(ndxptr);

return(rc);
} /* end of dBakey() */

/****************************************************************************
* NAME         _addkey
* 
* CALLED BY    dBakey
*
* ABSTRACT     add key
*
* DESCRIPTION  This function loacates a block and adds a key in an index file.
*	       If a block is filled with keys, it is split to two brother
*	       blocks.  Its parent blocks are recursively split, if necessary.
*
*****************************************************************************/
static int _addkey(ndxptr, thisblk, recno, key, newbr1, newbr2)
 	NDXFILE  *ndxptr;
	BLKNO    thisblk;
	RECNUM   recno;
	char     *key;
	BYTE	 **newbr1;
	BYTE	 **newbr2;
{
BYTE *blkptr, *bufptr;
BYTE found;
int  foundix;
BYTE keynum, halfknum;
BLKNO nextblk;  /* non-0: this block contains keys and associated record #
		       0: this block contains indices to another block      */
BYTE *nubr1, *nubr2;
BYTE *tempcp;
BYTE *secondbp, *lastbp1, *lastbp2;
BYTE adamblk; /* flag */
struct _seqacc *svp, *endsv;
U2BYTES buf2size;
BYTE bufswap; /* 0: keep current buffer components */
	      /* 1: replace current buffer components with new ones */
int rc;
extern int _dbcerr;
extern NBYTES _nbytes();
int	diff;

if ((diff = ndxptr->_svptr - ndxptr->_svector) > 31)
	{
	printf("Svector tulcsordul: %d\n",diff);
	return(99);
	}

/* read entire block */
if ((rc = _rdblk(ndxptr, thisblk)) != 0)
{
	return(rc);
}
blkptr = ndxptr->_svptr->_nxbfptr;
bufptr = blkptr;

keynum = *bufptr;
bufptr += 4;

nextblk = (keynum) ? ((BLKNO) _nbytes(bufptr)) : (BLKNO) 0;

foundix = _freckey(ndxptr, &bufptr, recno, key, keynum, &found);

ndxptr->_svptr->_nxidno = found ? foundix : (foundix - 1);

if ((found == 1) && !nextblk) return(0); /* the key already exists */

if (keynum)
{
	if (!found)
	{
		nextblk = (BLKNO) _nbytes(bufptr - ndxptr->_kptrlen);
	}
	else 
	{
		/* normal(most) cases */
		nextblk = (BLKNO) _nbytes(bufptr);
	}
}
			
/* at this point, the "bufptr" is pointing to a key that this key is
   interested in */

nubr1 = (BYTE *) 0;
nubr2 = (BYTE *) 0;

if (keynum && nextblk)
{

	/* go down to next level */
	ndxptr->_svptr++;
	rc = _addkey(ndxptr, nextblk, recno, key, &nubr1, &nubr2);
	ndxptr->_svptr--;
	if (rc != 0)
	{
		if (nubr1) free(nubr1);
		if (nubr2) free(nubr2);
		return(rc);
	}

	if (!nubr1) return(0);

	/* "bufptr" is pointing to an index previously positioned by 
	    the "_freckey()" function. */

	/* update an index and/or add new branch in this index block */
	/* At this point, the "bufptr" is pointing to an index
	   that this index is interested in except for the case
	   that this key pointed to by the *nubr1 will become
	   the last index in this block.
	   In such a case, found==FALSE & bufptr is pointing to the next empty
	   slot; hence, bufptr must be decremented by ndxptr->_kptrlen.
	*/

	if (!found)
	{
		/* It is the sign that a key(index) was added to the lower
		   level block and the key was the new last entry in that
		   block.  Hence, that new last key must be recorded in
		   this block. */
		   bufptr -= ndxptr->_kptrlen;
		   foundix--;
		   found = (BYTE) 2; /* practically found this key */
	}

	/* (1) update the existing index */
	_copyup(nubr1, bufptr, (U2BYTES) ndxptr->_kptrlen);
	free(nubr1);
	nubr1 = (BYTE *) 0;

	if (!nubr2)
	{
		/* If nubr2 is attached to a temporary buffer,
		   this block will be written after the index pointed
		   to by nubr2 is added and then written */
		ndxptr->_svptr->_nxusage |= 0x1e;
		return(0);
	}

	/* (2) add the second index:
	       this can be done by the following steps */

	/* simulate recno & key */
	tempcp  = nubr2;
	nextblk =  (BLKNO) _nbytes(tempcp);
	tempcp += 4;
	recno   =  (BLKNO) _nbytes(tempcp);
	tempcp += 4;
	key     = tempcp;

	bufptr += ndxptr->_kptrlen;
	foundix++;
	if (keynum < foundix) found = (BYTE) 0;
}

/* at this point, the key/(index) should be stored in this block,
   if there is a room for this key/(index) */

/* then, do the main business */

if (keynum < ndxptr->_maxknum)
{
	if (found)
	{
		/* insert this key at the middle of this block:
		   shift down to make space for the new key */
		_copydn(bufptr,
			bufptr + ndxptr->_kptrlen,
			(U2BYTES) ndxptr->_kptrlen * (keynum - foundix + 1)
                        + 4); /* "+ PLUSKEY" is for .NDX EOF */
	}

	_copykey(bufptr, nextblk, recno, key, 
		 (U2BYTES) ndxptr->_kptrlen - 8);
	if (!found)
	{
		/* *newbr1 = last index of primary buffer; */
		if (!(*newbr1 = malloc((U2BYTES) ndxptr->_kptrlen)))
		{
			_dbcerr = 1601;
			return(1);
		}
		_copyup(bufptr, *newbr1, (U2BYTES) ndxptr->_kptrlen);
		_bytesn((NBYTES) thisblk, *newbr1);

		bufptr += ndxptr->_kptrlen;
		_bytesn( (BLKNO) 0, bufptr); /* EOF marker for index file */
	}
	else
	{
		*newbr1 = (BYTE *) 0;
	}

	if (nubr2)
	{
		free(nubr2);
		nubr2 = (BYTE *) 0;
	}

	*blkptr = (BYTE) ++keynum;

	ndxptr->_svptr->_nxidno = foundix;
	ndxptr->_svptr->_nxusage |= 0x1e;
	return(0);
}

/************** split and add **********************/
/* there is no room for this key: split the parent block and then
   place this key in an appropriate block */

adamblk = (thisblk == ndxptr->_rootblk);

/* get secondary buffer */
buf2size = (adamblk) ? 1024 : 512;
secondbp = malloc(buf2size);
if (!secondbp)
{
	_dbcerr = 1602;
	return(1);
}

halfknum = ndxptr->_maxknum / 2;

/* copy the second half of keys/indices from the primary buffer */
_copyup(blkptr + 4 + (U2BYTES) halfknum * ndxptr->_kptrlen,
	secondbp + 4,
	(U2BYTES) (keynum - halfknum) * ndxptr->_kptrlen + 4);

_bytesn( (NBYTES) halfknum, blkptr);
_bytesn( (NBYTES) (keynum - halfknum), secondbp);
if (foundix <= halfknum)
{
	/* current buffer remains; temporary buffer will be written */
	bufswap	= 0;
	keynum = halfknum++;
	*blkptr = halfknum;
}
else
{
	/* current buffer is written; temporary buffer replaces I/O buf */
	bufswap = 1;
	keynum = *secondbp;
	foundix -= halfknum;
	bufptr = secondbp + 4 + (foundix - 1) * ndxptr->_kptrlen;
	*secondbp += 1; 
}

/** insert this key at the middle or end-of-record of this block: **/
/* (1) shift down to make space for the new key :
       this shifting may not be desirable or wasteful if bufptr is
       is pointing to the "eof" index(key) in the block
       ((( reminder for future (minor) improvement ))) */
_copydn(bufptr,
	 bufptr + ndxptr->_kptrlen,
	 (U2BYTES) (keynum - foundix + 1) * ndxptr->_kptrlen + 4);

/* (2) insert(append) the input key */
_copykey(bufptr, nextblk, recno, key, (U2BYTES) ndxptr->_kptrlen - 8);
if (nubr2)
{
	free(nubr2);
	nubr2 = (BYTE *) 0;
}
/* update the Adam block, if necessary */
lastbp1 = blkptr + 4 + (U2BYTES) (halfknum - 1) * ndxptr->_kptrlen;
lastbp2 = secondbp + 4 + (U2BYTES) (*secondbp - 1) * ndxptr->_kptrlen;

if (adamblk)
{
	/* the adam block must be added to the second buffer 
	   (space for adam block must be reserved in the 2ndary buffer) */
	bufptr = secondbp + 512; /* bufptr now points to buffered adam */
	*bufptr++ = 1; /* i.e., 2 blocks */
	*bufptr++ = 0;
	*bufptr++ = 0;
	*bufptr++ = 0;
	_copyup(lastbp1, bufptr, (U2BYTES) ndxptr->_kptrlen);
	_bytesn((NBYTES) thisblk, bufptr);
	_copydn(lastbp2, bufptr + ndxptr->_kptrlen,
		(U2BYTES) ndxptr->_kptrlen);
	_bytesn((NBYTES) ndxptr->_eofblk, bufptr + ndxptr->_kptrlen);

	*newbr1 = (BYTE *) 0;
	*newbr2 = (BYTE *) 0;
}
else
{
	/* *newbr1 = last index of primary buffer; */
	/* *newbr2 = last index of secondary buffer; */
	if (!(*newbr1 = malloc((U2BYTES) ndxptr->_kptrlen)))
	{
		free(secondbp);
		_dbcerr = 1603;
		return(1);
	}
	if (!(*newbr2 = malloc((U2BYTES) ndxptr->_kptrlen)))
	{
		free(secondbp);
		_dbcerr = 1604;
		return(1);
	}
	_copyup(lastbp1, *newbr1, (U2BYTES) ndxptr->_kptrlen);
	_bytesn((NBYTES) thisblk, *newbr1);

	_copyup(lastbp2, *newbr2, (U2BYTES) ndxptr->_kptrlen);
	_bytesn((NBYTES) ndxptr->_eofblk, *newbr2);
}

if ( (BLKNO) _nbytes(secondbp + 4) )
{
	*secondbp -= 1;
	found = 1; /* found => now used as a flag: not leaf block */
}
else    found = 0; /*                              leaf block */

if (lseek(ndxptr->_ndxfn, (long) (ndxptr->_eofblk) * 512, 0) == -1L)
{
	free(secondbp);
	_dbcerr = 1605;
	return(1);
}
if (write(ndxptr->_ndxfn, secondbp, buf2size) != buf2size)
{
	free(secondbp);
	_dbcerr	= 1606;
	return(4);
}

if (bufswap)
{
	if ( (BLKNO) _nbytes(blkptr + 4) ) *blkptr -= 1;

	if (lseek(ndxptr->_ndxfn, 
		  (long) (ndxptr->_svptr->_nxblkno) * 512, 0) == -1L)
	{
		free(secondbp);
		_dbcerr = 1607;
 		return(1);
	}
	if (write(ndxptr->_ndxfn, blkptr, 512) != 512)
	{
		free(secondbp);
		_dbcerr = 1608;
		return(4);
	}

	ndxptr->_svptr->_nxblkno = ndxptr->_eofblk;

	if (found)
	{
		*secondbp += 1;
	}
	_copyup(secondbp, ndxptr->_svptr->_nxbfptr, (U2BYTES) 512);
	ndxptr->_svptr->_nxusage = 0x01;
}
else
{
	ndxptr->_svptr->_nxusage |= 0x1e;
}

ndxptr->_svptr->_nxidno = foundix;

if (adamblk)
{
	/* shift I/O buffer to make space for the new adam block */
	svp = ndxptr->_endofsv;
	ndxptr->_endofsv++;
	endsv = ndxptr->_endofsv;
	while (ndxptr->_svector <= svp)
	{
		endsv->_nxblkno = svp->_nxblkno;
		endsv->_nxidno  = svp->_nxidno;
		endsv->_nxbfptr = svp->_nxbfptr;
		endsv->_nxusage = svp->_nxusage;
		endsv--;
		svp--;
	}

	/* adjust root block number */
	ndxptr->_eofblk++;
	ndxptr->_rootblk = ndxptr->_eofblk;

 	/* initialize new root block buffer */
	ndxptr->_svptr = ndxptr->_svector;
	ndxptr->_svptr->_nxblkno = ndxptr->_rootblk;
	ndxptr->_svptr->_nxidno  = (bufswap) ? 2 : 1;
	if (!(ndxptr->_svptr->_nxbfptr = malloc((U2BYTES) 512)))
	{
		free(secondbp);
		_dbcerr = 1609;
		return(1);
        }
	bufptr = secondbp + 512;
	*bufptr	= 2; /* i.e. 2 blocks */
	_copyup(bufptr, ndxptr->_svptr->_nxbfptr, (U2BYTES) 512);
	ndxptr->_svptr->_nxusage = 0x01;
}

free(secondbp);

ndxptr->_eofblk++;

return(0);

} /* end of _addkey() */


/****************************************************************************
* NAME         _freckey
* 
* CALLED BY    _addkey
*
* ABSTRACT     find key in buffer
*
* DESCRIPTION  This function loacates a key in a buffer.
*	       If a there is no key that matches in the buffer, it locates
*	       the input bufptr to the end of buffer and sets the 'found' 
*	       flag to 0; otherwize the 'found' flag is set to 1(exact match)
*              or to 2(no match).
*
*****************************************************************************/

static int _freckey(ndxptr, bufptr, recno, key, keynum, found)
	NDXFILE  *ndxptr;
	BYTE	 **bufptr; /* calling routine sets "*bufptr" to point to the
			      1st byte after 'keynum' in the block buffer */
	RECNUM   recno;
	BYTE	 *key;
	BYTE	 keynum;
	BYTE	 *found;
{
int  complen, rc, i, incrment;
BYTE keytype;
RECNUM rnum;
extern int _comparek(), _nkeycomp();
extern NBYTES _nbytes();

keytype  = ndxptr->_keytype;
complen  = ndxptr->_keylen;
incrment = ndxptr->_kptrlen;

for (i=1; i<=keynum; i++)
{
	if (keytype == 0) 
		rc = _comparek(*bufptr + 8, key, complen);
	else
		rc = _nkeycomp(*bufptr + 8, key, complen);

	switch (rc)
	{
	case 0: /* left less than right */
		/* not found yet: keep searching */
		*bufptr += incrment;
		continue;

	case 2: /* left greater than right */
		/* found the spot to insert */
		*found = 2;
		return(i);

	case 1: /* left equal to right */
		/* found but needs special care */
		rnum = _nbytes(*bufptr + 4);
		if (rnum > recno)
		{ /* found the spot to insert */
		    *found = 2;
		    return(i);
		}
		if (rnum == recno)
		{
		   /* the key and its associated rec. no. already exist */
		   *found = 1;
		   return(i);
		}
		*bufptr += incrment;
		continue;
		   
	default:   /* something is wrong */
		return(1);
	} /* end of switch */
} /* end of for-loop */
*found = 0;
return(i);
} /* end of _freckey() */
