// DATETYPE.CPP                                  A Date tpus tagfggvnyei.
// Fejleszt rendszer : BORLAND C++ 3.1
// Ksztette : Nagy Sndor, GAMF Informatika Tanszk
//              6000 Kecskemt Izski t 10.   Tel : (76) 481-291/175,178

#include <string.h>
#include <stdio.h>
#include "datetype.h"
#include "ext.h"

char *NameOfDays[] = { "Vasrnap", "Htf", "Kedd", "Szerda", "Cstrtk",
		       "Pntek", "Szombat" };

char *NameOfMonth[] = { "","Janur", "Februr", "Mrcius", "prilis", "Mjus",
			"Jnius", "Jlius", "Augusztus", "Szeptember",
			"Oktber", "November", "December" };

Date wDatum;               // Munkavltoz visszatrsi rtk trolshoz.
char StringBuf[30];        // Munkavltoz dtumstring trolshoz.

// A ht napjnak sorszmt adja vissz. 0 = vasrnap, 1 = htf ... stb.

int Date::GetDayOfWeek(){
   return( Round( Frac((JulianDays-JULCONST+5)/7.0)*7 ) );
}

// DateRec-bl Julin dtumot szmol.

long int Date::RecToJul(DateRec Datum){

   int wYear,wMonth;

   if(Datum.Month>2) { wYear=Datum.Year; wMonth=Datum.Month+1; }
      else { wYear=Datum.Year-1; wMonth=Datum.Month+13; }

   return( (long)(365.25*wYear)+(long)(30.6001*wMonth)+Datum.Day+JULCONST );
};

// DateFormat-nak megfelel dtumstringet llt el.

char *Date::CreateDateString(){

   char wStr[15],Sp;
   DateRec wRec;
   int DayNum;

   GetDate(wRec);
   DayNum=GetDayOfWeek();
   Sp=DateFormat.Separator;

   DateFormat.IsLongYear ? sprintf(wStr,"%4d%c",wRec.Year,Sp)
			 : sprintf(wStr,"%2d%c",wRec.Year,Sp);
   strcpy(StringBuf,wStr);

   DateFormat.IsNumMonth ? sprintf(wStr,"%2d%c",wRec.Month,Sp)
			 : sprintf(wStr," %s ",NameOfMonth[wRec.Month]);
   if(DateFormat.IsNumMonth && (wRec.Month<10)) wStr[0]='0';
   strncat(StringBuf,wStr,strlen(wStr));

   sprintf(wStr,"%2d",wRec.Day);
   if((wRec.Day<10)&&(!DateFormat.IsDayName)) wStr[0]='0';
   strncat(StringBuf,wStr,strlen(wStr));

   if(DateFormat.IsDayName){
      sprintf(wStr,"%c %s",Sp,NameOfDays[DayNum]);
      strncat(StringBuf,wStr,strlen(wStr));
   }

   return(StringBuf);

}

// Paramter nlkli konstruktor.

Date::Date(){
   JulianDays=0; SetDateFormat();
}

// Konstruktor, Julin napokkal kell inicializlni.

Date::Date(unsigned long int Napok){
   JulianDays=Napok; SetDateFormat();
}

// Konstruktor, DateRec-kel kell inicializlni.

Date::Date(DateRec Datum){
   JulianDays=RecToJul(Datum); SetDateFormat();
}

// A megjelents formtumt lltja be.

void Date::SetDateFormat(unsigned LongYear, unsigned NumMonth,
			 unsigned DayName,  unsigned Sep     ){

   DateFormat.IsLongYear=LongYear;
   DateFormat.IsNumMonth=NumMonth;
   DateFormat.IsDayName=DayName;
   DateFormat.Separator=Sep;

}

// A dtumot DateRec formtumban adja vissza.

void Date::GetDate(DateRec &Datum){

   long int wYear,wMonth,wDay;

   wDay=JulianDays-JULCONST;
   wYear=(wDay-122.1)/365.25;
   wMonth=(wDay-(long int)(365.25*wYear))/30.6001;

   Datum.Day=wDay-(long)(365.25*wYear)-(long)(30.6001*wMonth);
   if(wMonth>=14) Datum.Month=wMonth-13;
      else Datum.Month=wMonth-1;
   if(Datum.Month>2) Datum.Year=wYear;
      else Datum.Year=wYear+1;

}

// A dtumot DateFormat-nak megfelel stringknt adja vissza.

char *Date::GetDateString(){
   return(CreateDateString());
}

// Az rtkad opertor megvalstsa : rtkads Julin nappal

Date &Date::operator=(long int N){
   JulianDays=N; return (*this);
}

// Az rtkad opertor megvalstsa : rtkads DateRec-kel

Date &Date::operator=(DateRec &wRec){
   JulianDays=RecToJul(wRec); return (*this);
}

// A + opertor megvalstsa : dtum rtk x-nappal val nvelse

Date &Date::operator+(long int x){
   wDatum=*this; wDatum=JulianDays+x; return (wDatum);
}

// A += opertor megvalstsa : dtum rtk N-nappal val nvelse

Date &Date::operator+=(long int N){
   JulianDays+=N; return(*this);
}

// A - opertor megvalstsa : dtum rtk N-nappal val cskkentse

Date &Date::operator-(long int N){
   wDatum=*this; wDatum=wDatum.GetJulDay()-N; return (wDatum);
}

// A - opertor megvalstsa : kt dtum kztt eltelt napok szma

long int Date::operator-(Date& wD){
   return( JulianDays-wD.GetJulDay() );
}

// A -= opertor megvalstsa : dtum rtk N nappal val cskkentse.

Date &Date::operator-=(long int N){
   JulianDays-=N; return(*this);
}

// A ++ opertor megvalstsa : dtum rtk rkvetkezjnek ellltsa.

Date &Date::operator++(){
   ++JulianDays; return (*this);
}

// A -- opertor megvalstsa : dtum rtk megelzjnek ellltsa.

Date &Date::operator--(){
   --JulianDays; return (*this);
}

// A < opertor megvalstsa : kt dtum viszonytsa

int Date::operator<(Date& wD){
   return (JulianDays < wD.GetJulDay() );
}

// A <= opertor megvalstsa : kt dtum viszonytsa

int Date::operator<=(Date& wD){
   return (JulianDays <= wD.GetJulDay() );
}

// A == opertor megvalstsa : kt dtum viszonytsa

int Date::operator==(Date& wD){
   return (JulianDays == wD.GetJulDay() );
}

// A > opertor megvalstsa : kt dtum viszonytsa

int Date::operator>(Date& wD){
   return (JulianDays > wD.GetJulDay() );
}

// A >= opertor megvalstsa : kt dtum viszonytsa

int Date::operator>=(Date& wD){
   return (JulianDays >= wD.GetJulDay() );
}

int Date::operator!=(Date& wD){
   return (JulianDays != wD.GetJulDay() );
}
