#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mem.h>

int *halotab[1001]; // 1-bs, 0: num 1... - utak
int utsz[1001]; // 1-bs
int citnum, utnum;
FILE *f,*g;

void addnewut( int hon, int hova)
{
 if (!halotab[hon])
  {
   halotab[hon]=(int*)calloc(2,sizeof(int));

   halotab[hon][0]=1;
   halotab[hon][1]=hova;
  }
 else
  {
   halotab[hon]=(int *)realloc(halotab[hon],(halotab[hon][0]+2)*sizeof(int));

   halotab[hon][0]++;
   halotab[hon][ halotab[hon][0] ]=hova;
  }
}

int loadroads(void)
{
 char *buf,*p;
 int from,wh;

 fgets(buf,30,f);
 if (feof(f))
  return -1;
 citnum=atoi(strtok(buf," "));
 utnum=atoi(strtok(NULL," "));

 memset(halotab,0,sizeof(int*)*1001);
 while (!feof(f))
  {
   fgets(buf,30,f);
   if (feof(f))
    continue;
   from=atoi(strtok(buf," "));
   wh=atoi(strtok(NULL," "));
   if (from==0 && wh==0)
    break;

   addnewut(from,wh);
   addnewut(wh,from);
  }
 return 0;
}


int farthestfrom( int mt ) // ret: max tav
{
 int c,d,e,f,curlev=0,kilep=0;

 memset(utsz,0,sizeof(int)*1001);
 do
  {
   curlev++;
   kilep=1;
   for (c=1;c<=citnum;c++)
    {
     if (halotab[c]==NULL)
      continue;

     if (utsz[c]!=curlev-1)
      continue;

     for (d=1;d<=halotab[c][0];d++)
      {
       e=halotab[c][d];
       if (utsz[e]==0)
	{
	 utsz[e]=curlev;
	 kilep=0;
	}
      }
     if (curlev==1)
      break;
    }
  }
 while (!kilep);
 return curlev-1;
}

void processcost( void )
{
 int c,d;
 int mtav=-1;

 for (c=1;c<=(citnum/2)+1;c++) // eleg a feleig!?!?
  {
   if ( (d=farthestfrom(c)) > mtav)
    mtav=d;
  }

 fprintf(g,"%ld\n",long(mtav)*100);
}

void freehtab(void)
{
 int c;
 for (c=0;c<citnum;c++)
  if (halotab[c])
   free(halotab[c]);
}

//-----------------------------------------------------------
int main( void )
{
 f=fopen("tolls.in","rt");
 g=fopen("tolls.out","wt");
 do
  {
   if (loadroads())
    break;
   processcost();
   freehtab();
  }
 while (!feof(f));
 fclose(f);
 fclose(g);
 return 0;
}
