#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>
#include <dos.h>
#include <alloc.h>
#include <math.h>;
#include <mem.h>
#include <sys\stat.h>
#include <io.h>

#include "catit.h"
#include "lk_file.h"


/**********************************\
|                                  |
|  __  _____ ____     Class ctf    |
| /  \   |   |                     |
| |      |   |___                  |
| |      |   |                     |
| \__/   |   |                     |
|                                  |
\**********************************/
int  ctf::open( char *elut )
{
 char inb[255];

 if (elut)
  {
   sprintf( inb , "%s\\%s",elut,TITLENEV);
   tfhandle = ::open( inb , O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
  }
 else
   tfhandle = ::open(TITLENEV, O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
 return( 0 );
}

int ctf::close( void )
{
 ::close ( tfhandle );
 return( 0 );
}

int ctf::setpos( long where )
{
 if (where == F_SEEKEND)
  {
   lseek( tfhandle , 0 , SEEK_END );
   return( 0 );
  }

 if (where < 0)
  return( -1 );

 lseek( tfhandle , where * tfrecsize , SEEK_SET);
 return(0);
}

long ctf::getpos( void )
{
 return( (int)(tell(tfhandle) / tfrecsize) );
}

int ctf::eof( void )
{
 return( ::eof(tfhandle) );
}

long ctf::size( void )
{
 return( ::filelength(tfhandle)/tfrecsize );
}

int  ctf::read( struct TitleRType* cim )
{
 TitleType tpt;

 if ( ::read( tfhandle , &tpt , tfrecsize )==-1 )
  return( -1 );

 tpt.sor1[ tpt.sor1hossz-1 ] = '\0';

 cim->disknum=tpt.disknum;
 strcpy((char*)cim->sor1 , (char*)tpt.sor1 );
 cim->created = tpt.created;
 cim->updated = tpt.updated;
 cim->kod = tpt.kod;
 cim->kezd = tpt.kezd;
 cim->veg = tpt.veg;
 cim->free = tpt.free;
 cim->total = tpt.total;
 cim->dataver = tpt.dataver;

 return( 0 );
}

int ctf::write( struct TitleRType* cim )
{
 TitleType tpt;

 tpt.sor1hossz = SORHOSSZ;
 tpt.disknum = cim->disknum;
 strncpy((char*)tpt.sor1 , (char*)cim->sor1 , SORHOSSZ );
 tpt.created = cim->created;
 tpt.updated = cim->updated;
 tpt.kod     = cim->kod;
 tpt.kezd    = cim->kezd;
 tpt.veg     = cim->veg;
 tpt.free    = cim->free;
 tpt.total   = cim->total;
 tpt.dataver = cim->dataver;
 if (tpt.dataver > DVER)  // Rossz a dataver rtke!
  tpt.dataver=0;
 memset( tpt.ures,0,sizeof(tpt.ures) );

 if ( ::write( tfhandle , &tpt , tfrecsize )==-1 )
  return( -1 );

 return( 0 );
}

int ctf::SwapTitle(int h1, int h2 )
{
 TitleType t1,t2;

 lseek(tfhandle,tfrecsize*h1,SEEK_SET);
 if ( ::read( tfhandle , &t1 , tfrecsize )==-1 )
  return( -1 );
 lseek(tfhandle,tfrecsize*h2,SEEK_SET);
 if ( ::read( tfhandle , &t2 , tfrecsize )==-1 )
  return( -1 );

 lseek(tfhandle,tfrecsize*h1,SEEK_SET);
 if ( ::write( tfhandle , &t2 , tfrecsize )==-1 )
  return( -1 );
 lseek(tfhandle,tfrecsize*h2,SEEK_SET);
 if ( ::write( tfhandle , &t1 , tfrecsize )==-1 )
  return( -1 );

 return( 0 );
}

int ctf::TitleMod( int mettol, int levonas)
{
 TitleRType t3;
 int fpos = -1;

 if ( filelength( tfhandle ) < 1 )
  return( -1 );
 if ( levonas <= 0 )
  return( -1 );

 //lseek(cimekfile,0,SEEK_SET);
 setpos( 0 );
 do
  {
   fpos++;
   if ( read( &t3 )==-1 )
    return( -1 );
   if ( t3.kezd > mettol )
    {
     //lseek(cimekfile,t_recsize*fpos,SEEK_SET);
     setpos( fpos );
     t3.kezd-=levonas;
     t3.veg-=levonas;
     if ( write( &t3 )==-1 )
      return( -1 );
    }
  }
 while ( !eof() );

 return( 0 );
}

ctf::ctf( void )
{
 tfrecsize = 118; // CHECK if == sizeof(TitleType);
}

void ctf::DeleteLast( void )
{
 chsize(tfhandle,filelength(tfhandle)-tfrecsize);
}

/*******
void ctf::flush( void )
{
 int duphandle;

 fflush(stream);
 duphandle = dup(fileno(tf_file));
 close(duphandle);
}
*******/

/**********************************\
|                                  |
|  __  ____ ____      Class cff    |
| /  \ |    |                      |
| |    |___ |___                   |
| |    |    |                      |
| \__/ |    |                      |
|                                  |
\**********************************/

int  cff::open( char *elut )
{
 char inb[255];
 int c,zero=0;

 if (elut)
  {
   sprintf( inb , "%s\\%s",elut,FILENEV);
   ffhandle = ::open( inb , O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
   sprintf( inb , "%s\\%s",elut,IDXFILENEV);
   fidx = ::open( inb , O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
   sprintf( inb , "%s\\%s",elut,COMMFILENEV);
   fcomm = ::open( inb , O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
  }
 else
  {
   ffhandle = ::open(FILENEV, O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
   fidx = ::open(IDXFILENEV, O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
   fcomm = ::open(COMMFILENEV, O_BINARY | O_RDWR | O_CREAT , S_IREAD|S_IWRITE);
  }

 if ((filelength(ffhandle)!=0) && (filelength(fidx)==0))
  {
   cprintf("Error: a data file (comments) doesn't exist, creating.");
   for (c=0;c<size();c++)
    {
     ::write(fidx,&zero,sizeof(int));
     if (c%500==0)
      cprintf(".");
    }
   cprintf("\r\n");
  }

 if (filelength(fcomm)==0)
  {
   ::write(fcomm,"-=NOSASOFT CatIT! Comment file=-",commrecsize);
  }

 return( 0 );
}

int cff::close( void )
{
 ::close ( ffhandle );
 ::close ( fidx );
 ::close ( fcomm );
 return( 0 );
}

int cff::setpos( long where )
{
 if (where == F_SEEKEND)
  {
   lseek( ffhandle , 0 , SEEK_END );
   lseek( fidx , 0 , SEEK_END );
   return( 0 );
  }

 if (where < 0)
  return( -1 );

 lseek( ffhandle , where * ffrecsize , SEEK_SET);
 lseek( fidx , where * fidxrecsize , SEEK_SET);
 return(0);
}

long cff::getpos( void )
{
 return( tell(ffhandle) / ffrecsize );
}

int cff::eof( void )
{
 return( ::eof(ffhandle) );
}

long cff::size( void )
{
 return( ::filelength(ffhandle)/ffrecsize );
}

int  cff::read( struct FileRType* files )
{
 FileType* fpt;
 int nidx;

 fpt=(FileType *)malloc(ffrecsize+2);
 if ( ::read( ffhandle , fpt , ffrecsize )==-1 )
  {
   free(fpt);
   return( -1 );
  }

 strncpy((char*)files->name,(char*)fpt->name,12);
 files->name[12]='\0';
 files->size = fpt->size;
 files->time = fpt->time;

 ::read( fidx , &nidx , sizeof(int) );
 files->nidx = nidx;

 free(fpt);
 return( 0 );
}

int cff::write( struct FileRType* files )
{
 FileType tpt;

 strncpy((char *)tpt.name , (char*)files->name , 12 );
 tpt.namehossz=12;
 tpt.time = files->time;
 tpt.size = files->size;


 if ( ::write( ffhandle , &tpt , ffrecsize )==-1 )
  return( -1 );

 if ( ::write( fidx , &files->nidx , sizeof(int) )==-1 )
  return( -1 );

 return( 0 );
}

int  cff::longread( struct FileRType far* files, int num )
{
 FileType far *fpt;
 int far *iit;

 int nidx;
 unsigned xx;
 int c;

 fpt=(FileType far *)farcalloc(num,ffrecsize+2);
 iit=(int far *)farcalloc(num,sizeof(int));
 if ( _dos_read( ffhandle , fpt , ffrecsize*(long)num,&xx )==-1 )
  {
   farfree(fpt);
   farfree(iit);
   return( -1 );
  }
 if ( _dos_read( fidx , iit , fidxrecsize*(long)num,&xx )==-1 )
  {
   farfree(fpt);
   farfree(iit);
   return( -1 );
  }

 for (c=0;c<num;c++)
  {
   _fstrncpy((char far*)files[c].name,(char far*)fpt[c].name,12);
   files[c].name[12]='\0';
   files[c].size = fpt[c].size;
   files[c].time = fpt[c].time;
   files[c].nidx = iit[c];
  }

 farfree(fpt);
 farfree(iit);
 return( 0 );
}

int cff::longwrite( struct FileRType far* files, int num )
{
 FileType far *tpt;
 int far *iit;
 int c;
 unsigned xx;

 tpt=(FileType far *)farcalloc(num,ffrecsize+2);
 iit=(int far *)farcalloc(num,sizeof(int));

 for (c=0;c<num;c++)
  {
   _fstrncpy((char far*)tpt[c].name , (char far*)files[c].name , 12 );
   tpt[c].namehossz=12;
   tpt[c].time = files[c].time;
   tpt[c].size = files[c].size;
   iit[c] = files[c].nidx;
  }

 if ( _dos_write( ffhandle , tpt , (long)num*ffrecsize, &xx )!=0 )
  {
   farfree(tpt);
   farfree(iit);
   return( -1 );
  }

 if ( _dos_write( fidx , iit , fidxrecsize*long(num), &xx )!=0 )
  {
   farfree(tpt);
   farfree(iit);
   return( -1 );
  }

 farfree(tpt);
 farfree(iit);
 return( 0 );
}


/*
int cff::DeleteFiles(int mettol,int meddig)
{
 int deleted,lev;
 FileRType f3;
 long fs;
 long c;

 if (mettol > meddig)
  return ( 0 );

 if ( (fs = (filelength(ffhandle) /  ffrecsize))==0 )
  return( 0 );

 if ( (mettol>size()) || (meddig>size()) ) // Check!
  return( 0 );

 if ( meddig >= fs )
  {
   chsize( ffhandle , ffrecsize*mettol );
   chsize( fidx , fidxrecsize*mettol );
   return( 0 );
  }

 lev = meddig-mettol+1;

 gotoxy(1,wherey());
 clreol();
 cprintf("  0%%");

 for ( c=meddig+1 ; c<=fs-1 ; c++)
  {
   if ( c % 100 == 0 )
    {
     gotoxy(1,wherey());
     cprintf("%3.0lf%%", floor((float)c/fs*100) );
    }
   /*******
   lseek(filesfile,f_recsize*c,SEEK_SET);
   read(filesfile , &f3 , f_recsize );
   lseek(filesfile,f_recsize*(c-lev),SEEK_SET);
   write(filesfile, &f3 , f_recsize );
   *****/
   setpos(c);
   read(&f3);
   setpos(c-lev);
   write(&f3);
  }
 gotoxy(1,wherey());
 cprintf("100%%");

 chsize( ffhandle, ffrecsize*(fs-lev) );
 chsize( fidx, fidxrecsize*(fs-lev) );

 return( lev );
}
*/

int cff::DeleteFiles(int mettol,int meddig)
{
 int deleted,lev;
 FileRType f3;
 long fs;
 long c;

 if (mettol > meddig)
  return ( 0 );

 if ( (fs = (filelength(ffhandle) /  ffrecsize))==0 )
  return( 0 );

 if ( (mettol>size()) || (meddig>size()) ) // Check!
  return( 0 );

 if ( meddig >= fs )
  {
   chsize( ffhandle , ffrecsize*mettol );
   chsize( fidx , fidxrecsize*mettol );
   return( 0 );
  }

 lev = meddig-mettol+1;

 gotoxy(1,wherey());
 clreol();
 cprintf("  0%%");

 int lnum=2000; // mem-tol fugg(nie kellene) (?)
 FileRType far *lt;
 int cnum;

 lt=(FileRType far *)farcalloc(lnum,sizeof(FileRType));

 for ( c=meddig+1 ; c<=fs-1 ; /*c++*/ )
  {
   //if ( c % 100 == 0 )
   // {
     gotoxy(1,wherey());
     cprintf("%3.0lf%%", floor((float)c/fs*100) );
   // }
   /*******
   lseek(filesfile,f_recsize*c,SEEK_SET);
   read(filesfile , &f3 , f_recsize );
   lseek(filesfile,f_recsize*(c-lev),SEEK_SET);
   write(filesfile, &f3 , f_recsize );
   *****/
   //cnum=((fs-1-c)>1000)?1000:(fs-1-c);
   cnum=((fs-c)>1000)?1000:(fs-c);
   if (cnum==0)
    break;
   setpos(c);
   longread(lt,cnum);

   setpos(c-lev);
   longwrite(lt,cnum);
   c+=cnum;
  }
 gotoxy(1,wherey());
 cprintf("100%%");

 chsize( ffhandle, ffrecsize*(fs-lev) );
 chsize( fidx, fidxrecsize*(fs-lev) );

 farfree(lt);

 return( lev );
}


char* cff::commread( int nm, char *buf )
{
 lseek( fcomm,(long)commrecsize*nm,SEEK_SET );
 ::read( fcomm , buf , commrecsize );
 buf[commrecsize]='\0';

 return( buf );
}

int cff::commwrite( int nm, char *buf )
{
 //char b2[81];
 if (nm==-1)
  lseek( fcomm,0,SEEK_END );
 else
  lseek( fcomm,(long)commrecsize*nm,SEEK_SET );
 ::write( fcomm , buf , commrecsize );

 return( 0 );
}

int cff::newcomm( FileRType *fls, char *buf )
{
 int ps;

 lseek( fcomm,0,SEEK_END );
 ps=(tell(fcomm)/commrecsize);
 ::write( fcomm , buf , commrecsize );
 fls->nidx=ps;

 return( ps );
}


cff::cff ( void )
{
 ffrecsize = sizeof(FileType); //21; // !! CHECK if >> sizeof(FileType);
 fidxrecsize = sizeof(int);
 commrecsize = 40; //33; //!!!!!!!!!
}
