#include <bios.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <mem.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys\stat.h>

#include "..\wnd.h"
#include "..\menu.h"
#include "..\screen.h"
#include "..\mouse.h"
#include "catit.h"
#include "ct_data.h"
#include "ct_disp.h"
#include "..\fontload.h"
#include "old\shw_scro.h"


/*----------------------------------------------------------*/
#define XR_ENCODE 1
#define XR_DECODE 2

#define RBx 30
#define RBy  7
#define RBXH 24

char *cropesp2( char *str);
void xrcode( char *buf, int num, int ir );

struct reg_struct
 {
  int val_code; // this has to be 0xAF
  char name[20];
  char company[20];
  date dt;
  struct time tm;
  long sernum;
  char res[15];
  int val_code2; // this has to be 0xAF
 }
  rst;

char reg_identifier[10]={0x0F,0xFF,0xAF,0xC8,0xBA,0xBE,0xAD,0xE4,0x8E,0xFF};
long hiddensnum=0x00000001;
char srname[]="JohnlAF";
/*
char rname[]="John Zero";
char rcompany[]="NOSASOFT";
*/
char rname[20];
char rcompany[20];

/*
  RegNames:   John Zero | NOSASOFT    | 1
	    The Trooper | NOSASOFT    | 2
	    Surnyi     | InterPreter | 3
*/

void reg_sset( long snum )
{
 rst.sernum=snum;
}

long reg_sget( void )
{
 return(rst.sernum);
}

void reg_display( void )
{
 //box(RBx,RBy,RBx+20,RBy+5,Nkeret);
 m_hide();
 textattr(DARKGRAY*16);
 box(RBx+1,RBy+1,RBx+RBXH,RBy+5,"    ");

 textattr(LIGHTGRAY+16*BLUE);
 gotoxy(RBx+1,RBy+1); cprintf("    This program is    ");
 gotoxy(RBx+1,RBy+2); cprintf("     registered to:    ");

 textattr(YELLOW+BLUE*16);
 gotoxy(RBx+1,RBy+3); cprintf("                       ");
 gotoxy(RBx+1,RBy+4); cprintf("                       ");
 gotoxy(RBx+1+(RBXH-strlen(rname))/2,RBy+3); cputs(rname);
 gotoxy(RBx+1+(RBXH-strlen(rcompany))/2,RBy+4); cputs(rcompany);
 m_show();
}

void reg_change( void )
{
 //box(RBx,RBy,RBx+20,RBy+5,Nkeret);
 m_hide();
 textattr(DARKGRAY*16);
 box(RBx+1,RBy+1,RBx+RBXH,RBy+5,"    ");

 textattr(LIGHTGRAY+16*BLUE);
 gotoxy(RBx+1,RBy+1); cprintf("    This program is    ");
 gotoxy(RBx+1,RBy+2); cprintf("     registered to:    ");

 textattr(YELLOW+BLUE*16);
 gotoxy(RBx+1,RBy+3); cprintf("                       ");
 gotoxy(RBx+1,RBy+4); cprintf("                       ");

 gotoxy(RBx+1+1,RBy+3);
 savecolor();
 textattr(WHITE*16);
 readstr(rname,20);
 restorecolor();
 cropesp2(rname);

 if (stricmp(srname,rname)==0)
  {
   reg_write_enable=1;

   gotoxy(RBx+1+1,RBy+3);
   savecolor();
   textattr(WHITE*16);
   readstr(rname,20);
   restorecolor();
   cropesp2(rname);
  }
 gotoxy(RBx+1,RBy+3); cprintf("                       ");
 gotoxy(RBx+1+(RBXH-strlen(rname))/2,RBy+3); cputs(rname);

 gotoxy(RBx+1+1,RBy+4);
 savecolor();
 textattr(WHITE*16);
 readstr(rcompany,20);
 restorecolor();
 cropesp2(rcompany);
 gotoxy(RBx+1,RBy+4); cprintf("                       ");
 gotoxy(RBx+1+(RBXH-strlen(rcompany))/2,RBy+4); cputs(rcompany);
 m_show();
}


int reg_read( char *exef )
{
 int f;
 long l;
 char buf[22];
 int hvolt=0;

 rst.sernum=0;
 DEMOVER=0;
 f=open(exef,O_RDONLY|O_BINARY);
 l=filelength(f);
  lseek(f,l-10,SEEK_SET);
  read(f,buf,10);
  if (memcmp(buf,reg_identifier,10)!=0)
   hvolt=1;

  lseek(f,l-10-sizeof(rst),SEEK_SET);
  read(f,&rst,sizeof(rst));
  xrcode((char *)&rst,sizeof(rst),XR_DECODE);
  //xrcode((char *)&rst,sizeof(rst),XR_ENCODE);
  //xrcode((char *)&rst,sizeof(rst),XR_DECODE);
  if ((rst.val_code!=0xAF)||(rst.val_code2!=0xAF)||(hvolt))
   {
    strcpy(rname,"<shareware>");
    strcpy(rcompany,"<version>");
    DEMOVER=DEMOVER_CONST;
    return(-1);
   }
  strcpy(rname,rst.name);
  strcpy(rcompany,rst.company);
 close(f);
}

int reg_write( char *exef )
{
 int f;
 long l;
 char buf[22];

 f=open(exef,O_RDWR|O_BINARY);
 l=filelength(f);
  strcpy(rst.name,rname);
  strcpy(rst.company,rcompany);
  rst.val_code=0xAF;
  rst.val_code2=0xAF;
  getdate(&rst.dt);
  gettime(&rst.tm);

  //xrcode((char *)&rst,sizeof(rst),XR_ENCODE);
  //xrcode((char *)&rst,sizeof(rst),XR_DECODE);

  lseek(f,l,SEEK_SET);
  xrcode((char *)&rst,sizeof(rst),XR_ENCODE);
  write(f,&rst,sizeof(rst));
  write(f,reg_identifier,10);
 close(f);
}

void xrcode( char *buf, int num, int ir )
{
 int cvals[]={111,-35,207,-11,3,-23,54,-23,13,-17};
 int c,d,e,f;

 if (ir==XR_ENCODE)
  {

   for (c=0;c<num;c++)
    buf[c]=buf[c] + cvals[c%10];
   for (c=0;c<num;c++)
    buf[c]=buf[c] ^ cvals[(c+7)%10];

   e=buf[num-1];
   for (c=num-2;c>0;c--)
    {
     f=buf[c];
     buf[c]+=e;
     e=f;
    }

   for (c=2;c<num;c++)
    buf[c]=buf[c] + buf[c-1]*3 + buf[c-2] + 1;
   for (c=0;c<num;c++)
    buf[c]=buf[c] ^ cvals[(c+3)%10];

  }
 else
  {

   for (c=0;c<num;c++)
    buf[c]=buf[c] ^ cvals[(c+3)%10];
   for (c=num;c>=2;c--)
    buf[c]=buf[c] - buf[c-1]*3 - buf[c-2] - 1;

   e=buf[num-1];
   for (c=num-2;c>0;c--)
    {
     //f=buf[c];
     buf[c]-=e;
     e=buf[c];
    }

   for (c=0;c<num;c++)
    buf[c]=buf[c] ^ cvals[(c+7)%10];
   for (c=0;c<num;c++)
    buf[c]=buf[c] - cvals[c%10];

  }
}

char *cropesp2( char *str)
{
 if (!str)
  return(str);

 //char st2[255];
 char *s2;

 int c;
 while (str[strlen(str)-1]==' ')
  str[strlen(str)-1]=0;

 return(str);
}

