#include <stdio.h>
#include <time.h>
#include <conio.h>

#define TRUE  1
#define FALSE 0

time_t current_time, first_time, last_time;
int current_year, current_mon, current_day;
char *day[] =
{
    "Sunday", "Monday", "Tuesday", "Wednesday",
     "Thursday", "Friday", "Saturday"
};

char *skip_spaces (str)
    char *str;
{
    while (strchr(" .:/-", *str))
    {
        str++;
    }
    return (str);
}

char *separate (str, buf, maxlen)
    char *str, *buf;
{
    /*
     * Delimiter karakterig ('.', ':', ' ', '/', '-') kimsolja az str-bl a
     * karaktereket a buf-ba, majd 0-val lezrja a buf-ot. Ha a buf
     * nagyobb lenne, mint maxlen, akkor 0-val tr vissza.
     */
    int i;

    str = skip_spaces (str);
    *buf = 0;
    for (i=0; i<maxlen; i++)
    {
        switch (*str)
        {
            case '.':
            case ':':
            case ' ':
            case '/':
            case '-':
                *buf = 0;
                str++;
                return (str);
            default:
                *buf++ = *str++;
        }
    }
    *buf = 0;
    return (NULL);
}

char *actual (line)
    char *line;
{
    /*
     * Megllaptja, hogy a sor aktulis-e. Ha igen, visszatr a szvegmez
     * cmvel, ha nem, akkor NULL-al.
     */
    char buf[20];
    int n, first_time, last_time, current_time;

    line = separate (line, buf, 18);
    if (strnicmp (buf, ";",1) == 0)
     return( NULL );

    n = atoi (buf);
    if (strcmp (buf, "*") == NULL)
        n = current_year;
    first_time = n*365;
    line = separate (line, buf, 18);
    n = atoi (buf);
    if (strcmp (buf, "*") == NULL)
        n = current_mon;
    first_time += n*31;
    line = separate (line, buf, 18);
    n = atoi (buf);
    if (strcmp (buf, "*") == NULL)
        n = current_day;
    first_time += n;
    line = separate (line, buf, 18);
    n = atoi (buf);
    if (strcmp (buf, "*") == NULL)
        n = current_year;
    last_time = n*365;
    line = separate (line, buf, 18);
    n = atoi (buf);
    if (strcmp (buf, "*") == NULL)
        n = current_mon;
    last_time += n*31;
    line = separate (line, buf, 18);
    n = atoi (buf);
    if (strcmp (buf, "*") == NULL)
        n = current_day;
    last_time += n;

    current_time = 365*current_year+31*current_mon+current_day;
    if (first_time <= current_time && current_time <= last_time)
    {
        line = skip_spaces (line);
        return (line);
    }
    return (NULL);
}

main (argc, argv)
    int argc;
    char *argv[];
{
    char filename[30], line[120], *str;
    int empty;
    struct tm *tp;
    FILE *fp;

    if (argc < 2)
    {
	strcpy (filename, "CALENDAR.CAL");
    }
    else
    {
        strcpy (filename, argv[1]);
    }
    if ( (strstr(filename,"/h")!=NULL) ||
         (strstr(filename,"?")!=NULL))
    {
	printf ("Calendar 2.2 \n");
        printf ("Use: CALENDAR [filename]\n");
        printf ("The default filename is 'CALENDAR.CAL'\n");
        printf ("The structure of the calendar-file:\n");
        printf ("year.mon.day - year.mon.day: Message\n");
        printf ("  or , for a comment :\n");
        printf ("; comment \n");
        printf ("You can substitute the non-significant data with a '*'.\n");
        exit (0);
    }
    fp = fopen (filename, "r");
    if (fp == NULL)
    {
        printf ("'%s' file is not exist\n", filename);
        exit (-1);
    }
    time (&current_time);
    tp = localtime (&current_time);
	printf ("Calendar 2.2\nCurrent date: 19%02d.%02d.%02d. %s\n",
        tp->tm_year, tp->tm_mon+1, tp->tm_mday, day[tp->tm_wday]);
    current_year = 1900 + tp->tm_year;
    current_mon = 1 + tp->tm_mon;
    current_day = tp->tm_mday;
    empty = TRUE;
    printf (" ͻ\n");
    while (fgets(line, 100, fp))
    {
        str = actual (line);
        if (str)
          {
              str[strlen(str)-1] = 0;
     			printf ("  %-74s \n", str);
              empty = FALSE;
          }
    }
    if (empty)
		printf ("  Nincs semmi esemny...                                                     \n");
	printf (" ͼ\n");
    fclose (fp);
    return( 0 );
}
