.286

faddress	equ	500h			;Address of fly-data
flynum		equ	40			;Number of flies

code		segment	byte public
		assume	cs:code, ds:code


		org	100h

start:
		push	cs
		pop	ds
		cld
		mov	ax,0A000h
		mov	es,ax
		mov	ax,13h
		int	10h

		mov	ah,0			; Read the clock
		int	1Ah
		mov	rseed,dx		; Init random seed

		mov	cx,flynum
		mov	bx,faddress
feltolt:
		mov	al,6
		call	random
		mov	[bx],ax			;x
		mov	al,6
		call	random
		mov	[bx+2],ax		;y
		mov	word ptr [bx+8],0	;path-len
		add	bx,0Ah			;next fly
		loop	feltolt

;------------------------------------ MAIN LOOP ----------------------
mainloop:
		mov	dx,3DAh			;RETRACE
w1:
		in	al,dx			; port 3DAh, CGA/EGA vid status
		test	al,8
		jnz	w1			; Jump if not zero
w2:
		in	al,dx			; port 3DAh, CGA/EGA vid status
		test	al,8
		jz	w2			; Jump if zero
		mov	bx,faddress
		mov	cx,flynum

flyloop:
		push	cx
		dec	word ptr [bx+8]
		jns	tovabbmegy
		mov	al,8			;Iranytvalt!
		call	random
		mov	[bx+4],ax		;vx
		mov	al,8
		call	random
		mov	[bx+6],ax		;vy
		mov	al,8
		call	random
		and	ax,1Fh
		add	ax,20h
		mov	[bx+8],ax		;length
tovabbmegy:
		mov	cx,[bx]			;A trlshez!
		mov	dx,[bx+2]

		mov	ax,[bx+4]		;x+=vx
		add	[bx],ax
		mov	si,[bx]
		cmp	si,-150*64
		jl	fordx
		cmp	si,150*64
		jle	nemfordx
fordx:
		neg	word ptr [bx+4]		;Visszapattan
nemfordx:
		mov	ax,[bx+6]		;y+=vy
		add	[bx+2],ax
		mov	di,[bx+2]
		cmp	di,-64*90
		jl	fordy
		cmp	di,64*90
		jle	nemfordy
fordy:
		neg	word ptr [bx+6]		;Visszapattan
nemfordy:
		mov	al,0			;Black->erase old
		call	putpixel
		mov	cx,si
		mov	dx,di
		mov	al,0Fh			;White->draw fly
		call	putpixel
		add	bx,0Ah			;Next fly
		pop	cx
		loop	flyloop			; Loop if cx > 0

		mov	ah,1
		int	16h			; Keyboard i/o  ah=function 01h
						;  get status, if zf=0  al=char
		jnz	vege			; Jump if zero
		jmp	mainloop
vege:
		sub	ah,ah
		int	16h			; Keyboard i/o  ah=function 00h
						;  get keybd char in al, ah=scan
		mov	ax,3
		int	10h			; Video display   ah=functn 00h
						;  set display mode in al
		int	20h			; DOS program terminate

;

putpixel:
		pusha
		sar	cx,6
		add	cx,160
		sar	dx,6
		add	dx,100
		mov	di,dx
		shl	di,2
		add	di,dx
		shl	di,6
		add	di,cx
		stosb
		popa
		ret		

kisrnd:
		mov	ax,rseed
		test	ah,80h
		jz	nagybit			; Jump if zero
		xor	ax,16h
		stc				; Set carry flag
		rcl	ax,1			; Rotate thru carry
		jmp	nemshl
nagybit:
		shl	ax,1			; Shift w/zeros fill
nemshl:
		mov	rseed,ax
		ret


random:					;GET RANDOM NUMBER
		push	bx
		push	cx
		mov	cl,al
		call	kisrnd
		mov	bx,ax
		rol	bx,05
		call	kisrnd
		xor	bx,ax
		rol	bx,05
		call	kisrnd
		xor	ax,bx
		sar	ax,cl
		pop	cx
		pop	bx
		ret

rseed		dw	0FFFFh


code		ends
	end	start
