CR	EQU	13
LF	EQU	10

.MODEL SMALL

.CODE

	public WRITE_HEX
;----------------------------------
; Kir egy byte-ot HEX alakban
;  Be:  DL - amit ki kell rni
;  Ki:  -
; Hv: WRITE_HEX_DIGIT
;----------------------------------
WRITE_HEX PROC
	PUSH	CX			; Trolja a regisztereket
	PUSH	DX
	MOV	DH,DL
	MOV	CX,4			; Nggyel jobbra
	SHR	DL,CL
	CALL	WRITE_HEX_DIGIT		; Kirjuk
	MOV	DL,DH			; DH DL-be
	AND	DL,0Fh			; DL fels bitngyes 0-ra
	CALL	WRITE_HEX_DIGIT		; Kirjuk
	POP	DX			;Regiszterek vissza
	POP	CX
	RET
WRITE_HEX ENDP

	PUBLIC	WRITE_DECIMAL
;----------------------------------
;  Egy 16 bites eljel nlkli szmot r ki
;    decimlis alakban
;  Be: DX - a szm
;  Ki: -
; Hv: WRITE_HEX_DIGIT
;----------------------------------
WRITE_DECIMAL PROC
	PUSH	AX			; Regiszterek verembe
	PUSH	CX
	PUSH	DX
	PUSH	SI
	MOV	AX,DX			; A szm AH-ba
	MOV	SI,10			; 10-zel fogunk osztani
	XOR	CX,CX			; A verembe rakott szmok szma
NON_ZERO:
	XOR	DX,DX			; N fels szava 0-ra
	DIV	SI			; N/10 s (N mod 10)
	PUSH	DX			; Egy szmjegy a verembe
	INC	CX			; Szmll++
	OR	AX,AX			; N=0 ?
	JNE	NON_ZERO		; Ha nem, akkor folytatjuk
WRITE_DIGIT_LOOP:
	POP	DX			; Egy szmjegy kiszedse a verembl
	CALL	WRITE_HEX_DIGIT		; Kirjuk
	LOOP	WRITE_DIGIT_LOOP	; Ismteljk, amg CX 0 nem lesz
END_DECIMAL:
	POP	SI			; Mindent vissza
	POP	DX
	POP	CX
	POP	AX
	RET
WRITE_DECIMAL ENDP

	PUBLIC	WRITE_HEX_DIGIT
;----------------------------------
;  DL als ngy bitjt HEX szmjegyknt kirja
;  Be: DL
;  Ki: -
; Hv: WRITE_CHAR
;----------------------------------
WRITE_HEX_DIGIT PROC
	PUSH	DX			; Regiszterek verembe
	CMP	DL,10			; DL sszehasonltha 10-zel
	JAE	HEX_LETTER		; Ha DL>=10, akkor HEXDIGIT
	ADD	DL,"0"			; Egybknt karaktert csinlunk belle
	JMP	Short WRITE_DIGIT	; s kirjuk
HEX_LETTER:
	ADD	DL,"A"-10		; Karaktert csinlunk belle
WRITE_DIGIT:
	CALL	WRITE_CHAR		; Kirjuk !
	POP	DX
	RET
WRITE_HEX_DIGIT ENDP

	PUBLIC	WRITE_CHAR
;----------------------------------
;  Kir egy karaktert a BIOS rutinok segtsgvel,
;   akkor is, ha a kdja 32 alatt van
;  Be: DL - a kirand karakter kdja
;      BL - a kirand karakter attrib-ja
;  Ki: -
; Hv: CURSOR_RIGHT
;----------------------------------
WRITE_CHAR PROC
	PUSH	AX			; Regiszterek verembe
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AH,9			; Karakter-attrib kirsa
	MOV	BH,0			; 0-s oldal
	;
	MOV	BL,7
	;
	MOV	CX,1			; 1 karaktert runk
	MOV	AL,DL			; Kiirand karakter AL-be
	INT	10h
	CALL	CURSOR_RIGHT		; A kurzort jobbra kell vinni	
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
WRITE_CHAR ENDP

	PUBLIC	SEND_CRLF
;----------------------------------
;  Ez egy CRLF-et kld a kpernyre
;----------------------------------
SEND_CRLF PROC
	PUSH	AX
	PUSH	DX
	MOV	AH,2
	MOV	DL,CR
	INT	21h
	MOV	DL,LF
	INT	21h
	POP	DX
	POP	AX
	RET
SEND_CRLF ENDP

	PUBLIC	CLEAR_SCREEN
;----------------------------------
;  Ez az eljrs trli a kpernyt
;----------------------------------
CLEAR_SCREEN PROC
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	XOR	AL,AL			; ScrollUp-nl trls
	XOR	CX,CX			; Bal fels sarok (0;0)
	MOV	DH,24			; Als sor
	MOV	DL,79			; Utols oszlop
	MOV 	BH,7			; Norml attrib
	MOV	AH,6			; SCROLL-UP
	INT	10h			; Trls
	MOV	DX,0			; Bal-fels sarok
	CALL	GOTO_XY			; Odaviszi a kurzort
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
CLEAR_SCREEN ENDP

	PUBLIC	GOTO_XY
;----------------------------------
;  A kurzort pozcionlja
;  Be: DH - sor (y)
;      DL - oszlop (x)
;  Ki: -
; Hv: -
;----------------------------------
GOTO_XY PROC
	PUSH	AX
	PUSH	BX
	MOV	BH,0			; 0. kpernyoldal
	MOV	AH,2			; SET CURSOR POS szolgltats
	INT	10h			; Odarakja
	POP	BX
	POP	AX
	RET
GOTO_XY ENDP

	PUBLIC	CURSOR_RIGHT
;----------------------------------
;  A kurzort egyel jobbra tolja. Ha 80-on llt,
;    akkor j sorba lp
;  Be: -
;  Ki: -
; Hv: SEND_CRLF
;----------------------------------
CURSOR_RIGHT PROC
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AH,3			; Kurzorpozci olvassa
	MOV	BH,0			; A 0-s oldalon
	INT	10h			; Elolvassa
	MOV	AH,2			; Uj pozci belltsa
	INC	DL			; Egyel jobbra
	CMP	DL,79			; Mg a kpernyn vagyunk?
	JBE	OK			; Ha igen, akkor OK
	CALL	SEND_CRLF		; Ha nem, akkor CRLF,
	JMP	DONE			; s ksz
OK:	INT	10h
DONE:	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
CURSOR_RIGHT ENDP

	PUBLIC	CURSOR_OFF
;----------------------------------
;  Kikapcsolja a kurzort
;----------------------------------
CURSOR_OFF PROC
	PUSH	AX
	PUSH	CX
	MOV	CH,16			; Teteje
	MOV	CL,0			; Allja:
	MOV	AH,1			; Kurzormret llts
	INT	10h
	POP	CX
	POP	AX
	RET
CURSOR_OFF ENDP

	PUBLIC	CURSOR_ON
;----------------------------------
;  Bekapcsolja a kurzort
;----------------------------------
CURSOR_ON PROC
	PUSH	AX
	PUSH	CX
	MOV	CH,11
	MOV	CL,12
	MOV	AH,2
	INT	10h
	POP	CX
	POP	AX
	RET
CURSOR_ON ENDP

	PUBLIC	WRITE_STRING
;----------------------------------
;  Kir egy stringet a kpernyre
;  Be: DS:DX a karekterlnc cme
;  Ki: -
; Hv: WRITE_CHAR
;----------------------------------
WRITE_STRING PROC
	PUSH	AX			; Regiszterek trolsa
	PUSH	DX
	PUSH	SI
	PUSHF				; Irnyjelz trolsa
	CLD				; Irny:nvekzv
	MOV	SI,DX			; Cm az SI-be LODSB-nek
STRING_LOOP:
	LODSB				; Egy karaktert visz AL-be
	OR	AL,AL			; Mr a vgn vagyunk? (0-nl)
	JZ	END_OF_STRING		; Igen, vge van
	MOV	DL,AL			; A karakter DL-be kiiratshoz
	CALL	WRITE_CHAR		; Kirjuk
	JMP	STRING_LOOP
END_OF_STRING:	
	POPF
	POP	SI
	POP	DX
	POP	AX
	RET
WRITE_STRING ENDP

	END