;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;
;>>>> Standard BAssPasC Instructions v1.2 - (C) 1996-98. ESP-team <<<<;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;
;--------------------- TASM, RealMode version ------------------------;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;
.OUT '-=> Loading StdBAPC v1.2 * TASM/RealMode <=-'

;---------------------- UPCASE p1[,p2,p3...] -------------------------
#UPCASE
  IF .NB %?1 THEN
    IF %?1 IN['a'..'z'] DO %?1-=20h
    %< %R UPCASE %*
  ENDIF
ENDM
;--------------------- DOWNCASE p1[,p2,p3...] ------------------------
#DOWNCASE
  IF .NB %?1 THEN
    IF %?1 IN['A'..'Z'] DO %?1+=20h
    %< %R DOWNCASE %*
  ENDIF
ENDM

;------------------------- KEY FUNCTIONS -----------------------------
#WAITKEY=AX:=0//Int 16h
#READKEY:(FLAG NZ)=AH:=1//Int 16h
#READSHIFT:AL=AH:=1//Int 16h

#GETKEY0=Mov AH,0//Int 16h
#GETKEY1=Mov AH,1//Int 16h
#GETKEY2=Mov AH,2//Int 16h

#KEYPRESSED:(FLAG NZ)=AH:=1//Int 16h
#KEYPRESSEDP:(FLAG NZ)=PUSH(AX) AH:=1//Int 16h

;----------------------------- SCREEN -------------------------------
; GOTOXY
; GOTOXY p
; GOTOXY p1,p2
; GOTOXY imm1,imm2
#GOTOXY
  IF %N=1 DO DX:=%?1
  IF %N=2 THEN
    IF .IMM %?1 AND .IMM %?2 DO DX:=256*(%2)+(%1)//ELSE DH:=%2//DL:=%1
  ENDIF
  BH:=0//AH:=2//Int 10h
ENDM

#WHEREXY:DX=AH:=3//BH:=0//Int 10h

;--------------------------- MOUSE -----------------------------------

#MOUSE(AX)=Int 33h               ; MOUSE(cmd)
#EGERBE=MOUSE(1)
#EGERKI=MOUSE(2)
#INITMOUSE:(AX=255)=MOUSE(0)     ; IF INITMOUSE DO mousedriver_available
#RESETMOUSE:INITMOUSE=           ; alias for INITMOUSE
#GETMOUSE:BX=MOUSE(3)            ; returns with button status
#SETMOUSE(CX,DX)=MOUSE(4)        ; SETMOUSE(new_X,new_Y)

;-------------------- OUT[B|W] [p1[,p2,p3...]] -----------------------
#OUTAL=OUT DX,AL
#OUTAX=OUT DX,AX
#OUTB
  IF .NB %?1 DO AL:=%?1
  OUTAL
  IF %N>1 DO %< %R OUTB(%*)
ENDM
#OUTW
  IF .NB %?1 DO AX:=%?1
  OUTAX
  IF %N>1 DO %< %R OUTW(%*)
ENDM

;--------------------------- xxDIR -----------------------------------

;** 'xxDIR'
#MKDIR=DOS 39h
#RMDIR=DOS 3Ah
#CHDIR=DOS 3Bh

;-------------------------- SYSTEM -----------------------------------

#DOSEXIT
  IF .NB %?1
    IF .IMM %?1 DO AX:=4C00h+%?1//ELSE AL:=%?1//AH:=4Ch
  ELSE
    AX:=4C00h
  ENDIF
  DOS
ENDM
#EXIT=DOSEXIT %*  ; alias

#INTCALL=PushF//Call DPT %1
#BIOS(AX)=Int 10h
#ALDIV=DB 0D4h,%1

#WRITESTR
  IF .NB %?1 DO DX:=OFS %?1
  DOS 9
ENDM

#WRITELN=IF %N DO DX:=STROFS %*,13,10,'$'//DOS 9//ELSE WRITECHR 13,10
#WRITE=DX:=STROFS %*,'$'//DOS 9

#POP:%1=POP %*










