;;
;;     PENTIUM CPU INSTRUCTIONS
;;  / ONELINE MACROS FOR BASPASSC /
;;
;;    (c) 1997. BY GYIKSOFT
;;

;========= RDTSC =====================
; tmogatja: 80586-tl (Intel Pentium)
; hatsa: EDX:EAX=rajelek szma RESET ta
;* clks: 6 (iPentium, CPL=0), 11 (iPentium, CPL=1-3)
;* info: instruction can be disabled for CPL=1..3 via CR4.TSD
#RDTSC=DB 0Fh,31h

;=========== CMPXCH8B ===================
; tmogatja: 80586-tl (Intel Pentium)
;* compare & exchange 64 bits, similar to CMPXCHG
#CMPXCH8B=DB 0Fh,0C7h

;============== RSM =====================
; tmogatja: 80586-tl (Intel Pentium)
;* resume from system management mode (only in SMM!)
#RSM=DB 0Fh,0AAh

;============ MOV_EAX,CR4==============
; tmogatja: 80586-tl (Intel Pentium)
;* read the CR4 register value
#MOV_EAX,CR4=DB 0Fh,20h,0E0h

;============ MOV_CR4,EAX==============
; tmogatja: 80586-tl (Intel Pentium)
;* write a value to the CR4 register
#MOV_CR4,EAX=DB 0Fh,22h,0E0h

;============== CPUID ==================
; tmogatja: 80586-tl (s nhny jabb 80486-os)
; megjegyzs: Ha az EFALGS 21. bitje llthat, akkor a CPU tudja a CPUID-et
; bemen paramterek:
;   EAX=0  =>  EAX=max. CPUID-level , EBX+EDX+ECX a gyrt neve (12 karakter)
;   EAX=1  =>  EAX=TFMS , EDX=CPUflags
; lsd. bvebben a CPUID.TXT file-ban
#CPUID(EAX)=DB 0Fh,0A2h

;============== RDMSR ==================
; tmogatja: 80586-tl
;* read a model specific register value
;* in:   ECX      number of the MSR (0..13h on the iPentium)
;* out:  EDX:EAX  value of the MSR (64 bit wide)
;* clks: 20-24 (iPentium)
;* info: instruction can only be used when CPL=0
#RDMSR=DB 0Fh,032h

;============== WRMSR ==================
; tmogatja: 80586-tl
;* write a value to a model specific register
;* in:   ECX      number of the MSR (0..13h on the iPentium)
;*       EDX:EAX  value (64 bit wide)
;* clks: 30-45 (iPentium)
;* info: instruction can only be used when CPL=0 (but some EMMs
;*       like QEMM 7.04 do allow the usage from CPL>0)
#WRMSR=DB 0Fh,030h

