;=================================================;
LABELTYPE_DB=1
LABELTYPE_DW=2
LABELTYPE_DD=4
LABELTYPE_DQ=8
LABELTYPE_DT=10
LABELTYPE_STRUCT=15
LABELTYPE_LABEL=64+0
LABELTYPE_PROC=64+1
LABELTYPE_EQU=64+2
LABELTYPE_EQUJEL=64+3
;=================================================;

CHAR2LT::
CASE AL OF
'B': DL:=LABELTYPE_DB
'W': DL:=LABELTYPE_DW
'D': DL:=LABELTYPE_DD
'Q': DL:=LABELTYPE_DQ
'T': DL:=LABELTYPE_DT
'S': DL:=LABELTYPE_STRUCT
':': DL:=LABELTYPE_LABEL
'P': DL:=LABELTYPE_PROC
'E': DL:=LABELTYPE_EQU
'=': DL:=LABELTYPE_EQUJEL
ELSE
  DL:=0
ENDCASE
RET

;=================================================;

CALC_CRC::
; In: SI->string  CX=length
; Out: BX=CRC10
XOR BX
JCXZ ^SKIP
  PUSH SI,CX
    XOR AH
    ALIGN 2
    ^LOOP:
      LODSB
      ROL BX//BX+=AX
    LOOP ^LOOP
  POP SI,CX
  XOR BL,BH//BX&=HATCH_SIZE-1
^SKIP:
RET

;==============================================================================;

; *** LABEL Block format:

; DW NextLabel
; DB Length
; DB*Length String
; DB Type & Flags
;    0-3.bit = Type/Size
;      6.bit =  1=Label 0=Data
;      7.bit = Unknown
; DD Value
; DB Number of segment (UNUSED if .COM)

;==============================================================================;

HATCH_SEARCH_LABEL::
; In:  SI->LABEL  CX=Length
; Out: DI->TABL[x].TYPE

!CALC_CRC
ADD BX
DI:=HATCH_TABLE[BX]

ALIGN 2
WHILE DI<>-1 DO
  AX:=[ES:DI]
  IF CL<>[ES:DI+2] THEN ^NEXT
  DI+=3
  PUSH(SI,CX) REPZ CMPSB
  JZ ^MEGVAN
^NEXT:
  AX<>DI
ENDWHILE
STC//RET

ALIGN 2
^MEGVAN:
CLC//RET

;==============================================================================;
HATCH_NEW_LABEL::
; In:  SI->LABEL  CX=Length
;      DI->TABL.NEXTLABEL

;PUSH BX

;;!CALC_CRC
;;ADD BX

AX:=HATCH_TABLE[BX]
HATCH_TABLE[BX]:=DI
STOSW

;POP BX
RET
;==============================================================================;
;==============================================================================;

SET_LABEL::
; IN: SI->STRING, AL=TYPE
VAR ^TYPE=DL

IF DPT[SI]='_CPB' DO SI+=3

IF KIIR_MOD THEN
  PUSHA
    WRITE'LABEL: "'//!STR0_PRINT//WRITE'" TYPE: "'
    MOVZX AX,^TYPE//!DECKIIR//WRITELN'"'
  POPA
ENDIF

!STR0_LENGTH

ES:=LABEL_SG
!HATCH_SEARCH_LABEL
IF FLAG C THEN
  ^NINCSMEG:
  ; OK, STORE IT
  DI:=LABEL_MUT
  IF DI>0FF00H THENCMD PUSH(BX) SI->'FATAL! Too many labels found',0//!WRITE_ERROR
  !HATCH_NEW_LABEL ; Insert to HATCH-Table
  STOSB CL
  REP MOVSB
ELSE
  ^MEGVAN:
  IF PASS=1 THEN
    IF NOT BPT [ES:DI]&128 THEN
      IF ^TYPE<>'=' THEN ; Ez tdefinlhat!!
        PUSH(ALL) BX:=SI//SI->'Symbol already defined elsewhere',0//!WRITE_ERROR_CXBX
      ENDIF
    ENDIF
  ENDIF
ENDIF

^NEW:
^OK_TYPE:
AL:=^TYPE
STOSB

IF DI>LABEL_MUT THENCMD LABEL_MUT:=DI//++LABEL_DB

ES=CS
RETC

;==============================================================================;

SEARCH_LABEL::
; IN:  CX=LENGTH  SI->STRING
; OUT: DI->LABEL   DL=LABEL_TYPE
IF DPT[SI]='_CPB' DO SI+=3//CX-=3

IF KIIR_MOD THEN
  PUSHA
    WRITE'SEARCHING LABEL: "'
    LOOP() LODSB//WRITECHR AL
    WRITELN'"'
  POPA
ENDIF

ES:=LABEL_SG
  !HATCH_SEARCH_LABEL
  DL:=[ES:DI]  ; TPUSA!
ES=DS
RET


