;               Structures.
.ASM

ModSample       Struc
msName          db      22 dup (?)
msLength        dw      ?
msFinetune      db      ?
msVolume        db      ?
msRepeat        dw      ?
msRepLen        dw      ?
ModSample       EndS


ModHeader       Struc
mhName          db      20 dup (?)
mhSamples       ModSample 31 dup (?)
mhOrderLen      db      ?
mhReStart       db      ?
mhOrder         db      128 dup (?)
mhSign          dw      ?,?
ModHeader       EndS

.BAP

;               Resources and Data.

{VAR
FileHandle      dw      ?
ErrorInfo       dw      ?
Header          ModHeader ?
}

;               Code.

#DEBUG=;PUSH(FL,ALL) WRITELN %1
#DEBUG2=;PUSH(FL,ALL) WRITE %1
#DEBUG3=;push(ax) !DECKIIR//WRITELN' patterns'
#DEBUG4=;PUSH(ALL) AX:=SMPSIZE//!DECKIIR//WRITELN' total'
#DEBUG5=;PUSH(ALL) AX<>BX//SMPSIZE+=AX//!DECKIIR
CONST SMPSIZE:DW=0

LoadModule      Proc
;;                Arg     FileName: DWord = FrameSize

                pusha
                push    ds
                push    es

                mov     ax,CS
                mov     ds,ax

                mov     [ErrorInfo],1

                call    ClearModInfo

                DEBUG('Open mod file')
OpenFile:       push    ds
                mov     ax,3D00h
;;                lds     dx,[FileName]
                int     21h
                pop     ds
                jc      Failed
                mov     [FileHandle],ax

                DEBUG('Read mod header')
ReadHeader:     mov     ax,3F00h
                mov     bx,[FileHandle]
                mov     cx,Size ModHeader
                lea     dx,[Header]
                int     21h
                jc      CloseFile

  AX:=Header.mhSign
  CX:=Header.mhSign[2]
Const TrackDb:DW=4
IF AX='.M' AND CX='.K' THEN IsModFile
IF AX='!M' AND CX='!K' THEN IsModFile
IF AX='LF' THEN
  IF CX='4T' THEN IsModFile
  IF CX='8T' THEN ^8CH
ENDIF
IF CX='NH' THEN
  IF AX='C6' THENCMD TrackDb:=6//=>IsModFile
  IF AX='C8' THENCMD ^8CH: TrackDb:=8//=>IsModFile
ENDIF

DEBUG('*** Only 15 instuments ***')

Is15Inst:       mov     si,(Offset Header.mhSamples) + 15*(Size ModSample)
                mov     di,(Offset Header.mhOrderLen)
                mov     ax,ds
                mov     es,ax
                cld
                mov     cx,130
                rep     movsb
                mov     di,(Offset Header.mhSamples) + 15*(Size ModSample)
                xor     ax,ax
                mov     cx, 16*(Size ModSample)
                rep     stosb

                DEBUG('Seek mod header')
SeekPatterns:   mov     ax,4200h
                mov     bx,[FileHandle]
                mov     cx,0
                mov     dx,600
                int     21h

IsModFile:      mov     al,[Header.mhOrderLen]
                mov     [OrderLen],al

                mov     al,[Header.mhReStart]
                cmp     al,[Header.mhOrderLen]
                jb      SetReStart
                mov     al,7Fh
SetReStart:     mov     [ReStart],al

                mov     cx,128
                xor     ax,ax
                xor     bx,bx
CopyOrder:      mov     ah,[Header.mhOrder+bx]
                mov     [Order+bx],ah
                cmp     ah,al
                jb      NextOrder
                mov     al,ah
NextOrder:      inc     bx
                loop    CopyOrder

                DEBUG('Alloc patterns')
AllocPatterns:  xor     AH
                inc     AX
                DEBUG3
                MUL TrackDb
                AX<>BX ;mov     BX,AX
                ; BX=PATTERN_DB
                SHL BX,4 ; 1 TRACK 256 BYTE
                push    bx
                mov     ax,4800h
                int     21h
                pop     bx
                jc      CloseFile
                mov     Word Ptr [Patterns],0
                mov     Word Ptr [Patterns+2],ax

                DEBUG('Read patterns')
ReadPatterns:
                mov     cx,bx
                mov     bx,[FileHandle]
             push    ds
                lds     dx,[Patterns]
                SI:=16
                @:
                  mov     ax,3F00h
                  int     21h
                  DX+=CX//IF FLAG C THENCMD AX:=DS//AH+=10H//DS:=AX
                --SI//JNZ @
             pop     ds

                lea     si,[Header.mhSamples]
                xor     di,di
CopySamples:    mov     ax,[si+msLength]
                xchg    al,ah
                shl     ax,1
                mov     [SampLen+di],ax
                mov     al,[si+msVolume]
                xor     ah,ah
                mov     [SampVol+di],ax
                mov     ax,[si+msRepeat]
                xchg    al,ah
                shl     ax,1
                mov     [SampRep+di],ax

                mov     ax,[si+msRepLen]
                xchg    al,ah
                shl     ax,1
                mov     [SampRepLen+di],ax

                mov     BL,[si+msFineTune]
                AND BX,15
                shl     BX,1
                MOV AX,FINETUNE_TABL[BX]
                mov     [SampFineValue+DI],ax

                add     si,Size ModSample
                add     di,2
                cmp     di,2*31
                jb      CopySamples

                DEBUG('Alloc samples')
                xor     si,si
AllocSamples:   mov     bx,[SampLen+si]
                shr     bx,4
                je      NextSample
                DEBUG2('- alloc sample -')
                DEBUG5

                push    si
                inc     bx
                mov     ax,4800h
                int     21h
                pop     si
                jc      CloseFile
                mov     [SampOfs+si],0
                mov     [SampSeg+si],ax
ReadSample:     push    si
                push    ds
                DEBUG('- read sample -')
                mov     ax,3F00h
                mov     bx,[FileHandle]
                mov     cx,[SampLen+si]
                mov     dx,[SampOfs+si]
                mov     ds,[SampSeg+si]
                int     21h
                pop     ds
                pop     si
                jc      CloseFile
NextSample:     add     si,2
                cmp     si,2*31
                jb      AllocSamples

                mov     [ErrorInfo],0

                DEBUG4
                DEBUG('Close mod file')

CloseFile:      mov     ax,3E00h
                mov     bx,[FileHandle]
                int     21h

Failed:         pop     es
                pop     ds
                popa
                ret

LoadModule      EndP


FreeModule      Proc

                pusha
                push    ds
                push    es

                mov     ax,CS
                mov     ds,ax

FreePatterns:   mov     ax,4900h
                mov     bx,Word Ptr [Patterns+2]
                test    bx,bx
                je      FreeSamples
                mov     es,bx
                int     21h

FreeSamples:    xor     si,si
FreeLoop:       mov     ax,[SampLen+si]
                mov     bx,[SampSeg+si]
                test    ax,ax
                je      FreeNext
                test    bx,bx
                je      FreeNext
                push    si
                mov     ax,4900h
                mov     es,bx
                int     21h
                pop     si
FreeNext:       add     si,2
                cmp     si,2*31
                jb      FreeLoop

                call    ClearModInfo

                pop     es
                pop     ds
                popa
                ret

FreeModule      EndP


ClearModInfo    Proc    Near

                pusha
                push    es
                mov     ax,ds
                mov     es,ax
                lea     di,[ModInfo]
                mov     cx,MODINFO_SIZE ;;Size ModInfoRec
                cld
                xor     ax,ax
                rep     stosb
                pop     es
                popa
                ret

ClearModInfo    EndP


FINETUNE_TABL DW 32768,32532,32298,32066,31835,31606,31378,31153
              DW 34716,34467,34219,33973,33728,33486,33245,33005


