
;--------------------------------------------------------------------------
; MixTrack:  Mixes one track into a CLEAN buffer.
;  In:
;   ds:si -  Track Info Address.
;   ds:di -  Buffer Address.
;    cx   -  Buffer Size.
; *** VIGYZAT! Kicsit(?) nmdost a kd!!!
;--------------------------------------------------------------------------

MixTrack        Proc    Near

                AL:=2//IF PlayInStereo THENCMD ADD AX

                cmp     [si+RepLen],2
                ja      MixLooped
MixNonLooped:
                BPT ^STEREO1:=AL

                les     dx,[si+Samples]
                mov     bx,[si+Position]
                mov     bp,[si+Len]
                push    dx
                push    si
                add     bx,dx
                add     bp,dx
                mov     al,[si+Volume]
                XOR AH//MUL WPT MasterVolume
                MOV BPT ^VOLUME1,AH
                mov     dx,[si+Pitch]
                mov     ah,[si+Error]
                mov     si,bx
                mov     al,dl
                mov     dl,dh
                xor     dh,dh

; al=freq LO
; ah=ofs LO
; bh=volume
; CX=LOOP
; DX=freq HI
; ES:SI=ofs HI
; DI=BUFFER
; bp=end
=>nlMixSamp

              .ALIGN 4
              nlMixSamp:
                IF SI>=BP THEN nlMixBye ; Vge a mintnak!

                MOVSX   BX,BPT es:[si] ; sample data
                IMUL BX,BX,3//^VOLUME1=$-1
                add     [di],BX ;; buffer
                DI+=2//^STEREO1=$-1
                add     ah,al ; ofs LO
                adc     si,dx ; ofs HI
              loop    nlMixSamp

nlMixBye:       mov     bx,si
                pop     si
                pop     dx
                sub     bx,dx
                mov     [si+Position],bx
                mov     [si+Error],ah
                ret

MixLooped:
                BPT ^STEREO2:=AL

                les     dx,[si+Samples]
                mov     bx,[si+Position]
                mov     bp,[si+RepLen]
                mov     [BufRep],bp
                add     bp,[si+Repeat]
                ; BP=RepEnd
                push    dx
                push    si
                add     bx,dx  ; dx=sample offset
                add     bp,dx
                mov     al,[si+Volume]
                XOR AH//MUL WPT MasterVolume
                MOV BPT ^VOLUME2,AH
                mov     dx,[si+Pitch]
                mov     ah,[si+Error]
                mov     si,bx
                mov     al,dl
                mov     dl,dh
                xor     dh,dh
                =>lpMixSamp    ; CPU-QUEUE miatt

.ALIGN 4
lpMixSamp:      cmp     si,bp
                JNB ^AA ; GYORSABB, HA NEM KELL UGRANI!!
lpMixNow:       MOVSX   BX,BPT es:[si]
                IMUL BX,BX,3//^VOLUME2=$-1
                add     [di],bX
                DI+=2//^STEREO2=$-1
                add     ah,al
                adc     si,dx
              loop    lpMixSamp

lpMixBye:       mov     bx,si
                pop     si
                pop     dx
                sub     bx,dx
                mov     [si+Position],bx
                mov     [si+Error],ah
                ret

ALIGN 2
^AA:
                sub     si,[BufRep]
                JMP     lpMixNow

MixTrack        EndP


;--------------------------------------------------------------------------
; GetSamples:  Returns the next chunk of samples to be played.
;  In:
;    Buffer  - Buffer Address.
;    Count   - Buffer Size.
;--------------------------------------------------------------------------

GetSamples      Proc ; Pascal Buffer:DWord, Count:Word
;VAR Buffer:DD
;VAR Count:DW
; BE: DS:SI->BUFFER
;     CX=COUNT

                pusha
                push    ds
                push    es
                cld

DI:=SI//ES=DS ;;         les     di,[Buffer]
BX:=CX ;;                mov     bx,[Count]

NextChunk:      cmp     [BufLen],0
                jne     CopyChunk  ; Mg maradt az elz jtkrl...

                push    bx
                push    di
                push    es

MixChunk:       lea     di,[MixBuffer]
                mov     cx,[BpmSamples]
                ADD CX ;!!!  16 bit = 2 BYTE
                mov     [BufPtr],di
                IF PlayInStereo THENCMD ADD CX//DI+=2  ; STEREO!
;                IF PlayInStereo THENCMD DI+=2  ; STEREO!
                VAR BufPtr2=DI
                mov     [BufLen],cx

                mov     ax,ds
                mov     es,ax
                lea     di,[MixBuffer]
                SHR CX
                REP STOSW 8000H

_Ofs = offset Tracks    //IF CHANNEL1_ON THENCMD SI:=_OFS//DI:=BufPtr//CX:=BpmSamples//!MixTrack
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL2_ON THENCMD SI:=_OFS//DI:=BufPtr2//CX:=BpmSamples//!MixTrack
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL3_ON THENCMD SI:=_OFS//DI:=BufPtr2//CX:=BpmSamples//!MixTrack
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL4_ON THENCMD SI:=_OFS//DI:=BufPtr//CX:=BpmSamples//!MixTrack
  IF TrackDb=4 THEN ^OK_MIX
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL5_ON THENCMD SI:=_OFS//DI:=BufPtr//CX:=BpmSamples//!MixTrack
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL6_ON THENCMD SI:=_OFS//DI:=BufPtr2//CX:=BpmSamples//!MixTrack
  IF TrackDb=6 THEN ^OK_MIX
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL7_ON THENCMD SI:=_OFS//DI:=BufPtr2//CX:=BpmSamples//!MixTrack
_Ofs=_Ofs+Size TrackInfo//IF CHANNEL8_ON THENCMD SI:=_OFS//DI:=BufPtr//CX:=BpmSamples//!MixTrack

^OK_MIX:  ; MIXBUFFER:DB*BPMSAMPLES tele van

                call    UpdateTracks
                FORLSPF(FAST_PLAY)
                  !UpdateTracks
                NEXT

                pop     es
                pop     di
                pop     bx

CopyChunk:      mov     cx,[BufLen]
                mov     si,[BufPtr]

               ;forrs:  SI=anyag kezdete  CX=hossza
               ;cl:     DI=anyag helye, BX=hely hossza

            IF Play8bit THEN
              SHR CX
                if cx>bx thencmd cx:=bx  ; BX = nagy puffer mrete
                sub     bx,cx         ; !!!
              SHL CX
                add     [BufPtr],cx   ; !!!
                sub     [BufLen],cx   ; !!!
              SHR CX
              ++SI
              FORLSFA4
                LODSW//STOSB
            ;    LODSW//STOSB
              NEXT
            ELSE
              if cx>bx thencmd cx:=bx  ; BX = nagy puffer mrete
              sub     bx,cx         ; !!!
              add     [BufPtr],cx   ; !!!
              sub     [BufLen],cx   ; !!!

              SHR CX,2
              IF PlayInStereo AND SoundCard=SC_GUS16 THEN
                FORLSFA4
                  DI+=DmaBufSize/2
                  MOVSW
                  DI-=DmaBufSize/2+2
                  MOVSW
                NEXT
              ELSE
                REP MOVSD
              ENDIF
            ENDIF

                test    bx,bx
                jne     NextChunk

                pop     es
                pop     ds
                popa
                ret

GetSamples      EndP


