;
;                              DIALOG BOX
;
;
;       INPUT:  CS:SI = DIALOG BOX STRUCTURE
;               AL    = LEFT X POSITION
;               AH    = UPPER Y POSITION
;               BL    = XSIZE
;               BH    = YSIZE
;               CL    = bit0: line at second row
;                       bit1: line at before the last row
;               CH>>>>  bit7: line at CH
;               CS:DX = HEADER TEXT
;               CS:BP = 0normal 1invers
;
;       OUTPUT: AL    = THE RETURN CODE
;
;       ------------------------
;       - DIALOG BOX STRUCTURE -
;       ------------------------
;
;       startitem
;       x, y, type, pointer
;       x, y, type, pointer
;       ...
;       0, 0,    0
;
;  Byte X    = Relative X position from the LEFT FRAME (NOT THE DIALOG BOX!)
;  Byte Y    = Relative Y position from the UPPER FRAME        -''-
;
;  Byte TYPE =  1 : Text   -> Word pntr = The ASCIIZ text (pointer)     DW
;               2 : Button -> Word pntr = Button value (byte)           DB
;                                         Button ASCIIZ text (pointer)  DW
;               3 : Input  -> Word pntr = Initial String (pointer)      DW
;                                         Return String (pointer)       DW
;                                         Maximal length (byte)         DB
;                                         Visible length (byte)         DB
;               4 : Box    -> Word pntr = Xsize (byte)                  DB
;                                         Ysize (byte)                  DB
;                                         Header ASCIIZ text (pointer)  DW
;               5 : ChkBox -> Word pntr = # of "boxes" (byte)           DB
;                                         Actual BOX (byte)             DB ?
;                                         Table - 0=[ ] 1=[X] (pointer} DW
;                                         ASCIIZ strings                STRINGS
;               6 : RadBut -> Word pntr = # of "buttons" (byte)         DB
;                                         Actual BUTTON (byte)          DB ?
;                                         Active BUTTON (byte)          DB
;                                         ?                             DB ?
;                                         ASCIIZ strings                STRINGS
;               7 : Passw  -> Word pntr = Initial String (pointer)      DW
;                                         Return String (pointer)       DW
;                                         Maximal length (byte)         DB
;                                         Visible length (byte)         DB
;               8 : Menu   -> Word pntr = Xsize (byte)                  DB
;                                         Ysize (byte)                  DB
;                                         Structure Offset              DW
;                                         Structure Segment             DW
;               0 : End...

DIALOG::

PUSHA // PUSH DS,ES // DS=CS

VAR KB_NORM:DW
VAR KB_SHFT:DW
VAR KB_CTRL:DW
VAR KB_ALT:DW
VAR ACTUAL_BAR:DW

VAR ^LINES:DB
VAR ^LINE:DB

VAR ^CURSOR_SHAPE:DW
VAR ^CURSOR_POS:DW
VAR ^XSIZE:DB=0
VAR ^POS:DW
VAR ^MAINPOS:DW
VAR ^SCREEN_POS:DW
VAR ^ACTUAL_ITEM:DB
VAR ^ITEM_COUNTER:DB
VAR ^TYPE:DB
VAR ^CHECK_POS:DW
VAR ^STRUCTURE_START:DW
VAR ^NUMBER_OF_ITEMS:DB
VAR ^INITIALIZING:DB

VAR ^BUTTON:DW
VAR ^BUTTON_UCASE:DB

VAR ^ACT_TYPE:DB
VAR ^ACT_START:DW
VAR ^ACT_POS:DW
VAR ^ACT_SCRPOS:DW

VAR ^INPUT_POS:DW
VAR ^INPUT_LEN:DW
VAR ^INPUT_FKEY:DB

CONST ^CHKBOX_ACT:DB=0

VAR ^DIALOG_RETURN:DB

VAR ^MOUSE_X:DB
VAR ^MOUSE_Y:DB
VAR ^MOUSE_CHECKED:DB

Var ^SCREEN_TEMP:DW

; ** PROGRAM START ************************************************************

LODSW // BP<>AX // LODSW // BX<>AX
LODSB // CX<>AX // LODSW // DX<>AX
LODSW // BP<>AX

IF AL=0 THENCMD AL:=XSIZE // AL>0> // PUSH BX // BL>0> // AL-=BL // POP BX // ^XSIZE:=BL
IF AH=0 THENCMD AH:=BPT YSIZE // AH>0> // --AH // PUSH BX // BH>0> // AH-=BH // POP BX

PUSHA

        WPT ^LINES:=CX
        AX+=256+3 // ^MAINPOS:=AX
        AX:=CS // DS:=AX // ES:=AX
        AH:=3 // XOR BX // BIOS // ^CURSOR_SHAPE:=CX // ^CURSOR_POS:=DX
        AH:=1 // CH:=20h // BIOS
        SI->^SCREEN_TEMP // !SCREEN_SAVE
        ;PUSH(DS) DS:=SCREENSEG // ES=CS // DI->^SCREEN_TEMP // SI:=0 // CX:=80*25 // REP MOVSW
        ^INITIALIZING:=1

POPA

BH-=4

PUSH SI BX DX

CL:=AH // PUSH AX // AL:=XSIZE // MUL CL // AX<0< // DI:=AX // POP AX // XOR AH // AX<0< // DI+=AX
ES:=SCREENSEG

PUSH DI
XOR CX // CL:=BL // DX:=CX // DX-=8
AL:=' ' // AH:=[BP] // REP STOSW
POP DI // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX

POP SI

PUSH DI
CL:=3 // REP STOSW ;CH:=3

^SCREEN_POS:=DI
AL:='' // STOSW

AL:='' // BX:=DX // --BX // --BX // !STRLEN_ // !CALC_MIDDLE // REP STOSW
AL:=' ' // STOSW // !WRITESTR // STOSW
CX:=BX // AL:='' // REP STOSW

AL:='' // STOSW

AL:=' ' // CL:=3 // REP STOSW ;CH:=3

!SHADOW // !SHADOW

POP DI // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX

POP BX

XOR BL

REPEAT

  PUSH DI

  CL:=3 // REP STOSW ;CX:=3

  IF ^LINES&1 AND BL=1 THENCMD =>SHORT @1
  IF ^LINES&128 AND BH=^LINE THENCMD =>SHORT @1
  IF ^LINES&2 AND BH=2 THENCMD @: AL:='' // STOSW // AL:='' // CX:=DX // REP STOSW // AL:='' // STOSW // =>SHORT @1

  AL:='' // STOSW // AL:=' ' // CX:=DX // REP STOSW // AL:='' // STOSW

  @:
  AL:=' ' // CL:=3 // REP STOSW ;CX:=3

!SHADOW // !SHADOW

  POP DI // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX

++BL // --BH // UNTIL FLAG Z

PUSH DI
CL:=3 // REP STOSW ;CX:=3
AL:='' // STOSW
AL:='' // CX:=DX // REP STOSW
AL:='' // STOSW
AL:=' ' // CL:=3 // REP STOSW ;CX:=3

!SHADOW // !SHADOW

POP DI // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX

DL+=8 // AL:=' ' // CX:=DX // REP STOSW ;CX+=8

!SHADOW // !SHADOW

PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX

DI-=DX
DI-=DX

CX:=DX
@: // !SHADOW // LOOP @

POP SI

LODSB // ^ACTUAL_ITEM:=AL

^STRUCTURE_START:=SI

; ** FILL DIALOG BOX **********************************************************

^REDRAW:

SI:=^STRUCTURE_START
^ITEM_COUNTER:=0
AH:=1 // CH:=20h // BIOS

^REP:
LODSW // ^POS:=AX // AL<>AH // BL:=AH // XOR AH // XOR BH
IF BL=0 AND BPT DS:[SI]=1 THEN
  PUSH SI,AX // SI:=DS:[SI+1] // !STRLEN_
  BL:=^XSIZE // BL-=5 // BL>0> // ++CX // CX>0> // BL-=CL
  POP SI,AX
ENDIF
BX<0< // MUL XSIZE // AX<0< // DI:=AX // DI+=BX // DI+=^SCREEN_POS
LODSB // ^TYPE:=AL

LODSW // PUSH SI // SI:=AX

AL:=^ITEM_COUNTER
IF AL=^ACTUAL_ITEM THEN
  AX:=^POS // AX+=^MAINPOS // ^ACT_POS:=AX
  AL:=^TYPE // ^ACT_TYPE:=AL
  ^ACT_START:=SI
  ^ACT_SCRPOS:=DI
ENDIF

; >> Text

IF ^TYPE=1 THENCMD AH:=[BP] // !WRITESTR

; >> Button

IF ^TYPE=2 THEN
        LODSB
        AH:=[BP] // AL:=^ITEM_COUNTER // IF AL=^ACTUAL_ITEM THENCMD AH:=[BP+1]
        LODSB // !WRITESTR
ENDIF

; >> Input

IF ^TYPE=3 OR ^TYPE=7 THEN
        PUSH ES,DI
        LODSW // BX:=AX
        LODSW // DI:=AX
        LODSW // SI:=BX // XOR BX // BL:=AH
        ES=CS // PUSH DI
        IF ^INITIALIZING=1 THENCMD !STRCOPY
        POP SI
        POP ES,DI
        !STRLEN_ // BX-=CX // BPT ^POS+=CL
        AL:=^ITEM_COUNTER
        IF AL=^ACTUAL_ITEM THEN
                ^INPUT_FKEY:=1 // ^INPUT_POS:=CX // ^INPUT_LEN:=CX      ;Initialize
                 DX:=^POS // DX+=^MAINPOS // AH:=2 // BIOS              ;GOTOXY
                 CX:=^CURSOR_SHAPE // AH:=1 // BIOS     ;CURSOR_ON
        ENDIF
        AH:=[BP+1]
        IF ^TYPE=3 THEN
          !WRITESTR
         ELSE
          @: LODSB // IF AL<>0 THENCMD AL:='*' // STOSW // =>@
        ENDIF
        CX:=BX // IF CX<>0 THENCMD AL:='' // REP STOSW
ENDIF

; >> Box

IF ^TYPE=4 THEN
        LODSW // BX:=AX // BX-=0202h // DL:=BH // XOR BH // XOR DH      ;X=BX Y=DX
        PUSH DI,BX
                !STRLEN_
                AH:=[BP] // AL:='' // STOSW // AL:=' ' // STOSW // AH:=[BP+3] // !WRITESTR // AH:=[BP] // STOSW
                BX-=CX // --BX // --BX // CX:=BX // AL:='' // REP STOSW
                AL:='' // STOSW
        POP DI,BX // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX
        ^BOXLOOP:
        PUSH DI
        AL:='' // STOSW // DI+=BX // DI+=BX // STOSW
        POP DI // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX
        --DX // IF DX<>0 THEN ^BOXLOOP
        AL:='' // STOSW // AL:='' // CX:=BX // REP STOSW // AL:='' // STOSW
ENDIF

; >> CheckBox & RadioButton

IF ^TYPE<>5 AND ^TYPE<>6 THENCMD =>^SKIPCHKBOX
        LODSB // XOR CX // CL:=AL
        ^CHECK_POS:=SI // IF ^TYPE=6 THENCMD AL:=[SI+1] // BPT [SI]:=AL
        LODSB // LODSW // BX:=AX // XOR DL
        ^LP:
        PUSH DI
        AH:=[BP]
        IF ^TYPE=5 THEN
                AL:='[' // STOSW // AL:='X' // IF BPT [BX]=0 THENCMD AL:=' '
                STOSW
                AL:=']' // STOSW
        ENDIF
        IF ^TYPE=6 THEN
                AL:='(' // STOSW
                AL:=' ' // IF BL=DL THENCMD AL:=7 ;;//PUSH BX//BX:=^CHECK_POS//[BX]:=DL//POP BX
                STOSW
                AL:=')' // STOSW
        ENDIF
        AL:=' ' // STOSW // ++DL // IF ^TYPE=5 THENCMD ++BX
        LODSB // !WRITESTR
        POP DI // PUSH AX // MOVZX AX,XSIZE // DI+=AX // DI+=AX // POP AX
        LOOP ^LP
        BX:=^CHECK_POS
        AL:=^ITEM_COUNTER
        IF AL=^ACTUAL_ITEM THEN
                DX:=^POS // DX+=^MAINPOS // DH+=BPT [BX] // ++DL // XOR BH // AH:=2 // BIOS
                CX:=^CURSOR_SHAPE // AH:=1 // BIOS
        ENDIF
^SKIPCHKBOX:

++^ITEM_COUNTER
POP SI
IF ^TYPE<>0 THENCMD =>^REP

AL:=^ITEM_COUNTER // --AL // ^NUMBER_OF_ITEMS:=AL

^INITIALIZING:=0

^NEXTKEY:
!MOUSE_ON

^NOMOUSE:
!GETKEY

; ** MOUSE HANDLING **[START]***[CX=XPOS]*[DX=YPOS]****************************

IF FLAG NC THENCMD =>^KEYREADY

 ^MOUSE_CHECKED:=0
 ^MOUSE_LOOP:
 CX>0>3 // DX>0>3
 ^MOUSE_X:=CL // ^MOUSE_Y:=DL

 SI:=^STRUCTURE_START // ^ITEM_COUNTER:=0

 ^MOUSE_REPEAT:

        LODSW // AX+=^MAINPOS // BX:=AX // LODSB // ^TYPE:=AL
        LODSW // PUSH SI

        SI:=AX

        IF ^TYPE=2 THEN ; >> [BUTTON]
         LODSW // !STRLEN_
         CL+=BL
         IF ^MOUSE_Y=BH AND ^MOUSE_X>=BL AND ^MOUSE_X<CL THEN
                AL:=^ITEM_COUNTER
                IF AL=^ACTUAL_ITEM THEN
                        IF ^MOUSE_CHECKED=0 THENCMD XOR BX // XOR CX // DX:=1400h+'' // MOUSE 10 // ^MOUSE_CHECKED:=1
                        POP SI // =>^MOUSE_LOOP_END
                ENDIF
                ^ACTUAL_ITEM:=AL // POP SI // !MOUSE_OFF // =>^REDRAW
         ENDIF
        ENDIF

        IF ^TYPE=3 OR ^TYPE=7 THEN ; >> [INPUT]
         SI+=5 // AL+=BL
         IF ^MOUSE_Y=BH AND ^MOUSE_X>=BL AND ^MOUSE_X<AL THEN
                AL:=^ITEM_COUNTER
                IF AL=^ACTUAL_ITEM THENCMD POP SI // =>^MOUSE_LOOP_END
                ^ACTUAL_ITEM:=AL // POP SI // !MOUSE_OFF // =>^REDRAW
         ENDIF
        ENDIF

 PUSH BP                ; >> [CHECKBOX(5) & RADIOBUTTON(6)]
        IF ^TYPE<>5 AND ^TYPE<>6 THENCMD =>^SKIPBOX
        LODSB // XOR CX // CL:=AL // DX:=BX // BX:=0 // BP:=SI // BP+=3
         ; CX=# of boxes | BP->STRINGS | DX=X,Y | BX=# of selected [X] / ()
         ^CHKBOXLOOP:
         PUSH CX,SI      ; BP-ben aktulis string pointere DL=Xstart CL=Xend+1
         SI:=BP // !STRLEN // BP+=CX // ++BP // !STRLEN_ // CL+=3 // CL+=DL
                 IF ^MOUSE_Y=DH AND ^MOUSE_X>=DL AND ^MOUSE_X<CL THEN ; >> Tallt!
                        AL:=^ITEM_COUNTER
                        POP SI
                        ;Set CheckBox if not pressed yet.
                        IF ^CHKBOX_ACT=0 AND ^TYPE=5 THENCMD PUSH SI // SI:=[SI+1] // XOR BPT [SI+BX],1 // POP SI
                        ;Set RadioButton
                        IF ^TYPE=6 THENCMD [SI+1]:=BL
                        ;CheckBox?
                        IF ^CHKBOX_ACT=0 AND ^TYPE=5 THENCMD POP CX BP SI // ^CHKBOX_ACT:=1 // !MOUSE_OFF // =>^REDRAW
                        IF [SI]=BL AND ^ACTUAL_ITEM=AL THENCMD POP CX BP SI // ^CHKBOX_ACT:=1 // =>^MOUSE_LOOP_END
                        ^ACTUAL_ITEM:=AL
                        [SI]:=BL // POP CX BP SI // !MOUSE_OFF // =>^REDRAW
                 ENDIF
         POP CX,SI // ++BX // ++DH
         --CX // IF CX<>0 THENCMD =>^CHKBOXLOOP
        ^SKIPBOX:
 POP BP

        POP SI // ++^ITEM_COUNTER

 IF ^TYPE<>0 THENCMD =>^MOUSE_REPEAT

 IF ^MOUSE_CHECKED=1 THENCMD BX:=0 // CX:=-1 // DX:=7700h // MOUSE 10 // ^MOUSE_CHECKED:=0

 ^MOUSE_LOOP_END:
 MOUSE 3
 IF BX=0 THEN
        ^CHKBOX_ACT:=0
        IF ^MOUSE_CHECKED=1 THENCMD BX:=0 // CX:=-1 // DX:=7700h // MOUSE 10 // ^MOUSE_CHECKED:=0 // AX:=1C0Dh // =>^KEYREADY
        =>^NOMOUSE
 ENDIF
 !WRITECLOCK
 =>^MOUSE_LOOP

; ** MOUSE HANDLING **[END]****************************************************

^KEYREADY:
!MOUSE_OFF
^BUTTON:=AX // UPCASE AL // ^BUTTON_UCASE:=AL

; ** INIT DIALOG BOX **********************************************************

SI:=^STRUCTURE_START

; >> Button

IF ^ACT_TYPE=2 THEN

        IF BPT ^BUTTON[1]=28 THEN ; ***** Enter *****
          SI:=^ACT_START // AL:=[SI] // ^DIALOG_RETURN:=AL // =>^CLOSEDIALOG
        ENDIF

        IF BPT ^BUTTON[0]<>0 THEN ; ***** Button *****
          SI:=^STRUCTURE_START
          @:
          AL:=DS:[SI+2]
            IF AL=0 THEN @2
            IF AL<>2 THEN @1
          PUSH SI
            SI:=[SI+3] // LODSW
            IF AH=BPT ^BUTTON_UCASE THEN
              POP SI
              ^DIALOG_RETURN:=AL
              =>^CLOSEDIALOG
            ENDIF
          POP SI
          @:
            SI+=5 // =>@-1
          @:
        ENDIF

        IF BPT ^BUTTON[1]=77 OR BPT ^BUTTON[1]=80 THEN  ; ***** Right *****
          ^NEXTBUTT:
          AL:=^ACTUAL_ITEM // ++AL // IF AL=^NUMBER_OF_ITEMS THENCMD AL:=0
          ^ACTUAL_ITEM:=AL
          XOR AH // BX:=AX // SI:=^STRUCTURE_START // BX<0<2 // BX+=AX    ;*5
          AL:=DS:[SI+BX+2] // IF AL<>2 THEN ^NEXTBUTT
          =>^REDRAW
        ENDIF

        IF BPT ^BUTTON[1]=75 OR BPT ^BUTTON[1]=72 THEN  ; ***** Left *****
          ^LASTBUTT:
          AL:=^ACTUAL_ITEM // IF AL=0 THENCMD AL:=^NUMBER_OF_ITEMS
          --AL // ^ACTUAL_ITEM:=AL
          XOR AH // BX:=AX // SI:=^STRUCTURE_START // BX<0<2 // BX+=AX
          AL:=DS:[SI+BX+2] // IF AL<>2 THEN ^LASTBUTT
          =>^REDRAW
        ENDIF

ENDIF

; >> Input

IF ^ACT_TYPE<>3 AND ^ACT_TYPE<>7 THENCMD =>^INPINIT
 IF BPT ^BUTTON[1]=28 THENCMD ^DIALOG_RETURN:=1 // =>^CLOSEDIALOG ;ENTER
        AX:=^INPUT_POS
        DI:=^ACT_SCRPOS // SI:=^ACT_START // XOR BX // BL:=[SI+4] // SI:=[SI+2]
 PUSH BX
        IF BPT ^BUTTON[1]=77 AND AX<^INPUT_LEN THENCMD ++AX  ;RIGHT
        IF BPT ^BUTTON[1]=75 AND AX<>0 THENCMD --AX          ;LEFT
        IF BPT ^BUTTON[1]=71 THENCMD XOR AX                  ;HOME
        IF BPT ^BUTTON[1]=79 THENCMD AX:=^INPUT_LEN          ;END
        IF BPT ^BUTTON[1]=14 AND ^INPUT_LEN<>0 AND AX>0 THEN ;BACKSPACE
                --AX
                PUSH AX
                CX:=^INPUT_LEN // CX-=AX // ++CX // BX:=AX
                @: AL:=[SI+BX+1] // [SI+BX]:=AL // ++BX // LOOP @
                POP AX // --WPT ^INPUT_LEN
        ENDIF
        IF BPT ^BUTTON[1]=83 AND ^INPUT_LEN<>0 AND AX<>^INPUT_LEN THEN ;DEL
                PUSH AX
                CX:=^INPUT_LEN // CX-=AX // ++CX // BX:=AX
                @: AL:=[SI+BX+1] // [SI+BX]:=AL // ++BX // LOOP @
                POP AX // --WPT ^INPUT_LEN
        ENDIF
        IF BPT ^BUTTON[1] IN[1,14,15,28] THEN ^SKIPINPCHAR
        IF WPT ^BUTTON=5230h OR WPT ^BUTTON=9200h THEN
          PUSH DI,ES,DS,SI
          DI:=SI // SI:=0 // ES=DS // CX:=BLOCK_SIZE // ++CX // DS:=BLOCK_SEGM
          IF CX>BX THENCMD CX:=BX
          @: LODSB // --CX // IF AL=13 OR CX=0 THENCMD AL:=0
          STOSB // IF AL<>0 THEN @
          AX:=SI // --AX // POP DI,ES,DS,SI
          WPT ^BUTTON:=0 // ^INPUT_LEN:=AX
        ENDIF
        IF BPT ^BUTTON<>0 AND ^INPUT_LEN<BX THEN
          IF ^INPUT_FKEY=1 THENCMD XOR AX // ^INPUT_LEN:=AX // =>^INP0
          PUSH AX
          BX:=^INPUT_LEN // CX:=BX // CX-=AX // ++CX
          @: AL:=[SI+BX] // [SI+BX+1]:=AL // --BX // LOOP @
          POP AX
          ^INP0:
           BX:=AX // DL:=BPT ^BUTTON // [SI+BX]:=DL
          ++WPT ^INPUT_LEN // BX:=^INPUT_LEN // BPT [SI+BX]:=0
          ++AX
        ENDIF
        ^SKIPINPCHAR:
        ^INPUT_FKEY:=0
        ^INPUT_POS:=AX
        DX:=^ACT_POS // DL+=AL // AH:=2 // BIOS
 POP BX
        !STRLEN_ // BX-=CX
        AH:=[BP+1]
        IF ^ACT_TYPE=3 THEN
          !WRITESTR
         ELSE
          @: LODSB // IF AL<>0 THENCMD AL:='*' // STOSW // =>@
        ENDIF
        CX:=BX // IF CX<>0 THENCMD AL:='' // REP STOSW
^INPINIT:

; >> CheckBox & RadioButton

IF ^ACT_TYPE=5 OR ^ACT_TYPE=6 THEN
 IF BPT ^BUTTON[1]=28 THENCMD ^DIALOG_RETURN:=1 // =>^CLOSEDIALOG ; >> [ENTER]
 SI:=^ACT_START // XOR AX // LODSB // CX:=AX
 SI+=3 // XOR BL
   @:
   LODSB
   IF BPT ^BUTTON[1]<>0 AND BPT ^BUTTON_UCASE=AL THEN
       SI:=^ACT_START
       ++SI // BPT [SI]:=BL
       BPT ^BUTTON:=32
    ELSE
       PUSH(CX) !STRLEN // SI+=CX // ++SI
       ++BL // LOOP @
   ENDIF
 SI:=^ACT_START // LODSB // DL:=AL // AL:=[SI]
 IF BPT ^BUTTON[1]=72 THEN ;UP
        IF AL=0 THENCMD AL:=DL
        --AL
 ENDIF
 IF BPT ^BUTTON[1]=80 THEN ;DOWN
        ++AL
        IF AL=DL THENCMD AL:=0
 ENDIF
 [SI]:=AL
 IF BPT ^BUTTON=32 THEN
     IF ^ACT_TYPE=5 THEN ; >> CheckBox
          BX:=[SI+1] // XOR AH // BX+=AX // XOR BPT [BX],1
       ELSE              ; >> RadioButton
          [SI+1]:=AL
     ENDIF
     =>^REDRAW
 ENDIF
 DX:=^ACT_POS // ++DL // DH+=AL // XOR BH // AH:=2 // BIOS
ENDIF

; >> Main

IF ^BUTTON=0F09h THEN ;TAB
        DL:=^ACTUAL_ITEM
        ^NEXT:
        AL:=^ACTUAL_ITEM // ++AL // IF AL=^NUMBER_OF_ITEMS THENCMD XOR AL
        ^ACTUAL_ITEM:=AL
        XOR AH // BX:=AX // SI:=^STRUCTURE_START // BX<0<2 // BX+=AX
        DH:=DS:[SI+BX+2] // IF DH=1 OR DH=4 THEN ^NEXT
        IF AL<>DL THENCMD =>^REDRAW
ENDIF

IF ^BUTTON=0F00h THEN ;SHIFT-TAB
        DL:=^ACTUAL_ITEM
        ^NEXT2:
        AL:=^ACTUAL_ITEM // IF AL=0 THENCMD AL:=^NUMBER_OF_ITEMS
        --AL // ^ACTUAL_ITEM:=AL
        XOR AH // BX:=AX // SI:=^STRUCTURE_START // BX<0<2 // BX+=AX
        DH:=DS:[SI+BX+2] // IF DH=1 OR DH=4 THEN ^NEXT2
        IF AL<>DL THENCMD =>^REDRAW
ENDIF

IF BPT ^BUTTON[1]<>68 AND BPT ^BUTTON[1]<>1 THENCMD =>^NEXTKEY

^DIALOG_RETURN:=255

^CLOSEDIALOG:

; ** CLOSE DIALOG BOX *********************************************************

CX:=^CURSOR_SHAPE // AH:=1 // BIOS
DX:=^CURSOR_POS // AH:=2 // BIOS
;ES:=SCREENSEG // SI->^SCREEN_TEMP // DI:=0 // CX:=80*25 // REP MOVSW
SI->^SCREEN_TEMP // !SCREEN_LOAD
POP DS,ES // POPA // AL:=CS:^DIALOG_RETURN // RET

;
;                              CALC MIDDLE
;
;
; BE:
; CX=Length
; BX=Maximum
; KI:
; CX=Eltte
; BX=Utna

CALC_MIDDLE::
PUSH DX
DX:=BX // BX-=CX // DX>0> // ++CX // CX>0> // DX-=CX // CX:=DX // ++CX // BX-=CX
POP DX // RET

;
;                          WRITE ASCIIZ STRING
;

WRITESTR::

PUSH AX,BX
BH:=AH
^LP:
AH:=BH
LODSB
IF AL=1 THENCMD AH:=[BP+2] // LODSB
IF AL<>0 THENCMD STOSW // =>^LP

POP AX,BX // RET

;
;                              DRAW SHADOW
;

SHADOW::
PUSH AX
 AX:=ES:[DI]
 IF AH>15 THEN
   AH&=7
  ELSE
   AH:=0
 ENDIF
 STOSW
POP AX // RET

;
;                          CALC LEN WITHOUT #1!
;

STRLEN_::

PUSH AX,SI
  XOR CX
  @: LODSB // IF AL=1 THEN @
  IF AL<>0 THENCMD ++CX // =>@
POP AX,SI
RET

