#include "stdafx.h"

#define DI __declspec(dllimport)
#include "buzzplay.h"
#include "audiodriver.h"
#include "../dsplib/dsplib.h"

extern float *AudioCallback(int &numsamples);

CAudioDriver *g_AudioDriver = NULL;

class CADListEntry  
{
public:
        CAudioDriverInfo const *pInfo;
        CAudioDriver *(__cdecl *NewAD)();
};

static CADListEntry AD;

static void adReadProfileString(char const *key, char *value)
{
	assert(false);
}

static void adWriteProfileString(char const *key, char const *value)
{

}

static int adReadProfileInt(char const *key, int const value)
{
	if (!strcmp(key, "SamplesPerSec"))
		return 44100;

	if (!strcmp(key, "DeviceID"))
		return 0;

	if (!strcmp(key, "numBlocks"))
		return 4;

	if (!strcmp(key, "BlockSize"))
		return 8192;

	if (!strcmp(key, "PollSleep"))
		return 10;

	if (!strcmp(key, "Dither"))
		return 0;

	assert(false);

	return 0;
}

static void adWriteProfileInt(char const *key, int const value)
{

}

static void InitDriver()
{
        g_AudioDriver = AD.NewAD();
        g_AudioDriver->ReadProfileString = adReadProfileString;
        g_AudioDriver->WriteProfileString = adWriteProfileString;
        g_AudioDriver->ReadProfileInt = adReadProfileInt;
        g_AudioDriver->WriteProfileInt = adWriteProfileInt;

//        HWND hwnd = AfxGetMainWnd()->GetSafeHwnd();

        g_AudioDriver->Initialize((dword)0, AudioCallback);

}
void StartPlayer()
{

	HINSTANCE hinst = LoadLibrary("wo_waveout.dll");
	CAudioDriverInfo const *(__cdecl *GetADInfo)() = (CAudioDriverInfo const *(__cdecl *)())GetProcAddress(hinst, "GetADInfo");
	AD.pInfo = GetADInfo();
	AD.NewAD = (CAudioDriver *(__cdecl *)())GetProcAddress(hinst, "NewAD");

	InitDriver();
	DSP_Init(44100);


	
}

void StopPlayer()
{
	g_AudioDriver->Reset();
}
