/*
	B2String - simple string class

	NOTE: the class simply encapsulates a 'char *', so it's ok to replace B2String with a pointer to NULL terminated string
	when using non-C++ compiler

	I've used this class in several projects so it should be bugfree, but if you have problems with it, mail me at ot@iki.fi.
*/

#ifndef __BUZZ2_STRING_H
#define __BUZZ2_STRING_H

#include <stdio.h>
#include <string.h>
#include <j/macros.h>

#pragma pack(4)  
 
class B2String
{
public:
		B2String(); 								// default
		B2String(B2String const &a);				// copy
		B2String(char const *a);					// from c string
		B2String(char const a); 					// from char
		B2String(int const len);					// empty string

		~B2String();								

		operator char * () const { return data; }
		operator char const * () const { return data; }

		char & operator [] (int const i) { return data[i]; }
		char const & operator [] (int const i) const { return data[i]; }

		B2String const & operator = (B2String const &a);
		B2String const & operator = (char const *a);
		B2String const & operator = (char const a);

		void copy(char const *a, int const len);

		friend bool operator == (B2String const &a, char const *b)
		{
			return strcmp(a.data, b) == 0;
		}

		friend bool operator != (B2String const &a, char const *b)
		{
			return strcmp(a.data, b) != 0;
		}

		friend bool operator < (B2String const &a, char const *b)
		{
			return strcmp(a.data, b) < 0;
		}

		friend bool operator > (B2String const &a, char const *b)
		{
			return strcmp(a.data, b) > 0;
		}

		friend B2String operator + (B2String const &a, char const *b)
		{
			B2String t;
			t.data = new char [a.length() + strlen(b) + 1];
			strcpy(t.data, a);
			strcat(t.data, b);
			return t;
		}

		void operator += (char const *a)
		{
			char *old = data;
			data = new char [strlen(old) + strlen(a) + 1];
			strcpy(data, old);
			strcat(data, a);
			delete[] old;
		}

		int length() const;
		void upper();
		void lower();
		int index(char const a) const;
		int index(char * const s) const;
		void replace(char const oldc, char const newc);

	protected:
		char *data;

};

#pragma pack()

inline B2String::B2String()
{
	data = NULL;
}

inline B2String::B2String(B2String const &a)
{
	if (a.data != NULL)
	{
		data = new char [strlen(a.data) + 1];
		strcpy(data, a.data);
	}
	else
	{
		data = NULL;
	}
}

inline B2String::B2String(char const *a)
{
	if (a != NULL)
	{
		data = new char [strlen(a) + 1];
		strcpy(data, a);
	}
	else
	{
		data = NULL;
	}
}

inline B2String::B2String(char const a)
{
	data = new char [1 + 1];
	data[0] = a;
	data[1] = 0;
}

inline B2String::B2String(int const len)
{
	data = new char [len + 1];
	memset(data, 0, len + 1);
}


inline B2String::~B2String()
{
	delete[] data;
}

inline B2String const & B2String::operator = (B2String const &a)
{
	delete[] data;
	data = NULL;

	if (a.data != NULL)
	{
		data = new char [strlen(a.data) + 1];
		strcpy(data, a.data);
	}

	return *this;
}

inline B2String const & B2String::operator = (char const *a)
{
	delete[] data;
	data = NULL;

	if (a != NULL)
	{
		data = new char [strlen(a) + 1];
		strcpy(data, a);
	}

	return *this;
}

inline B2String const & B2String::operator = (char const a)
{
	delete[] data;

	data = new char [1 + 1];
	data[0] = a;
	data[1] = 0;

	return *this;
}

inline void B2String::copy(char const *a, int const len)
{
	delete[] data;
	data = new char [len + 1];
	memcpy(data, a, len);
	data[len] = 0;
}

inline int B2String::length() const
{
	if (data == NULL)
		return 0;
	else
		return strlen(data);
}

inline void B2String::upper()
{
	if (data != NULL)
		strupr(data);
}

inline void B2String::lower()
{
	if (data != NULL)
		strlwr(data);
}

inline int B2String::index(char const a) const
{
	if (data != NULL)
	{
		for (int c = 0; c < length(); c++)
		{
			if (data[c] == a)
				return c;
		}
	}
	return -1;
}

inline int B2String::index(char * const s) const
{
	if (data != NULL)
	{
		for (int c = 0; c < length(); c++)
		{
			char *d = data + c;
			char *p = s;
			while(*d == *p)
			{
				p++;
				if (*p == 0)
					return c;
				d++;
				if (*d == 0)
					return -1;
			}
		}
	}
	return -1;
}

inline void B2String::replace(char const oldc, char const newc)
{
	if (data != NULL)
	{
		for (int c = 0; c < (int)strlen(data); c++)
		{
			if (data[c] == oldc)
				data[c] = newc;
		}
	}
}

#endif
